#!/bin/sh
#
# Generate version.h.

if [ -f ../inc/version.h ] ; then
BUILD=`fgrep '#define BUILD' ../inc/version.h | sed 's/^#define BUILD.*"\([0-9]*\)".*$/\1/'`
BUILD=`expr $BUILD + 1`
else
	BUILD=1
fi

cat >../inc/version.h <<EOF
/* Version information

   OperStats - Copyright (c) 2000-2003 Darcy Grexton
   Contact: skold@habber.net, skold @ HabberNet

   See doc/LICENSE for licensing details.
 */

#define BUILD "$BUILD"

const char version[] = "$1";
const char build[] = "$BUILD";
const char compile_time[] = "`date | \
awk '{if (NF == 6) \
	 { print $1 " "  $2 " " $3 " "  $6 " at " $4 " " $5 } \
else \
	 { print $1 " "  $2 " " $3 " " $7 " at " $4 " " $5 " " $6 }}'`";

const char *infotext[] =
{
    "OperStats --",
    "Copyright (c) 2000-2003 Darcy Grexton <skold@habber.net>",
#ifdef WIN32
    "Ported to Win32 by Matthew Millman <matthew.m@ihug.co.nz>",
#endif
    " ",
    "All rights reserved.",
    " ",
    "Redistribution and use in source and binary forms, with or without modification,",
    "are permitted provided that the following conditions are met:",
    " ",
    "      Redistributions of source code must retain the above copyright notice,",
    "      this list of conditions and the following disclaimer.",
    " ",
    "      Redistributions in binary form must reproduce the above copyright notice,",
    "      this list of conditions and the following disclaimer in the documentation",
    "      and/or other materials provided with the distribution.",
    " ",
    "      Neither the name of the author nor the names of its contributors may be",
    "      used to endorse or promote products derived from this software without",
    "      specific prior written permission.",
    " ",
    "THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS \"AS IS\" AND",
    "ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED",
    "WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE",
    "DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR",
    "ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES",
    "(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;",
    "LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON",
    "ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT",
    "(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS",
    "SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.",
    " ",
    "The following people have donated money or hardware to the developer:",
    " ",
    "madragoran         Mike Campbell      madragoran@avendesora.net",
    "Lan                Eric Will          daishan@malkier.net",
    " ",
    0,
};
EOF
