/* OperStats Help Files

   OperStats - Copyright (c) 2000-2003 Darcy Grexton
   Contact: skold@habber.net, skold @ HabberNet

   See doc/LICENSE for licensing details.
 */

#include "../inc/operstats.h"

void statserv_help_index (User *u)
{
    notice (s_StatServ, u->nick, RPL_HELP_START, s_StatServ);
    notice (s_StatServ, u->nick, " ");
    notice (s_StatServ, u->nick, "\2%s\2 monitors the network in various ways, and", s_StatServ);
    notice (s_StatServ, u->nick, "provides statistics about the network and its users.");
    notice (s_StatServ, u->nick, " ");
    notice (s_StatServ, u->nick, "For more information on a specific topic, type:");
    notice (s_StatServ, u->nick, "/%s%s%s%s HELP Topic\2", haveserv_on == TRUE ? "" :
	"MSG ", s_StatServ, haveserv_on == TRUE ? "" : securitysetting == 1 ? "@" :
	"", haveserv_on == TRUE ? "" : securitysetting == 1 ? me.name : "");
    notice (s_StatServ, u->nick, " ");
    notice (s_StatServ, u->nick, "\2%s\2 contains information on the following topics:", s_StatServ);
    notice (s_StatServ, u->nick, " ");

    if (helpindex == 1)
    {
	char buf[2048];

	*buf = 0;

	/* Build a buffer of commands to list and throw it at helpcolumns */
	strcat (buf, "STATS MAP SERVERS ");

	if (tldlookup == TRUE)
	    strcat (buf, "TLD TLDMAP TLDSTATS ");

	if (zonelookup == TRUE)
	    strcat (buf, "ZONE ");

	if (operserv_on == FALSE)
	{
	    if (is_oper (u))
		strcat (buf, "SEARCH AUTH ");
	    if (is_sra (u))
		strcat (buf, "DEAUTH SHUTDOWN RESTART DEBUG UPDATE REHASH CYCLELOGS SETTINGS ");

#ifdef RAWINJECT
	    if (is_sra (u))
		strcat (buf, "RAW INJECT ");
#endif
	}

	if (is_sra (u))
	    strcat (buf, "FLUSH RESET SENDPINGS ");

	helpcolumns (u, s_StatServ, "", buf);
    }

    else if (helpindex == 2)
    {
	char buf[2048];

	*buf = 0;

	notice (s_StatServ, u->nick, "\2STATS\2           Show statistics on the network");
	notice (s_StatServ, u->nick, "\2MAP\2             Show a map of the network");
	notice (s_StatServ, u->nick, "\2SERVERS\2         Show a listing of servers and versions");

	if (tldlookup == TRUE)
	    notice (s_StatServ, u->nick, "\2TLD\2             Show the country associated with a TLD");

	if (zonelookup == TRUE)
	    notice (s_StatServ, u->nick, "\2ZONE\2            Perform a TimeZone lookup");

	if (operserv_on == FALSE && is_oper (u))
	    notice (s_StatServ, u->nick, "\2AUTH\2            Authenticate as an SRA");

	notice (s_StatServ, u->nick, " ");

	/* Build a buffer of commands to list and throw it at helpcolumns */
	if (tldlookup == TRUE)
	    strcat (buf, "TLDMAP TLDSTATS ");

	if (operserv_on == FALSE)
	{
	    if (is_oper (u))
		strcat (buf, "SEARCH ");

	    if (is_sra (u))
		strcat (buf, "DEAUTH SHUTDOWN RESTART DEBUG UPDATE REHASH CYCLELOGS SETTINGS ");

#ifdef RAWINJECT
	    if (is_sra (u))
		strcat (buf, "RAW INJECT ");
#endif
	}

	if (is_sra (u))
	    strcat (buf, "FLUSH RESET SENDPINGS ");

	helpcolumns (u, s_StatServ, "Other commands: ", buf);
    }

    else if (helpindex == 3)
    {
	notice (s_StatServ, u->nick, "\2STATS\2           Show statistics on the network");
	notice (s_StatServ, u->nick, "\2MAP\2             Show a map of the network");
	notice (s_StatServ, u->nick, "\2SERVERS\2         Show a listing of servers and versions");

	if (tldlookup == TRUE)
	{
	    notice (s_StatServ, u->nick, "\2TLD\2             Show the country associated with a TLD");
	    notice (s_StatServ, u->nick, "\2TLDMAP\2          Show per-TLD user counts");
	    notice (s_StatServ, u->nick, "\2TLDSTATS\2        Show per-TLD daily stats");
	}

	if (zonelookup == TRUE)
	    notice (s_StatServ, u->nick, "\2ZONE\2            Perform a TimeZone lookup");

	if (operserv_on == FALSE && is_oper (u))
	{
	    notice (s_StatServ, u->nick, "\2SEARCH\2          Search OperStats's logfile");
	    notice (s_StatServ, u->nick, "\2AUTH\2            Authenticate as an SRA");
	}

	if (operserv_on == FALSE && is_sra (u))
	{
	    notice (s_StatServ, u->nick, "\2DEAUTH\2          De-Authenticate as an SRA");
	    notice (s_StatServ, u->nick, "\2SHUTDOWN\2        Terminate OperStats");
	    notice (s_StatServ, u->nick, "\2RESTART\2         Restart OperStats");
	    notice (s_StatServ, u->nick, "\2DEBUG\2           Set debugging level");
	    notice (s_StatServ, u->nick, "\2UPDATE\2          Force a database update");
	    notice (s_StatServ, u->nick, "\2REHASH\2          Re-Read %s", CONFIGFILE);
	    notice (s_StatServ, u->nick, "\2SETTINGS\2        Show various OperStats settings");
#ifdef RAWINJECT
	    notice (s_StatServ, u->nick, "\2RAW\2             Send information to the uplink");
	    notice (s_StatServ, u->nick, "\2INJECT\2          Fake information from the uplink");
#endif
	}

	if (is_sra (u))
	{
	    notice (s_StatServ, u->nick, "\2FLUSH\2           Flush a server from memory");
	    notice (s_StatServ, u->nick, "\2RESET\2           Reset one or all server's statistics");
	    notice (s_StatServ, u->nick, "\2SENDPINGS\2       Force an update of %s's lag times",
		s_StatServ);
	}
    }

    notice (s_StatServ, u->nick, " ");
    notice (s_StatServ, u->nick, RPL_HELP_END);
}

void statserv_help_stats (User *u)
{
    notice (s_StatServ, u->nick, RPL_HELP_START, s_StatServ);
    notice (s_StatServ, u->nick, " ");

    if (is_oper (u))
	notice (s_StatServ, u->nick, "Syntax: \2STATS [+CMNUD|Server]\2");
    else
	notice (s_StatServ, u->nick, "Syntax: \2STATS [+CMNUD]\2");

    notice (s_StatServ, u->nick, " ");
    notice (s_StatServ, u->nick, "Shows various information about the network, such as how many");
    notice (s_StatServ, u->nick, "users servers and channels there are, how fast the network is");
    notice (s_StatServ, u->nick, "running, and max user, server and channel counts. \2STATS\2 also");
    notice (s_StatServ, u->nick, "shows daily channel, user and server records, and when they were");
    notice (s_StatServ, u->nick, "set during the day. These stats are reset at midnight, GMT.");
    notice (s_StatServ, u->nick, " ");
    notice (s_StatServ, u->nick, "If any of the tokens CMNUD are given, the STATS output is filtered");
    notice (s_StatServ, u->nick, "to match these tokens. The token string must be preceded by a +.");
    notice (s_StatServ, u->nick, "Each token corresponds to a particular part of the full STATS output:");
    notice (s_StatServ, u->nick, "     C - Show Current Stats (Users, Channels, Servers, Time)");
    notice (s_StatServ, u->nick, "     M - Show Max Stats (Users, Channels, Servers, Hits, and Times)");
    notice (s_StatServ, u->nick, "     N - Show NetSpeed Stat");
    notice (s_StatServ, u->nick, "     U - Show Uptime Stat");
    notice (s_StatServ, u->nick, "     D - Show Daily Stats (Hits, Users, Channels, Servers)");
    notice (s_StatServ, u->nick, " ");

    if (is_oper (u))
    {
	notice (s_StatServ, u->nick, "If you provide a server name, statistics for that server will");
	notice (s_StatServ, u->nick, "be shown.");
	notice (s_StatServ, u->nick, " ");
    }

    notice (s_StatServ, u->nick, "Examples: \2STATS\2");
    notice (s_StatServ, u->nick, "          \2STATS +CMNUD\2");

    if (is_oper (u))
	notice (s_StatServ, u->nick, "          \2STATS server.*\2");

    notice (s_StatServ, u->nick, " ");
    notice (s_StatServ, u->nick, RPL_HELP_END);
}

void statserv_help_tld (User *u)
{
    notice (s_StatServ, u->nick, RPL_HELP_START, s_StatServ);
    notice (s_StatServ, u->nick, " ");
    notice (s_StatServ, u->nick, "Syntax: \2TLD TopLevelDomain|Country\2");
    notice (s_StatServ, u->nick, " ");
    notice (s_StatServ, u->nick, "Show which country or organization a given top-level domain");
    notice (s_StatServ, u->nick, "represents. \2%s\2 will match the TLD with wildcards, so", s_StatServ);
    notice (s_StatServ, u->nick, "providing a domain may give a false match. Additionally, you may");
    notice (s_StatServ, u->nick, "give the name of the country to see which TLD is associated with it.");
    notice (s_StatServ, u->nick, " ");
    notice (s_StatServ, u->nick, "Examples: \2TLD ca\2");
    notice (s_StatServ, u->nick, "          \2TLD Canada\2");
    notice (s_StatServ, u->nick, " ");
    notice (s_StatServ, u->nick, RPL_HELP_END);
}

void statserv_help_tldmap (User *u)
{
    notice (s_StatServ, u->nick, RPL_HELP_START, s_StatServ);
    notice (s_StatServ, u->nick, " ");
    notice (s_StatServ, u->nick, "Syntax: \2TLDMAP [TLD]\2");
    notice (s_StatServ, u->nick, " ");
    notice (s_StatServ, u->nick, "Shows you the user counts per top-level-domain. If you specify");
    notice (s_StatServ, u->nick, "a TLD, only that TLD will be shown.");
    notice (s_StatServ, u->nick, " ");
    notice (s_StatServ, u->nick, "Examples: \2TLDMAP\2");
    notice (s_StatServ, u->nick, "          \2TLDMAP net\2");
    notice (s_StatServ, u->nick, " ");
    notice (s_StatServ, u->nick, RPL_HELP_END);
}

void statserv_help_tldstats (User *u)
{
    notice (s_StatServ, u->nick, RPL_HELP_START, s_StatServ);
    notice (s_StatServ, u->nick, " ");
    notice (s_StatServ, u->nick, "Syntax: \2TLDSTATS [TLD]\2");
    notice (s_StatServ, u->nick, " ");
    notice (s_StatServ, u->nick, "Shows you the daily hit counts per top-level-domain. If you");
    notice (s_StatServ, u->nick, "specify a TLD, only that TLD will be shown.");
    notice (s_StatServ, u->nick, " ");
    notice (s_StatServ, u->nick, "Examples: \2TLDSTATS\2");
    notice (s_StatServ, u->nick, "          \2TLDSTATS net\2");
    notice (s_StatServ, u->nick, " ");
    notice (s_StatServ, u->nick, RPL_HELP_END);
}

void statserv_help_zone (User *u)
{
    notice (s_StatServ, u->nick, RPL_HELP_START, s_StatServ);
    notice (s_StatServ, u->nick, " ");
    notice (s_StatServ, u->nick, "Syntax: \2ZONE TimeZone\2");
    notice (s_StatServ, u->nick, " ");
    notice (s_StatServ, u->nick, "Performs a TimeZone lookup. If the TimeZone is found, the");
    notice (s_StatServ, u->nick, "TimeZone name, GMT Offset, and current time will be displayed.");
    notice (s_StatServ, u->nick, " ");
    notice (s_StatServ, u->nick, "Note that several TimeZones share the same abbreviation, so you");
    notice (s_StatServ, u->nick, "may get more than one result.");
    notice (s_StatServ, u->nick, " ");
    notice (s_StatServ, u->nick, "Also remember Daylight Savings Time; PDT and PST are NOT the");
    notice (s_StatServ, u->nick, "same thing! Depending on the time of year, either one may be");
    notice (s_StatServ, u->nick, "correct.");
    notice (s_StatServ, u->nick, " ");
    notice (s_StatServ, u->nick, "Example: \2ZONE GMT\2");
    notice (s_StatServ, u->nick, " ");
    notice (s_StatServ, u->nick, RPL_HELP_END);
}

void statserv_help_map (User *u)
{
    notice (s_StatServ, u->nick, RPL_HELP_START, s_StatServ);
    notice (s_StatServ, u->nick, " ");
    notice (s_StatServ, u->nick, "Syntax: \2MAP\2");
    notice (s_StatServ, u->nick, " ");
    notice (s_StatServ, u->nick, "Shows a map of how the network is currently structured. A breakdown");
    notice (s_StatServ, u->nick, "of the users-per-server and the server's current ping time are also");
    notice (s_StatServ, u->nick, "included.");
    notice (s_StatServ, u->nick, " ");
    notice (s_StatServ, u->nick, "Example: \2MAP\2");
    notice (s_StatServ, u->nick, " ");
    notice (s_StatServ, u->nick, RPL_HELP_END);
}

void statserv_help_servers (User *u)
{
    notice (s_StatServ, u->nick, RPL_HELP_START, s_StatServ);
    notice (s_StatServ, u->nick, " ");
    notice (s_StatServ, u->nick, "Syntax: \2SERVERS\2");
    notice (s_StatServ, u->nick, " ");
    notice (s_StatServ, u->nick, "Shows a list of the servers currently on the network, what");
    notice (s_StatServ, u->nick, "version of IRCd they are running, and how they are configured.");
    notice (s_StatServ, u->nick, " ");
    notice (s_StatServ, u->nick, "Example: \2SERVERS\2");
    notice (s_StatServ, u->nick, " ");
    notice (s_StatServ, u->nick, RPL_HELP_END);
}

void statserv_help_sendpings (User *u)
{
    notice (s_StatServ, u->nick, RPL_HELP_START, s_StatServ);
    notice (s_StatServ, u->nick, " ");
    notice (s_StatServ, u->nick, "Syntax: \2SENDPINGS\2");
    notice (s_StatServ, u->nick, " ");
    notice (s_StatServ, u->nick, "Forces %s to update it's lag times for MAP. All", s_StatServ);
    notice (s_StatServ, u->nick, "servers will be pinged simultaneously, and this may cause a");
    notice (s_StatServ, u->nick, "small lag spike. The PING times are updated automatically as");
    notice (s_StatServ, u->nick, "defined in %s.", CONFIGFILE);
    notice (s_StatServ, u->nick, " ");
    notice (s_StatServ, u->nick, "Example: \2SENDPINGS\2");
    notice (s_StatServ, u->nick, " ");
    notice (s_StatServ, u->nick, RPL_HELP_END);
}

void statserv_help_flush (User *u)
{
    notice (s_StatServ, u->nick, RPL_HELP_START, s_StatServ);
    notice (s_StatServ, u->nick, " ");
    notice (s_StatServ, u->nick, "Syntax: \2FLUSH Server\2");
    notice (s_StatServ, u->nick, " ");
    notice (s_StatServ, u->nick, "Removes a server from memory. This should only be used when");
    notice (s_StatServ, u->nick, "the server has permanently left the network. The server will");
    notice (s_StatServ, u->nick, "be re-entered into memory if it is seen again. If you want to");
    notice (s_StatServ, u->nick, "reset a server's statistics, see the \2RESET\2 command.");
    notice (s_StatServ, u->nick, " ");
    notice (s_StatServ, u->nick, "Example: \2FLUSH server.example.net\2");
    notice (s_StatServ, u->nick, " ");
    notice (s_StatServ, u->nick, RPL_HELP_END);
}

void statserv_help_reset (User *u)
{
    notice (s_StatServ, u->nick, RPL_HELP_START, s_StatServ);
    notice (s_StatServ, u->nick, " ");
    notice (s_StatServ, u->nick, "Syntax: \2RESET Server|All\2");
    notice (s_StatServ, u->nick, " ");
    notice (s_StatServ, u->nick, "Resets the given server's statistics. This will not remove the");
    notice (s_StatServ, u->nick, "server from memory, only reset its stats. If you want to remove");
    notice (s_StatServ, u->nick, "a server (i.e., in the event of a delink), see the \2FLUSH\2 command.");
    notice (s_StatServ, u->nick, " ");
    notice (s_StatServ, u->nick, "If you give \2ALL\2 in place of a server name, then statistics for");
    notice (s_StatServ, u->nick, "all servers will be reset.");
    notice (s_StatServ, u->nick, " ");
    notice (s_StatServ, u->nick, "Examples: \2RESET server.example.net\2");
    notice (s_StatServ, u->nick, "          \2RESET ALL\2");
    notice (s_StatServ, u->nick, " ");
    notice (s_StatServ, u->nick, RPL_HELP_END);
}

void operserv_help_index (User *u)
{
    notice (s_OperServ, u->nick, RPL_HELP_START, s_OperServ);
    notice (s_OperServ, u->nick, " ");
    notice (s_OperServ, u->nick, "\2%s\2 gives IRC Operators greater control over", s_OperServ);
    notice (s_OperServ, u->nick, "the network through the use of JUPEs, AKILLs, and other");
    notice (s_OperServ, u->nick, "commands.");
    notice (s_OperServ, u->nick, " ");
    notice (s_OperServ, u->nick, "For more information on a specific topic, type:");
    notice (s_OperServ, u->nick, "/%s%s%s%s HELP Topic\2", haveserv_on == TRUE ? "" :
	"MSG ", s_OperServ, haveserv_on == TRUE ? "" : securitysetting == 1 ? "@" :
	"", haveserv_on == TRUE ? "" : securitysetting == 1 ? me.name : "");
    notice (s_OperServ, u->nick, " ");
    notice (s_OperServ, u->nick, "\2%s\2 contains information on the following topics:", s_OperServ);
    notice (s_OperServ, u->nick, " ");

    if (helpindex == 1)
    {
	char buf[2048];

	*buf = 0;

	/* Build a buffer of commands to list and throw it at helpcolumns */
	strcat (buf, "JUPE AKILL SEARCH ");

	if (statserv_on == FALSE)
	    strcat (buf, "STATS ");

	if (maxclones)
	    strcat (buf, "CLONES TRIGGER EXCEPTION ");

	if (globalnoticer_on == TRUE)
	    strcat (buf, "GLOBAL ");

	strcat (buf, "AUTH ");

	if (is_sra (u))
	{
	    strcat (buf, "DEAUTH SHUTDOWN RESTART DEBUG UPDATE REHASH SETTINGS CYCLELOGS ");

#ifdef RAWINJECT
	    strcat (buf, "RAW INJECT ");
#endif

	    if (globalnoticer_on == TRUE)
		strcat (buf, "LOGONMSG ");
	}

	helpcolumns (u, s_OperServ, "", buf);
    }

    else if (helpindex == 2)
    {
	char buf[2048];

	*buf = 0;

	notice (s_OperServ, u->nick, "\2JUPE\2            Jupiter a server or nick");
	notice (s_OperServ, u->nick, "\2AKILL\2           Add, Remove, or List AutoKills");
	notice (s_OperServ, u->nick, "\2AUTH\2            Authenticate as an SRA");

	if (statserv_on == FALSE)
	    notice (s_OperServ, u->nick, "\2STATS\2           Show OperStats statistics");

	if (maxclones)
	{
	    notice (s_OperServ, u->nick, "\2CLONES\2          List the current clones on the network");
	    notice (s_OperServ, u->nick, "\2TRIGGER\2         Add, Remove, or List Triggers");
	    notice (s_OperServ, u->nick, "\2EXCEPTION\2       Add, Remove, or List Exceptions");
	}

	notice (s_OperServ, u->nick, " ");

	strcat (buf, "SEARCH ");

	if (globalnoticer_on == TRUE)
	    strcat (buf, "GLOBAL ");

	/* Build a buffer of commands to list and throw it at helpcolumns */
	if (is_sra (u))
	{
	    strcat (buf, "DEAUTH SHUTDOWN RESTART DEBUG UPDATE REHASH SETTINGS CYCLELOGS ");

#ifdef RAWINJECT
	    strcat (buf, "RAW INJECT ");
#endif

	    if (globalnoticer_on == TRUE)
		strcat (buf, "LOGONMSG ");
	}

	helpcolumns (u, s_OperServ, "Other commands: ", buf);
    }

    else if (helpindex == 3)
    {
	notice (s_OperServ, u->nick, "\2JUPE\2            Jupiter a server or nick");
	notice (s_OperServ, u->nick, "\2AKILL\2           Add, Remove, or List AutoKills");

	if (maxclones)
	{
	    notice (s_OperServ, u->nick, "\2CLONES\2          List the current clones on the network");
	    notice (s_OperServ, u->nick, "\2TRIGGER\2         Add, Remove, or List Triggers");
	    notice (s_OperServ, u->nick, "\2EXCEPTION\2       Add, Remove, or List Exceptions");
	}

	notice (s_OperServ, u->nick, "\2SEARCH\2          Search OperStats's logfile");
	notice (s_OperServ, u->nick, "\2AUTH\2            Authenticate as an SRA");

	if (statserv_on == FALSE)
	    notice (s_OperServ, u->nick, "\2STATS\2           Show OperStats statistics");

	if (globalnoticer_on == TRUE)
	    notice (s_OperServ, u->nick, "\2GLOBAL\2          Send a global notice");

	if (is_sra (u))
	{
	    notice (s_OperServ, u->nick, "\2DEAUTH\2          De-Authenticate as an SRA");
	    notice (s_OperServ, u->nick, "\2SHUTDOWN\2        Terminate OperStats");
	    notice (s_OperServ, u->nick, "\2RESTART\2         Restart OperStats");
#ifdef RAWINJECT
	    notice (s_OperServ, u->nick, "\2RAW\2             Send information to the uplink");
	    notice (s_OperServ, u->nick, "\2INJECT\2          Fake information from the uplink");
#endif
	    notice (s_OperServ, u->nick, "\2DEBUG\2           Set debugging level");
	    notice (s_OperServ, u->nick, "\2UPDATE\2          Force a database update");
	    notice (s_OperServ, u->nick, "\2REHASH\2          Re-Read %s", CONFIGFILE);
	    notice (s_OperServ, u->nick, "\2CYCLELOGS\2       Close and reopen OperStats' logfiles");
	    notice (s_OperServ, u->nick, "\2SETTINGS\2        Show various OperStats settings");

	    if (globalnoticer_on == TRUE)
		notice (s_OperServ, u->nick, "\2LOGONMSG\2        Add, Remove, or List LogonMSGs");
	}
    }

    notice (s_OperServ, u->nick, " ");
    notice (s_OperServ, u->nick, RPL_HELP_END);
}

void operserv_help_global (User *u)
{
    notice (s_OperServ, u->nick, RPL_HELP_START, s_OperServ);
    notice (s_OperServ, u->nick, " ");
    notice (s_OperServ, u->nick, "Syntax: \2GLOBAL [Destination] Message\2");
    notice (s_OperServ, u->nick, " ");
    notice (s_OperServ, u->nick, "Sends a global notice. If your TLD setting is correct, all users");
    notice (s_OperServ, u->nick, "on the network will see the notice.");
    notice (s_OperServ, u->nick, " ");
    notice (s_OperServ, u->nick, "If you specify a destination, the notice will go there.");
    notice (s_OperServ, u->nick, "The GlobalMSG setting has no effect when a destination is specified.");
    notice (s_OperServ, u->nick, " ");
    notice (s_OperServ, u->nick, "Examples: \2GLOBAL We are doing some routing.\2");
    notice (s_OperServ, u->nick, "          \2GLOBAL !S net We are doing some routing.\2");
    notice (s_OperServ, u->nick, "          \2GLOBAL !S server.example.net This server is shutting down.");
    notice (s_OperServ, u->nick, " ");
    notice (s_OperServ, u->nick, RPL_HELP_END);
}

void operserv_help_jupe (User *u)
{
    notice (s_OperServ, u->nick, RPL_HELP_START, s_OperServ);
    notice (s_OperServ, u->nick, " ");
    notice (s_OperServ, u->nick, "Syntax: \2JUPE Server|User [Reason]\2");
    notice (s_OperServ, u->nick, " ");
    notice (s_OperServ, u->nick, "Jupiters the specified server or user. This will remove");
    notice (s_OperServ, u->nick, "the server or user from the network if it already exists.");
    notice (s_OperServ, u->nick, "Jupes will remain in place until SQUIT/KILLed, or until");
    notice (s_OperServ, u->nick, "OperStats is reset. If a reason is given, it will be used");
    notice (s_OperServ, u->nick, "in any SQUIT/KILL of an existing server/user, and in the");
    notice (s_OperServ, u->nick, "jupe's description/realname.");
    notice (s_OperServ, u->nick, " ");
    notice (s_OperServ, u->nick, "Examples: \2JUPE server.example.net Delinked\2");
    notice (s_OperServ, u->nick, "          \2JUPE someuser This nick may not be used.\2");
    notice (s_OperServ, u->nick, " ");
    notice (s_OperServ, u->nick, RPL_HELP_END);
}

void operserv_help_clones (User *u)
{
    notice (s_OperServ, u->nick, RPL_HELP_START, s_OperServ);
    notice (s_OperServ, u->nick, " ");
    notice (s_OperServ, u->nick, "Syntax: \2CLONES Pattern [Limit]\2");
    notice (s_OperServ, u->nick, " ");
    notice (s_OperServ, u->nick, "Lists the current clones on the network. Only hostnames matching");
    notice (s_OperServ, u->nick, "Pattern will be shown. Use * to show all clones. If you give Limit,");
    notice (s_OperServ, u->nick, "only Limit matching hosts will be shown.");
    notice (s_OperServ, u->nick, " ");
    notice (s_OperServ, u->nick, "Regardless of the given Limit, no more than 250 matches will be shown.");
    notice (s_OperServ, u->nick, " ");
    notice (s_OperServ, u->nick, "Examples: \2CLONES *hostname.com 25\2");
    notice (s_OperServ, u->nick, "          \2CLONES *\2");
    notice (s_OperServ, u->nick, " ");
    notice (s_OperServ, u->nick, RPL_HELP_END);
}

void operserv_help_akill (User *u)
{
    notice (s_OperServ, u->nick, RPL_HELP_START, s_OperServ);
    notice (s_OperServ, u->nick, " ");
    notice (s_OperServ, u->nick, "Syntax: \2AKILL ADD|DEL|LIST [Mask|Number|Option]\2");
    notice (s_OperServ, u->nick, " ");
    notice (s_OperServ, u->nick, "Allows you to add, remove, or list AutoKills. There are a");
    notice (s_OperServ, u->nick, "number of parameters for each command:");
    notice (s_OperServ, u->nick, " ");
    notice (s_OperServ, u->nick, "\2ADD Mask|Nick [!P] [!R] [!T Expire Time] Reason\2 - The expire");
    notice (s_OperServ, u->nick, "time is optional. If no expire time is given, the default will");
    notice (s_OperServ, u->nick, "be used. Expire times are in the format of Days, Hours, Minutes,");
    notice (s_OperServ, u->nick, "Seconds. For example, an expire time of 5 days, 1 hour and 30");
    notice (s_OperServ, u->nick, "minutes would be 5d1h30m. You must give the \2!T\2 token to");
    notice (s_OperServ, u->nick, "have an expire time understood. If the \2!R\2 token is given,");
    notice (s_OperServ, u->nick, "OperStats will treat the mask as a realname, and will AKill");
    notice (s_OperServ, u->nick, "any users with matching realnames. If the \2!P\2 token is given,");
    notice (s_OperServ, u->nick, "the AKill will never expire. If both the \2!T\2 and \2!P\2 tokens are");
    notice (s_OperServ, u->nick, "given, The \2!P\2 token will have no effect. If you give a nickname");
    notice (s_OperServ, u->nick, "instead of a mask, OperStats will find that user's mask and");
    notice (s_OperServ, u->nick, "AutoKill it. If the user is not online, you will have to provide");
    notice (s_OperServ, u->nick, "a valid mask. The \2!P\2 token must always be given before the \2!R\2");
    notice (s_OperServ, u->nick, "token, and the \2!R\2 token must always be given before the \2!T\2");
    notice (s_OperServ, u->nick, "token.");
    notice (s_OperServ, u->nick, " ");
    notice (s_OperServ, u->nick, "\2DEL Mask|Number|ALL\2 - Remove an AutoKill.");
    notice (s_OperServ, u->nick, " ");
    notice (s_OperServ, u->nick, "\2LIST [FULL] [Match]\2 - Search for an AKill. If the");
    notice (s_OperServ, u->nick, "first parameter is \2FULL\2, AKill reasons will be displayed,");
    notice (s_OperServ, u->nick, "otherwise they will be omitted. If \2Match\2 is specified, it");
    notice (s_OperServ, u->nick, "will be matched against the AKill mask and setter.");
    notice (s_OperServ, u->nick, " ");
    notice (s_OperServ, u->nick, "Examples: \2AKILL ADD *@*.someisp.com You are not welcome.\2");
    notice (s_OperServ, u->nick, "          \2AKILL ADD *@*.someisp.com !T 5d1h30m You are not welcome.\2");
    notice (s_OperServ, u->nick, "          \2AKILL ADD *@*.someisp.com !P You are not welcome.\2");
    notice (s_OperServ, u->nick, "          \2AKILL ADD *sub7* !R Sub7 - You are not welcome.\2");
    notice (s_OperServ, u->nick, "          \2AKILL ADD *sub7* !R !T 10d Sub7 - You are not welcome.\2");
    notice (s_OperServ, u->nick, "          \2AKILL DEL *@*.someisp.com\2");
    notice (s_OperServ, u->nick, "          \2AKILL DEL 25\2");
    notice (s_OperServ, u->nick, "          \2AKILL DEL ALL\2");
    notice (s_OperServ, u->nick, "          \2AKILL LIST\2");
    notice (s_OperServ, u->nick, "          \2AKILL LIST *match*\2");
    notice (s_OperServ, u->nick, "          \2AKILL LIST FULL\2");
    notice (s_OperServ, u->nick, "          \2AKILL LIST FULL *match*\2");
    notice (s_OperServ, u->nick, " ");
    notice (s_OperServ, u->nick, RPL_HELP_END);
}

void operserv_help_stats (User *u)
{
    notice (s_OperServ, u->nick, RPL_HELP_START, s_OperServ);
    notice (s_OperServ, u->nick, " ");
    notice (s_OperServ, u->nick, "Syntax: \2STATS\2");
    notice (s_OperServ, u->nick, " ");
    notice (s_OperServ, u->nick, "Displays current user, channel and server counts on the");
    notice (s_OperServ, u->nick, "network, current uptime, and highest uptime.");
    notice (s_OperServ, u->nick, " ");
    notice (s_OperServ, u->nick, "Example: \2STATS\2");
    notice (s_OperServ, u->nick, " ");
    notice (s_OperServ, u->nick, RPL_HELP_END);
}

void operserv_help_trigger (User *u)
{
    notice (s_OperServ, u->nick, RPL_HELP_START, s_OperServ);
    notice (s_OperServ, u->nick, " ");
    notice (s_OperServ, u->nick, "Syntax: \2TRIGGER ADD|DEL|LIST [Host|Number|ALL] [Limit]");
    notice (s_OperServ, u->nick, " ");
    notice (s_OperServ, u->nick, "Allows you to add, remove or list Triggers. A Trigger allows");
    notice (s_OperServ, u->nick, "the Triggered host to have the defined number of connections.");
    notice (s_OperServ, u->nick, "This allows you to set individual limits for certain hosts, such");
    notice (s_OperServ, u->nick, "as your network's channel and nickname services.");
    notice (s_OperServ, u->nick, " ");
    notice (s_OperServ, u->nick, "Examples: \2TRIGGER ADD service@example.net 20\2");
    notice (s_OperServ, u->nick, "          \2TRIGGER DEL 1\2");
    notice (s_OperServ, u->nick, "          \2TRIGGER DEL ALL\2");
    notice (s_OperServ, u->nick, "          \2TRIGGER DEL service@example.net\2");
    notice (s_OperServ, u->nick, "          \2TRIGGER LIST\2");
    notice (s_OperServ, u->nick, " ");
    notice (s_OperServ, u->nick, RPL_HELP_END);
}

void operserv_help_exception (User *u)
{
    notice (s_OperServ, u->nick, RPL_HELP_START, s_OperServ);
    notice (s_OperServ, u->nick, " ");
    notice (s_OperServ, u->nick, "Syntax: \2EXCEPTION ADD|DEL|LIST [Host|Number|ALL]");
    notice (s_OperServ, u->nick, " ");
    notice (s_OperServ, u->nick, "Allows you to add, remove or list Exceptions. An Exception allows");
    notice (s_OperServ, u->nick, "the specified host to have total immunity to clone detection.");
    notice (s_OperServ, u->nick, "Exceptions also override any Trigger-set limits.");
    notice (s_OperServ, u->nick, " ");
    notice (s_OperServ, u->nick, "Examples: \2EXCEPTION ADD service@example.net\2");
    notice (s_OperServ, u->nick, "          \2EXCEPTION DEL 1\2");
    notice (s_OperServ, u->nick, "          \2EXCEPTION DEL ALL\2");
    notice (s_OperServ, u->nick, "          \2EXCEPTION DEL service@example.net\2");
    notice (s_OperServ, u->nick, "          \2EXCEPTION LIST\2");
    notice (s_OperServ, u->nick, " ");
    notice (s_OperServ, u->nick, RPL_HELP_END);
}

void operserv_help_logonmsg (User *u)
{
    notice (s_OperServ, u->nick, RPL_HELP_START, s_OperServ);
    notice (s_OperServ, u->nick, " ");
    notice (s_OperServ, u->nick, "Syntax: \2LOGONMSG ADD|DEL|LIST [Text|Number|ALL]");
    notice (s_OperServ, u->nick, " ");
    notice (s_OperServ, u->nick, "Allows you to add, remove or list LogonMSGs. The syntax for");
    notice (s_OperServ, u->nick, "each command is as follows:");
    notice (s_OperServ, u->nick, " ");
    notice (s_OperServ, u->nick, "\2ADD Text for LogonMSG\2");
    notice (s_OperServ, u->nick, "\2DEL Number|ALL\2");
    notice (s_OperServ, u->nick, "\2LIST\2");
    notice (s_OperServ, u->nick, " ");
    notice (s_OperServ, u->nick, "Due to the nature of LogonMSGs, \2DEL\2 and \2LIST\2 do not");
    notice (s_OperServ, u->nick, "attempt any matching against the message contents.");
    notice (s_OperServ, u->nick, " ");
    notice (s_OperServ, u->nick, "Examples: \2LOGONMSG ADD Welcome to %s!\2", network_name);
    notice (s_OperServ, u->nick, "          \2LOGONMSG DEL 1\2");
    notice (s_OperServ, u->nick, "          \2LOGONMSG DEL ALL\2");
    notice (s_OperServ, u->nick, "          \2LOGONMSG LIST\2");
    notice (s_OperServ, u->nick, " ");
    notice (s_OperServ, u->nick, RPL_HELP_END);
}

void shared_help_auth (User *u)
{
    char *whoami = authserv ();

    notice (whoami, u->nick, RPL_HELP_START, whoami);
    notice (whoami, u->nick, " ");
    notice (whoami, u->nick, "Syntax: \2AUTH NickName Password\2");
    notice (whoami, u->nick, " ");
    notice (whoami, u->nick, "Allows you to authenticate for SRA access. Once you have");
    notice (whoami, u->nick, "authenticated, you will be recognized as an SRA until you");
    notice (whoami, u->nick, "disconnect from the network or \2DEAUTH\2.");
    notice (whoami, u->nick, " ");
    notice (whoami, u->nick, "Example: \2AUTH SRANick SRAPass\2");
    notice (whoami, u->nick, " ");
    notice (whoami, u->nick, RPL_HELP_END);
}

void shared_help_deauth (User *u)
{
    char *whoami = authserv ();

    notice (whoami, u->nick, RPL_HELP_START, whoami);
    notice (whoami, u->nick, " ");
    notice (whoami, u->nick, "Syntax: \2DEAUTH\2");
    notice (whoami, u->nick, " ");
    notice (whoami, u->nick, "Causes you to no longer be recognized as an SRA. You will");
    notice (whoami, u->nick, "need to re-\2AUTH\2 to regain SRA access.");
    notice (whoami, u->nick, " ");
    notice (whoami, u->nick, "Example: \2DEAUTH\2");
    notice (whoami, u->nick, " ");
    notice (whoami, u->nick, RPL_HELP_END);
}

void shared_help_shutdown (User *u)
{
    char *whoami = authserv ();

    notice (whoami, u->nick, RPL_HELP_START, whoami);
    notice (whoami, u->nick, " ");
    notice (whoami, u->nick, "Syntax: \2SHUTDOWN [NOSAVE] [Reason]\2");
    notice (whoami, u->nick, " ");
    notice (whoami, u->nick, "Causes OperStats to terminate. If you give the NOSAVE token,");
    notice (whoami, u->nick, "the DBs will not be saved. Otherwise, they will be updated before");
    notice (whoami, u->nick, "OperStats shuts down. If you give a reason, this will be used in a");
    notice (whoami, u->nick, "GlobOps and a log entry.");
    notice (whoami, u->nick, " ");
    notice (whoami, u->nick, "Examples: \2SHUTDOWN\2");
    notice (whoami, u->nick, "          \2SHUTDOWN NOSAVE Reason\2");
    notice (whoami, u->nick, "          \2SHUTDOWN Reason\2");
    notice (whoami, u->nick, " ");
    notice (whoami, u->nick, RPL_HELP_END);
}

void shared_help_restart (User *u)
{
    char *whoami = authserv ();

    notice (whoami, u->nick, RPL_HELP_START, whoami);
    notice (whoami, u->nick, " ");
    notice (whoami, u->nick, "Syntax: \2RESTART [NOSAVE] [Reason]\2");
    notice (whoami, u->nick, " ");
    notice (whoami, u->nick, "Causes OperStats to restart. If you give the NOSAVE token,");
    notice (whoami, u->nick, "the DBs will not be saved. Otherwise, they will be updated before");
    notice (whoami, u->nick, "OperStats shuts down. If you give a reason, this will be used in a");
    notice (whoami, u->nick, "GlobOps and a log entry.");
    notice (whoami, u->nick, " ");
    notice (whoami, u->nick, "Examples: \2RESTART\2");
    notice (whoami, u->nick, "          \2RESTART NOSAVE Reason\2");
    notice (whoami, u->nick, "          \2RESTART Reason\2");
    notice (whoami, u->nick, " ");
    notice (whoami, u->nick, RPL_HELP_END);
}

void shared_help_search (User *u)
{
    char *whoami = authserv ();

    notice (whoami, u->nick, RPL_HELP_START, whoami);
    notice (whoami, u->nick, " ");
    notice (whoami, u->nick, "Syntax: \2SEARCH MatchText [Num]\2");
    notice (whoami, u->nick, " ");
    notice (whoami, u->nick, "Allows you to search OperStats' logfiles for specific text.");
    notice (whoami, u->nick, "If \2Num\2 is specified, that amount of matches will be shown.");
    notice (whoami, u->nick, "\2Num\2 defaults to 50, and cannot be more than 250.");
    notice (whoami, u->nick, " ");
    notice (whoami, u->nick, "Example: \2SEARCH *akill* 25\2");
    notice (whoami, u->nick, " ");
    notice (whoami, u->nick, RPL_HELP_END);
}

#ifdef RAWINJECT
void shared_help_raw (User *u)
{
    char *whoami = authserv ();

    notice (whoami, u->nick, RPL_HELP_START, whoami);
    notice (whoami, u->nick, " ");
    notice (whoami, u->nick, "Syntax: \2RAW Data\2");
    notice (whoami, u->nick, " ");
    notice (whoami, u->nick, "Sends information to OperStats' uplink. Syntax is important.");
    notice (whoami, u->nick, "There is no limit to what you can do with \2RAW\2, provided");
    notice (whoami, u->nick, "your IRCd supports it.");
    notice (whoami, u->nick, " ");
    notice (whoami, u->nick, "The \2RAW\2 command is not supported in any way.");
    notice (whoami, u->nick, " ");
    notice (whoami, u->nick, "Example: \2RAW SVSNICK OldNick NewNick :0\2");
    notice (whoami, u->nick, " ");
    notice (whoami, u->nick, RPL_HELP_END);
}

void shared_help_inject (User *u)
{
    char *whoami = authserv ();

    notice (whoami, u->nick, RPL_HELP_START, whoami);
    notice (whoami, u->nick, " ");
    notice (whoami, u->nick, "Syntax: \2INJECT Data\2");
    notice (whoami, u->nick, " ");
    notice (whoami, u->nick, "Fakes information from OperStats' uplink. Only certain information");
    notice (whoami, u->nick, "will be processed. See process.c for examples on what types of");
    notice (whoami, u->nick, "information will be processed. Note that misuse of this command");
    notice (whoami, u->nick, "(such as injecting a QUIT from a user) WILL cause OperStats to be");
    notice (whoami, u->nick, "desync'd from the network and may cause crashes.");
    notice (whoami, u->nick, " ");
    notice (whoami, u->nick, "The \2INJECT\2 command is not supported in any way.");
    notice (whoami, u->nick, " ");
    notice (whoami, u->nick, "Example: \2INJECT :User PRIVMSG StatServ :STATS\2");
    notice (whoami, u->nick, " ");
    notice (whoami, u->nick, RPL_HELP_END);
}
#endif /* RAWINJECT */

void shared_help_debug (User *u)
{
    char *whoami = authserv ();

    notice (whoami, u->nick, RPL_HELP_START, whoami);
    notice (whoami, u->nick, " ");
    notice (whoami, u->nick, "Syntax: \2DEBUG Level\2");
    notice (whoami, u->nick, " ");
    notice (whoami, u->nick, "Sets the debugging level. There are 4 debug mode levels:");
    notice (whoami, u->nick, " ");
    notice (whoami, u->nick, "    \2Level 0\2: No debug logging (disabled)");
    notice (whoami, u->nick, "    \2Level 1\2: Server<->server traffic is logged.");
    notice (whoami, u->nick, "    \2Level 2\2: Function calls are logged.");
    notice (whoami, u->nick, "    \2Level 3\2: Server<->server traffic & function calls are logged");
    notice (whoami, u->nick, " ");
    notice (whoami, u->nick, "Logging will be done in debug.log, not %s", LOGFILE);
    notice (whoami, u->nick, " ");
    notice (whoami, u->nick, "Example: \2DEBUG 3\2");
    notice (whoami, u->nick, " ");
    notice (whoami, u->nick, RPL_HELP_END);
}

void shared_help_update (User *u)
{
    char *whoami = authserv ();

    notice (whoami, u->nick, RPL_HELP_START, whoami);
    notice (whoami, u->nick, " ");
    notice (whoami, u->nick, "Syntax: \2UPDATE\2");
    notice (whoami, u->nick, " ");
    notice (whoami, u->nick, "Forces OperStats to save the DBs to disk. This will also");
    notice (whoami, u->nick, "reset the sync timer.");
    notice (whoami, u->nick, " ");
    notice (whoami, u->nick, "Example: \2UPDATE\2");
    notice (whoami, u->nick, " ");
    notice (whoami, u->nick, RPL_HELP_END);
}

void shared_help_rehash (User *u)
{
    char *whoami = authserv ();

    notice (whoami, u->nick, RPL_HELP_START, whoami);
    notice (whoami, u->nick, " ");
    notice (whoami, u->nick, "Syntax: \2REHASH\2");
    notice (whoami, u->nick, " ");
    notice (whoami, u->nick, "Re-Reads %s. If you have any invalid settings, this", CONFIGFILE);
    notice (whoami, u->nick, "will cause OperStats to shut down. The DBs will be saved to disk");
    notice (whoami, u->nick, "beforehand in case this happens.");
    notice (whoami, u->nick, " ");
    notice (whoami, u->nick, "Example: \2REHASH\2");
    notice (whoami, u->nick, " ");
    notice (whoami, u->nick, RPL_HELP_END);
}

void shared_help_settings (User *u)
{
    char *whoami = authserv ();

    notice (whoami, u->nick, RPL_HELP_START, whoami);
    notice (whoami, u->nick, " ");
    notice (whoami, u->nick, "Syntax: \2SETTINGS\2");
    notice (whoami, u->nick, " ");
    notice (whoami, u->nick, "Shows various OperStats settings as defined in %s.", CONFIGFILE);
    notice (whoami, u->nick, " ");
    notice (whoami, u->nick, "Example: \2SETTINGS\2");
    notice (whoami, u->nick, " ");
    notice (whoami, u->nick, RPL_HELP_END);
}

void shared_help_cyclelogs (User *u)
{
    char *whoami = authserv ();

    notice (whoami, u->nick, RPL_HELP_START, whoami);
    notice (whoami, u->nick, " ");
    notice (whoami, u->nick, "Syntax: \2CYCLELOGS\2");
    notice (whoami, u->nick, " ");
    notice (whoami, u->nick, "Closes and reopens the logfiles. This is useful if you wish to");
    notice (whoami, u->nick, "delete the logfiles and have services continue logging without");
    notice (whoami, u->nick, "restarting them.");
    notice (whoami, u->nick, " ");
    notice (whoami, u->nick, "Example: \2CYCLELOGS\2");
    notice (whoami, u->nick, " ");
    notice (whoami, u->nick, RPL_HELP_END);
}
