/* External functions

   OperStats - Copyright (c) 2000-2003 Darcy Grexton
   Contact: skold@habber.net, skold @ HabberNet

   See doc/LICENSE for licensing details.
 */

#define E extern	/* Save us some typing */

/* main.c */
E char inbuf[BUFSIZE * 8], quitmsg[BUFSIZE];
E int8 servsock;
E uint8 debuglevel, bursting, bursted, force, rehashing;
E uint8 dailyservstat, maxservcnt, donereset;
E uint32 usercnt, chancnt, servcnt, userstat, chanstat, servstat, maxhitcnt, maxopers;
E uint32 dailyuserstat, dailychanstat, dailyhitcnt, maxusercnt, maxchancnt, runflags;
E uint32 tldnores, tldnoreshits, lastwarnclients, awaystat, operstat;
E uint64 speedstat;
E time_t maxusertime, maxchantime, maxservtime, last_check, last_update, burststart, maxuptime;
E time_t peaktime, dailyusertime, dailychantime, dailyservtime, lastwarncheck, last_sample;
#ifdef HAVE_GETTIMEOFDAY
E struct timeval burstnow, burstms, bursttmp;
#endif
E void intro_user (const char *nick, const char *user, const char *host, const char *real, const char *modes);
E void chk ();

/* conf.c */
E SRA *sralist;
E ULine *ulinelist;
E void reset_conf ();
E void load_conf ();
E uint8 check_conf ();
E char s_OperServ[NICKLEN], s_StatServ[NICKLEN], s_GlobalNoticer[NICKLEN];
E char tlds[64], snoopchan[32], def_akill_reason[256], joinchan[32];
E char mirclink[256], mirclinkimg[256], javalinkimg[256], globalmsg[64];
E char logoimg[256], network_name[32], cygnus_server[65];
E Boolean_T operserv_on, statserv_on, globalnoticer_on;
E Boolean_T spamserv_on, globalonakill_on, stamplogons_on;
E Boolean_T logupdates_on, dumpchans_on, dumpservers_on, javaclient_on;
E Boolean_T dumpstats_on, dumptlds_on, sharesras_on;
E Boolean_T shareakills_on, globalonlag_on, globalonspeed_on;
E Boolean_T globalonauth_on, haveserv_on, ignoreulines_on;
E Boolean_T noisyflood_on;
E uint8 unreal_numeric, nonwildreq, floodmsgs, ircdtype, maxclones, maxclonekills;
E uint8 helpindex, securitysetting, warnclients;
E uint16 update_timeout, wait_restart, floodtime, lagthreshold, ping_delay;
E uint32 clonekill_time, def_akill_time;

/* function.c */
E void open_log ();
E void open_debug ();
E void log (const char *fmt,...);
E void log_sameline (uint8 sameline, const char *fmt,...);
E void debug (const char *fmt,...);
E void close_log ();
E void close_debug ();
E void fatal (uint8 sameline, const char *fmt,...);
E void send_cmd (const char *source, const char *fmt,...);
E void globops (const char *sender, const char *fmt,...);
E void snoop (const char *source, const char *fmt,...);
E void ctcpreply (const char *source, const char *dest, const char *fmt,...);
E void notice (const char *source, const char *dest, const char *fmt,...);
E void noticeall (const char *dest, const char *fmt,...);
E void notice_list (const char *source, const char *dest, const char **text);
E char *strscpy (char *d, const char *s, size_t len);
E void *smalloc (uint32 size);
E void *scalloc (uint32 elsize, uint32 els);
E void *srealloc (void *oldptr, uint32 newsize);
E char *sstrdup (const char *s);
E size_t sstrlcat (char *dst, const char *src, size_t siz);
E size_t sstrlcpy (char *dst, const char *src, size_t siz);
E Hash *get_hash (const char *whoami, User *u, const char *cmd, Hash *hash_table);
E Hash *get_sub_hash (const char *whoami, User *u, const char *cmd, Hash *hash_table);
E Hash *get_help_hash (const char *whoami, User *u, const char *cmd, Hash *hash_table);
E uint8 is_oper (User *u);
E uint8 is_sra (User *u);
E char *stristr (char *s1, char *s2);
E uint8 match_wild (const char *pattern, const char *str);
E uint8 match_wild_nocase (const char *pattern, const char *str);
E char *strupper (char *s);
E char *strlower (char *s);
E void strip (char *line);
E uint8 is_one_of_mine (const char *nick);
E char *get_time (time_t event, uint8 fulldate);
E char *zone_time (int32 offset);
E char *time_ago (time_t event);
E char *duration (time_t event, uint8 format);
E uint32 dotime (const char *s);
E SRA *findsra (const char *nick);
E ULine *finduline (const char *name);
E TLD *findtld (const char *param);
E Zone *findzone (const char *param);
E ServStat *findservstat (const char *server);
E uint8 is_akilled (const char *mask);
E char *create_mask (User *u);
E char *stripcodes (char *buffer);
E uint8 is_midnight ();
E void dumpchans ();
E void dumptlds ();
E void dumpstats ();
E void dumpservers ();
E char *replace (char *s, int32 size, const char *old, const char *new);
E char *itoa (uint32 num);
E void flushlists ();
E uint8 ispass (char *text);
E uint8 isctcp (char *command);
E void joinchan_join ();
E void joinchan_part ();
E uint8 countops ();
E void spamserv (User *u, char *buf);
E void errmoreinfo (const char *whoami, const char *source, char *text);
E uint32 tv2ms (struct timeval *tv);
E int32 prefix_to_flag (char c);
E void check_eb ();
E uint32 shash (const unsigned char *text);
E void helpcolumns (User *u, const char *whoami, const char *prefix, const char *commands);
E uint8 servcount ();
E uint8 opcount ();
E void svssend (const char *fmt,...);
E char *authserv ();
E void db_backup (uint8 delete);
E uint32 countchans (uint8 secret);
E int parseuptime (char *string);

/* server.c */
E Channel *chanlist[HASHSIZE];
E User *userlist[HASHSIZE];
E Server *servlist[HASHSIZE];
E Clone *clonelist[HASHSIZE];
E User *finduser (const char *nick);
E User *firstuser ();
E User *nextuser ();
E Server *new_server (const char *name);
E void delete_server (Server *server);
E Server *findserv (const char *name);
E Server *firstserv ();
E Server *nextserv ();
E Channel *findchan (const char *chan);
E Channel *firstchan ();
E Channel *nextchan ();
E void do_nick (const char *source, uint8 ac, char **av);
E void do_umode (const char *source, uint8 ac, char **av);
E void do_cmode (const char *source, uint8 ac, char **av);
E void delete_user (User * user);
E void do_join (const char *source, uint8 ac, char **av);
E void do_part (const char *source, uint8 ac, char **av);
E void do_kick (const char *source, uint8 ac, char **av);
E void do_quit (const char *source, uint8 ac, char **av);
E void do_topic (const char *source, uint8 ac, char **av);
E void do_kill (const char *source, uint8 ac, char **av);
E void kill_user (const char *source, const char *user, const char *reason);
E void do_sjoin (const char *source, uint8 ac, char **av);

/* shared.c */
E void do_auth (User *u);
E void do_deauth (User *u);
E void do_raw (User *u);
E void do_inject (User *u);
E void do_debug (User *u);
E void do_shutdown (User *u);
E void do_restart (User *u);
E void do_settings (User *u);
E void do_update (User *u);
E void do_rehash (User *u);
E void do_search (User *u);
E void do_cyclelogs (User *u);
E void rehash (const char *source);

/* operserv.c */
E int32 akillcnt, akill_size;
E struct akill_ *akills;
E MSG *msglist;
E void operserv (User *u, char *buf);
E void globalnoticer (User *u, char *buf);
E void load_os_dbase ();
E void save_os_dbase ();
E void expire_akills ();
E Trigger *findtrig (const char *user, const char *host);
E Exception *findexcept (const char *user, const char *host);
E Trigger *new_trigger (const char *host, uint8 limit);
E Exception *new_exception (const char *host);
E uint8 check_akill (const char *nick, const char *user, const char *host, const char *real);

/* statserv.c */
E ServStat *statlist[HASHSIZE];
E TLD *tldlist;
E Zone *zonelist;
E Boolean_T tldlookup, zonelookup;
E void statserv (User *u, char *buf);
E void load_ss_dbase ();
E void save_ss_dbase ();
E void load_tlds ();
E void load_zones ();
E void reset_daily_stats ();

/* process.c */
E void process ();

/* socket.c */
E uint64 speedsample, transfer;
E int16 conn (const char *host, uint16 port, const char *lhost, uint16 lport);
E void disconn (uint8 s);
E void read_loop ();
E void sendtoserver (char *fmt,...);

/* help.c */
E void statserv_help_index (User *u);
E void statserv_help_stats (User *u);
E void statserv_help_tld (User *u);
E void statserv_help_tldmap (User *u);
E void statserv_help_tldstats (User *u);
E void statserv_help_zone (User *u);
E void statserv_help_map (User *u);
E void statserv_help_servers (User *u);
E void statserv_help_sendpings (User *u);
E void statserv_help_flush (User *u);
E void statserv_help_reset (User *u);
E void operserv_help_index (User *u);
E void operserv_help_global (User *u);
E void operserv_help_jupe (User *u);
E void operserv_help_clones (User *u);
E void operserv_help_akill (User *u);
E void operserv_help_stats (User *u);
E void operserv_help_trigger (User *u);
E void operserv_help_exception (User *u);
E void operserv_help_logonmsg (User *u);
E void shared_help_auth (User *u);
E void shared_help_deauth (User *u);
E void shared_help_shutdown (User *u);
E void shared_help_restart (User *u);
E void shared_help_search (User *u);
E void shared_help_raw (User *u);
E void shared_help_inject (User *u);
E void shared_help_debug (User *u);
E void shared_help_update (User *u);
E void shared_help_rehash (User *u);
E void shared_help_settings (User *u);
E void shared_help_cyclelogs (User *u);

/* version.h */
E const char version[];
E const char build[];
E const char compile_time[];
E const char *infotext[];
