/* Various configuration options

   OperStats - Copyright (c) 2000-2003 Darcy Grexton
   Contact: skold@habber.net, skold @ HabberNet

   See doc/LICENSE for licensing details.
 */

/* Change these to suit your liking. */
#define CONFIGFILE	"operstats.conf"	/* Our conf file	*/
#define PIDFILE		"operstats.pid"		/* Our PID file		*/
#define LOGFILE		"operstats.log"		/* Our log file		*/
#define MOTDFILE	"operstats.motd"	/* Our MOTD file	*/
#define TLDFILE		"operstats.tld"		/* Our TLD listing	*/
#define ZONEFILE	"operstats.zone"	/* Our TimeZone listing	*/
#define STATSERV_DB	"statserv.db"		/* StatServ DB		*/
#define OPERSERV_DB	"operserv.db"		/* OperServ DB		*/
#define CHANNELS_IN	"channels.ost"		/* channels Source	*/
#define CHANNELS_OUT	"/home/ircd/public_html/channels.html"		/* channels.php		*/
#define TLDSTATS_IN	"tldstats.ost"		/* tldstats Source	*/
#define TLDSTATS_OUT	"/home/ircd/public_html/tldstats.html"		/* tldstats.php		*/
#define SERVERS_IN	"serverstats.ost"	/* serverstats source	*/
#define SERVERS_OUT	"/home/ircd/public_html/serverstats.html"	/* servertstats.php	*/
#define STATS_OUT	"/home/ircd/public_html/stats.php"		/* NetStats file	*/

/* These values should be sufficient on any supported IRCDs. */
#define NICKLEN		32	/* Maximum length of a nickname		*/
#define CHANNELLEN	64	/* Maximum length of a channel name	*/
#define PASSWDLEN	65	/* Maximum length of a password		*/
#define USERLEN		12	/* Maximum length of a username		*/
#define HOSTLEN		65	/* Maximum length of a hostname		*/
#define REALLEN		52	/* Maximum length of a realname		*/

/* Leave these alone too. */
#define BUFSIZE		512	/* Maximum size of a buffer		*/

/* Size of the hash tables OperStats uses. */
#define HASHSIZE 1021

/* Defines for supported IRCd types. Do NOT change these. Add new ones
   to the bottom of the list.
 */
#define DREAMFORGE	1
#define PROMETHEUS	2
#define BAHAMUT		3
#define UNREAL3		4
#define UNREAL3_2	5

/* Do you want OperStats to generate a core file if it crashes?
   I'd suggest you leave this option on. If you experience crashes,
   the core files generated can help me track down the problem and
   fix it.
 */
#define DUMP_CORE

/* Do you want to enable the RAW and INJECT functions? These functions
   are entirely unsupported. If you crash OperStats or your IRCd while
   using them (and it's entirely possible and quite easy to do both),
   tough luck. If you don't know how to do anything with them, tough luck.
   Do not ask me for a list of RAW and INJECT commands. If you enable
   these, you're on your own. They're not toys. :P
 */
#undef RAWINJECT

/* This is easier to type, and if your Windows compiler uses a different
   define, you can change this here. All Windows code is contained in these
   defines.
 */
#define _WIN32_VS SVSWIN32

/* Define this for Windows compiles. */
#undef SVSWIN32
