/* Cygnus Help Files

   Cygnus IRC Services - Copyright (c) 2001-2002 Darcy Grexton
   Contact: skold@habber.net, skold @ HabberNet

   See doc/LICENSE for licensing details.
 */

#include "../inc/services.h"

void nickserv_help_index (User *u)
{
    notice (s_NickServ, u->nick, RPL_HELP_START, s_NickServ);
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "\2%s\2 allows you to register nicknames. Once a nickname is",
	s_NickServ);
    notice (s_NickServ, u->nick, "registered, you will be able to send and receive memos with");
    notice (s_NickServ, u->nick, "\2%s\2, register channels with \2%s\2, and store information", s_MemoServ, s_ChanServ);
    notice (s_NickServ, u->nick, "in \2%s\2.", s_NickServ);
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "For more information on a specific topic, type:");
    notice (s_NickServ, u->nick, "/%s%s%s%s HELP Topic\2", haveserv_on == TRUE ? "" :
	"MSG ", s_NickServ, haveserv_on == TRUE ? "" : securitysetting == 1 ? "@" :
	"", haveserv_on == TRUE ? "" : securitysetting == 1 ? me.name : "");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "\2%s\2 contains information on the following topics:",
	s_NickServ);
    notice (s_NickServ, u->nick, " ");

    if (helpindex == 1)
    {
	char buf[2048];

	*buf = 0;

	/* Build a buffer of commands to list and throw it at helpcolumns */
	strcat (buf, "REGISTER DROP INFO IDENTIFY SET ACCESS RECOVER STATUS ");

	if (chanserv_on == TRUE)
	    strcat (buf, "CHANS ");

	if (maxlinks)
	    strcat (buf, "LINK UNLINK LINKS ");

	if (is_csop (u))
	{
	    strcat (buf, "FREEZE UNFREEZE GETPASS SETPASS ");

	    if (email_on == TRUE)
		strcat (buf, "SENDPASS ");
	}

	helpcolumns (u, s_NickServ, "", buf);
    }

    if (helpindex == 2)
    {
	char buf[2048];

	*buf = 0;

	notice (s_NickServ, u->nick, "\2REGISTER\2        Register a nickname with \2%s\2", s_NickServ);
	notice (s_NickServ, u->nick, "\2DROP\2            Drop a registered nickname");
	notice (s_NickServ, u->nick, "\2INFO\2            Show information on a registered nickname");
	notice (s_NickServ, u->nick, "\2IDENTIFY\2        Identify for a nickname");
	notice (s_NickServ, u->nick, "\2SET\2             Modify various nickname settings");

	notice (s_NickServ, u->nick, " ");

	/* Build a buffer of commands to list and throw it at helpcolumns */
	strcat (buf, "ACCESS RECOVER STATUS ");

	if (chanserv_on == TRUE)
	    strcat (buf, "CHANS ");

	if (maxlinks)
	    strcat (buf, "LINK UNLINK LINKS ");

	if (is_csop (u))
	{
	    strcat (buf, "FREEZE UNFREEZE GETPASS SETPASS ");

	    if (email_on == TRUE)
		strcat (buf, "SENDPASS ");
	}

	helpcolumns (u, s_NickServ, "Other commands: ", buf);

    }

    if (helpindex == 3)
    {
	notice (s_NickServ, u->nick, "\2REGISTER\2        Register a nickname with \2%s\2", s_NickServ);
	notice (s_NickServ, u->nick, "\2DROP\2            Drop a registered nickname");
	notice (s_NickServ, u->nick, "\2INFO\2            Show information on a registered nickname");
	notice (s_NickServ, u->nick, "\2IDENTIFY\2        Identify for a nickname");
	notice (s_NickServ, u->nick, "\2SET\2             Modify various nickname settings");
	notice (s_NickServ, u->nick, "\2ACCESS\2          Add, Remove or List nickname access list entries");
	notice (s_NickServ, u->nick, "\2RECOVER\2         Recover a nickname from \2%s\2 or another user", s_NickServ);
	notice (s_NickServ, u->nick, "\2STATUS\2          Show your current status to Services");

	if (chanserv_on == TRUE)
	    notice (s_NickServ, u->nick, "\2CHANS\2           List channels registered under your nickname");

	if (maxlinks)
	{
	    notice (s_NickServ, u->nick, "\2LINK\2            Link two nicknames together");
	    notice (s_NickServ, u->nick, "\2UNLINK\2          Unlink two linked nicknames");
	    notice (s_NickServ, u->nick, "\2LINKS\2           List nicknames linked to a nickname");
	}

	if (is_csop (u))
	{
	    notice (s_NickServ, u->nick, "\2GETPASS\2         Retrieve the password for a nickname");
	    notice (s_NickServ, u->nick, "\2SETPASS\2         Change the password for a nickname");

	    if (email_on == TRUE)
		notice (s_NickServ, u->nick, "\2SENDPASS\2        E-Mail the password for a nickname");

	    notice (s_NickServ, u->nick, "\2FREEZE\2          Freeze a nickname to prevent use of it");
	    notice (s_NickServ, u->nick, "\2UNFREEZE\2        Undo a Freeze on a nickname");
	}
    }

    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, RPL_HELP_END);
}

void nickserv_help_register (User *u)
{
    notice (s_NickServ, u->nick, RPL_HELP_START, s_NickServ);
    notice (s_NickServ, u->nick, " ");

    if (!nsregistertype)
	notice (s_NickServ, u->nick, "Syntax: \2REGISTER Password\2");
    if (nsregistertype == 1)
	notice (s_NickServ, u->nick, "Syntax: \2REGISTER E-Mail\2");
    if (nsregistertype == 2 || nsregistertype == 3)
	notice (s_NickServ, u->nick, "Syntax: \2REGISTER Password E-Mail\2");
    if (nsregistertype == 4)
	notice (s_NickServ, u->nick, "Syntax: \2REGISTER Password Password\2");
    if (nsregistertype == 5 || nsregistertype == 6)
	notice (s_NickServ, u->nick, "Syntax: \2REGISTER Password Password E-Mail\2");

    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Allows you to register your nickname with \2%s\2.", s_NickServ);
    notice (s_NickServ, u->nick, "Once your nickname is registered, you will be able to send");
    notice (s_NickServ, u->nick, "and receive memos through \2%s\2, register channels", s_MemoServ);
    notice (s_NickServ, u->nick, "and get access to other channels through \2%s\2,", s_ChanServ);
    notice (s_NickServ, u->nick, "and manage your nickname through \2%s\2.", s_NickServ);
    notice (s_NickServ, u->nick, " ");

    if (!nsregistertype || nsregistertype > 1)
    {
	notice (s_NickServ, u->nick, "The password you give is case sensitive. Passwords must be");
	notice (s_NickServ, u->nick, "at least 5 characters in length and no more than 32");
	notice (s_NickServ, u->nick, "characters in length.");
    }

    if (nsregistertype == 1 || nsregistertype == 3 || nsregistertype == 6)
    {
	/* Add a blank line to have it look nice from above */
	if (!nsregistertype || nsregistertype > 1)
	    notice (s_NickServ, u->nick, " ");

	notice (s_NickServ, u->nick, "\2%s\2 will E-Mail you when you register.", s_NickServ);
	notice (s_NickServ, u->nick, "You must follow the instructions in the E-Mail to");
	notice (s_NickServ, u->nick, "complete registration of your nickname.");
    }

    notice (s_NickServ, u->nick, " ");

    if (!nsregistertype)
	notice (s_NickServ, u->nick, "Example: \2REGISTER PasSwORd\2");
    if (nsregistertype == 1)
	notice (s_NickServ, u->nick, "Example: \2REGISTER your@email.com\2");
    if (nsregistertype == 2 || nsregistertype == 3)
	notice (s_NickServ, u->nick, "Example: \2REGISTER PasSwORd your@email.com\2");
    if (nsregistertype == 4)
	notice (s_NickServ, u->nick, "Example: \2REGISTER PasSwORd PasSwORd\2");
    if (nsregistertype == 5 || nsregistertype == 6)
	notice (s_NickServ, u->nick, "Example: \2REGISTER PasSwORd PasSwORd your@email.com\2");

    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, RPL_HELP_END);
}

void nickserv_help_drop (User *u)
{
    int csop = is_csop (u);

    notice (s_NickServ, u->nick, RPL_HELP_START, s_NickServ);
    notice (s_NickServ, u->nick, " ");

    if (csop)
	notice (s_NickServ, u->nick, "Syntax: \2DROP NickName [Password]\2");
    else
	notice (s_NickServ, u->nick, "Syntax: \2DROP NickName Password\2");

    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Drops the specified nickname. Once a nickname is dropped,");
    notice (s_NickServ, u->nick, "it cannot be undone. It will be available for other users");
    notice (s_NickServ, u->nick, "to register. Any nicknames linked to the dropped nickname");
    notice (s_NickServ, u->nick, "will also be dropped.");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "If you wish to drop a linked nickname, see the \2UNLINK\2");
    notice (s_NickServ, u->nick, "command.");
    notice (s_NickServ, u->nick, " ");

    if (csop)
    {
	notice (s_NickServ, u->nick, "As a CSOp, you don't need to provide a password to drop a nick.");
	notice (s_NickServ, u->nick, "You should be careful that you don't accidentally drop the wrong");
	notice (s_NickServ, u->nick, "nickname.");
	notice (s_NickServ, u->nick, " ");
	notice (s_NickServ, u->nick, "Examples: \2DROP NickName\2");
	notice (s_NickServ, u->nick, "          \2DROP NickName PasSWORd\2");
    }
    else
	notice (s_NickServ, u->nick, "Example: \2DROP NickName PasSWORd\2");

    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, RPL_HELP_END);
}

void nickserv_help_info (User *u)
{
    notice (s_NickServ, u->nick, RPL_HELP_START, s_NickServ);
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Syntax: \2INFO NickName\2");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Shows you information on a registered nickname,");
    notice (s_NickServ, u->nick, "such as the time of registration, when the nickname");
    notice (s_NickServ, u->nick, "was last used, and various other information.");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Example: \2INFO NickName\2");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, RPL_HELP_END);
}

void nickserv_help_identify (User *u)
{
    notice (s_NickServ, u->nick, RPL_HELP_START, s_NickServ);
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Syntax: \2IDENTIFY NickName Password\2");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Identify for access to a nickname. Once identified,");
    notice (s_NickServ, u->nick, "you will be able to see and read any memos you have,");
    notice (s_NickServ, u->nick, "gain ops in channels, and use your nickname.");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Example: \2IDENTIFY NickName PasSWORd\2");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, RPL_HELP_END);
}

void nickserv_help_set (User *u)
{
    notice (s_NickServ, u->nick, RPL_HELP_START, s_NickServ);
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Syntax: \2SET Option Parameters\2");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Allows you to modify various nickname settings. You must");
    notice (s_NickServ, u->nick, "\2IDENTIFY\2 for the nickname in order to change its settings.");
    notice (s_NickServ, u->nick, "The settings you can modify are listed below:");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "\2PASS\2         Change your nickname password");

    if (email_on == TRUE)
	notice (s_NickServ, u->nick, "\2EMAIL\2        Change your E-Mail address");

    if (url_on == TRUE)
	notice (s_NickServ, u->nick, "\2URL\2          change your URL");

    if (uin_on == TRUE)
	notice (s_NickServ, u->nick, "\2UIN\2          Change your ICQ UIN");

    if (name_on == TRUE)
	notice (s_NickServ, u->nick, "\2NAME\2         Change your real name");

    if (age_on == TRUE)
	notice (s_NickServ, u->nick, "\2AGE\2          Change your age");

    if (sex_on == TRUE)
	notice (s_NickServ, u->nick, "\2SEX\2          Change your sex");

    if (location_on == TRUE)
	notice (s_NickServ, u->nick, "\2LOCATION\2     Change your location");

    notice (s_NickServ, u->nick, "\2ENFORCE\2      Enable nickname enforcement");
    notice (s_NickServ, u->nick, "\2SECURE\2       Enable nickname security");

    if (showmail_on == TRUE && email_on == TRUE)
	notice (s_NickServ, u->nick, "\2SHOWMAIL\2     Show your E-Mail address in \2INFO\2");

    if (showmail_on == FALSE && email_on == TRUE)
	notice (s_NickServ, u->nick, "\2HIDEMAIL\2     Hide your E-Mail address in \2INFO\2");

    if (ircdtype == UNREAL3 || ircdtype == UNREAL3_2)
	notice (s_NickServ, u->nick, "\2NEVEROP\2      Stop \2%s\2 from auto voice/halfop/opping you", s_ChanServ);
    else
	notice (s_NickServ, u->nick, "\2NEVEROP\2      Stop \2%s\2 from auto voice/opping you", s_ChanServ);

    notice (s_NickServ, u->nick, "\2NOOP\2         Stop people from adding you to \2%s\2 access lists", s_ChanServ);
    notice (s_NickServ, u->nick, "\2NOSUCCESSOR\2  Stop people from making you the successor of channels", s_ChanServ);

    if (privmsg_on == FALSE)
	notice (s_NickServ, u->nick, "\2PRIVMSG\2      Make services PRIVMSG you instead of NOTICE");
    else
	notice (s_NickServ, u->nick, "\2NOTICE\2       Make services NOTICE you instead of PRIVMSG");

    notice (s_NickServ, u->nick, "\2PRIVATE\2      Keep your hostmask private in INFO");
    notice (s_NickServ, u->nick, "\2ZONE\2         Set your preferred TimeZone");

    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Example: \2SET ENFORCE ON\2");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, RPL_HELP_END);
}

void nickserv_help_set_pass (User *u)
{
    notice (s_NickServ, u->nick, RPL_HELP_START, s_NickServ);
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Syntax: \2SET PASS Password Password\2");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Changes the password for your nickname. You must");
    notice (s_NickServ, u->nick, "\2IDENTIFY\2 before you can do this.");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Example: \2SET PASS NeWPaSsWorD NeWPaSsWorD\2");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, RPL_HELP_END);
}

void nickserv_help_set_email (User *u)
{
    if (email_on == FALSE)
    {
	notice (s_NickServ, u->nick, RPL_NO_HELP, "SET EMAIL");
	return;
    }

    notice (s_NickServ, u->nick, RPL_HELP_START, s_NickServ);
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Syntax: \2SET EMAIL NONE|E-Mail\2");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Changes or removes your E-Mail address. You");
    notice (s_NickServ, u->nick, "should keep a valid E-Mail address set in");
    notice (s_NickServ, u->nick, "\2%s\2 at all times. If you wish to", s_NickServ);
    notice (s_NickServ, u->nick, "keep your E-Mail address hidden, you can turn");
    notice (s_NickServ, u->nick, "your \2%s\2 option %s.", showmail_on == TRUE ? "SHOWMAIL" : "HIDEMAIL",
	showmail_on == TRUE ? "on" : "off");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Examples: \2SET EMAIL NONE\2");
    notice (s_NickServ, u->nick, "          \2SET EMAIL your@email.tld\2");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, RPL_HELP_END);
}

void nickserv_help_set_url (User *u)
{
    if (url_on == FALSE)
    {
	notice (s_NickServ, u->nick, RPL_NO_HELP, "SET URL");
	return;
    }

    notice (s_NickServ, u->nick, RPL_HELP_START, s_NickServ);
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Syntax: \2SET URL NONE|Address\2");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Changes or removes your URL. Your URL is");
    notice (s_NickServ, u->nick, "visible in your \2%s INFO\2.", s_NickServ);
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Examples: \2SET URL NONE\2");
    notice (s_NickServ, u->nick, "          \2SET URL http://www.example.net\2");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, RPL_HELP_END);
}

void nickserv_help_set_uin (User *u)
{
    if (uin_on == FALSE)
    {
	notice (s_NickServ, u->nick, RPL_NO_HELP, "SET UIN");
	return;
    }

    notice (s_NickServ, u->nick, RPL_HELP_START, s_NickServ);
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Syntax: \2SET UIN NONE|Number\2");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Stores your ICQ UIN in \2%s\2. UINs", s_NickServ);
    notice (s_NickServ, u->nick, "must be in the range of 1001 to 2147483646.");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Examples: \2SET UIN NONE\2");
    notice (s_NickServ, u->nick, "          \2SET UIN 123456789\2");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, RPL_HELP_END);
}

void nickserv_help_set_name (User *u)
{
    if (name_on == FALSE)
    {
	notice (s_NickServ, u->nick, RPL_NO_HELP, "SET NAME");
	return;
    }

    notice (s_NickServ, u->nick, RPL_HELP_START, s_NickServ);
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Syntax: \2SET NAME NONE|Name\2");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Allows you to store your full, real name in \2%s\2.", s_NickServ);
    notice (s_NickServ, u->nick, "Your name will be visible in \2%s INFO\2.", s_NickServ);
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Examples: \2SET NAME NONE\2");
    notice (s_NickServ, u->nick, "          \2SET NAME Bob Example\2");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, RPL_HELP_END);
}

void nickserv_help_set_age (User *u)
{
    if (age_on == FALSE)
    {
	notice (s_NickServ, u->nick, RPL_NO_HELP, "SET AGE");
	return;
    }

    notice (s_NickServ, u->nick, RPL_HELP_START, s_NickServ);
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Syntax: \2SET AGE NONE|Age\2");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Allows you to store your age in \2%s\2.", s_NickServ);
    notice (s_NickServ, u->nick, "Your age must be between 5 and 100. It will be");
    notice (s_NickServ, u->nick, "visible in \2%s INFO\2.", s_NickServ);
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Examples: \2SET AGE NONE\2");
    notice (s_NickServ, u->nick, "          \2SET AGE 22\2");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, RPL_HELP_END);
}

void nickserv_help_set_sex (User *u)
{
    if (sex_on == FALSE)
    {
	notice (s_NickServ, u->nick, RPL_NO_HELP, "SET SEX");
	return;
    }

    notice (s_NickServ, u->nick, RPL_HELP_START, s_NickServ);
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Syntax: \2SET SEX NONE|Male|Female\2");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Allows you to store your gender in \2%s\2.", s_NickServ);
    notice (s_NickServ, u->nick, "You can only set this to Male or Female. Your");
    notice (s_NickServ, u->nick, "sex will be visible in \2%s INFO\2.", s_NickServ);
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Examples: \2SET SEX NONE\2");
    notice (s_NickServ, u->nick, "          \2SET SEX Male\2");
    notice (s_NickServ, u->nick, "          \2SET SEX Female\2");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, RPL_HELP_END);
}

void nickserv_help_set_location (User *u)
{
    if (location_on == FALSE)
    {
	notice (s_NickServ, u->nick, RPL_NO_HELP, "SET LOCATION");
	return;
    }

    notice (s_NickServ, u->nick, RPL_HELP_START, s_NickServ);
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Syntax: \2SET LOCATION NONE|Location\2");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Allows you to store your geographical location in");
    notice (s_NickServ, u->nick, "\2%s\2. Your location will be visible in", s_NickServ);
    notice (s_NickServ, u->nick, "\2%s INFO\2.", s_NickServ);
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Examples: \2SET LOCATION NONE\2");
    notice (s_NickServ, u->nick, "          \2SET LOCATION Anytown, Canada\2");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, RPL_HELP_END);
}

void nickserv_help_set_enforce (User *u)
{
    notice (s_NickServ, u->nick, RPL_HELP_START, s_NickServ);
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Syntax: \2SET ENFORCE ON|OFF\2");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Toggles your \2ENFORCE\2 flag. When \2ENFORCE\2 is");
    notice (s_NickServ, u->nick, "on, \2%s\2 will stop people from using your", s_NickServ);
    notice (s_NickServ, u->nick, "nickname unless they \2IDENTIFY\2.");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Examples: \2SET ENFORCE ON\2");
    notice (s_NickServ, u->nick, "          \2SET ENFORCE OFF\2");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, RPL_HELP_END);
}

void nickserv_help_set_secure (User *u)
{
    notice (s_NickServ, u->nick, RPL_HELP_START, s_NickServ);
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Syntax: \2SET SECURE ON|OFF\2");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Toggles your \2SECURE\2 flag. When \2SECURE\2 is");
    notice (s_NickServ, u->nick, "on, \2%s\2 will require you to \2IDENTIFY\2", s_NickServ);
    notice (s_NickServ, u->nick, "in order to use your nickname. If \2SECURE\2 is");
    notice (s_NickServ, u->nick, "off, you will be able to use your nickname if your");
    notice (s_NickServ, u->nick, "current hostmask matches one in your \2ACCESS\2 list.");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Examples: \2SET SECURE ON\2");
    notice (s_NickServ, u->nick, "          \2SET SECURE OFF\2");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, RPL_HELP_END);
}

void nickserv_help_set_showmail (User *u)
{
    if (showmail_on == FALSE || email_on == FALSE)
    {
	notice (s_NickServ, u->nick, RPL_NO_HELP, "SET SHOWMAIL");
	return;
    }

    notice (s_NickServ, u->nick, RPL_HELP_START, s_NickServ);
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Syntax: \2SET SHOWMAIL ON|OFF\2");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Toggles your \2SHOWMAIL\2 flag. When \2SHOWMAIL\2 is");
    notice (s_NickServ, u->nick, "on, your E-Mail address will be visible in \2%s INFO\2.", s_NickServ);
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Examples: \2SET SHOWMAIL ON\2");
    notice (s_NickServ, u->nick, "          \2SET SHOWMAIL OFF\2");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, RPL_HELP_END);
}

void nickserv_help_set_hidemail (User *u)
{
    if (showmail_on == TRUE || email_on == FALSE)
    {
	notice (s_NickServ, u->nick, RPL_NO_HELP, "SET HIDEMAIL");
	return;
    }

    notice (s_NickServ, u->nick, RPL_HELP_START, s_NickServ);
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Syntax: \2SET HIDEMAIL ON|OFF\2");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Toggles your \2HIDEMAIL\2 flag. When \2HIDEMAIL\2 is");
    notice (s_NickServ, u->nick, "on, your E-Mail address will be hidden in \2%s INFO\2.", s_NickServ);
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Examples: \2SET HIDEMAIL ON\2");
    notice (s_NickServ, u->nick, "          \2SET HIDEMAIL OFF\2");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, RPL_HELP_END);
}

void nickserv_help_set_neverop (User *u)
{
    notice (s_NickServ, u->nick, RPL_HELP_START, s_NickServ);
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Syntax: \2SET NEVEROP ON|OFF\2");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Toggles your \2NEVEROP\2 flag. When \2NEVEROP\2 is");
    notice (s_NickServ, u->nick, "on, \2%s\2 will not automatically op%s or", s_ChanServ,
	(ircdtype == UNREAL3 || ircdtype == UNREAL3_2) ? ", halfop, " : "");
    notice (s_NickServ, u->nick, "voice you in any channels.");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Examples: \2SET NEVEROP ON\2");
    notice (s_NickServ, u->nick, "          \2SET NEVEROP OFF\2");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, RPL_HELP_END);
}

void nickserv_help_set_noop (User *u)
{
    notice (s_NickServ, u->nick, RPL_HELP_START, s_NickServ);
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Syntax: \2SET NOOP ON|OFF\2");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Toggles your \2NOOP\2 flag. When \2NOOP\2 is");
    notice (s_NickServ, u->nick, "on, people will be unable to add you to \2%s\2", s_ChanServ);
    notice (s_NickServ, u->nick, "access lists.");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Examples: \2SET NOOP ON\2");
    notice (s_NickServ, u->nick, "          \2SET NOOP OFF\2");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, RPL_HELP_END);
}

void nickserv_help_set_nosuccessor (User *u)
{
    notice (s_NickServ, u->nick, RPL_HELP_START, s_NickServ);
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Syntax: \2SET NOSUCCESSOR ON|OFF\2");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Toggles your \2NOSUCCESSOR\2 flag. When \2NOSUCCESSOR\2");
    notice (s_NickServ, u->nick, "is on, people will be unable to set you as the successor");
    notice (s_NickServ, u->nick, "of a channel.");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Examples: \2SET NOSUCCESSOR ON\2");
    notice (s_NickServ, u->nick, "          \2SET NOSUCCESSOR OFF\2");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, RPL_HELP_END);
}

void nickserv_help_set_privmsg (User *u)
{
    if (privmsg_on == TRUE)
    {
	notice (s_NickServ, u->nick, RPL_NO_HELP, "SET PRIVMSG");
	return;
    }

    notice (s_NickServ, u->nick, RPL_HELP_START, s_NickServ);
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Syntax: \2SET PRIVMSG ON|OFF\2");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Toggles your \2PRIVMSG\2 flag. When \2PRIVMSG\2 is");
    notice (s_NickServ, u->nick, "on, Services will send you messages instead of notices.");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Examples: \2SET PRIVMSG ON\2");
    notice (s_NickServ, u->nick, "          \2SET PRIVMSG OFF\2");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, RPL_HELP_END);
}

void nickserv_help_set_notice (User *u)
{
    if (privmsg_on == FALSE)
    {
	notice (s_NickServ, u->nick, RPL_NO_HELP, "SET NOTICE");
	return;
    }

    notice (s_NickServ, u->nick, RPL_HELP_START, s_NickServ);
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Syntax: \2SET NOTICE ON|OFF\2");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Toggles your \2NOTICE\2 flag. When \2NOTICE\2 is");
    notice (s_NickServ, u->nick, "on, Services will send you notices instead of messages.");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Examples: \2SET NOTICE ON\2");
    notice (s_NickServ, u->nick, "          \2SET NOTICE OFF\2");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, RPL_HELP_END);
}

void nickserv_help_set_private (User *u)
{
    notice (s_NickServ, u->nick, RPL_HELP_START, s_NickServ);
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Syntax: \2SET PRIVATE ON|OFF\2");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Toggles your \2PRIVATE\2 flag. When \2PRIVATE\2 is");
    notice (s_NickServ, u->nick, "on, your nickname's last hostmask and last used time");
    notice (s_NickServ, u->nick, "will not be vislble in \2%s INFO\2.", s_NickServ);
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Examples: \2SET PRIVATE ON\2");
    notice (s_NickServ, u->nick, "          \2SET PRIVATE OFF\2");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, RPL_HELP_END);
}

void nickserv_help_set_zone (User *u)
{
    notice (s_NickServ, u->nick, RPL_HELP_START, s_NickServ);
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Syntax: \2SET ZONE Zone|Num|OFF\2");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Toggles your \2ZONE\2 setting. This allows you to have Services");
    notice (s_NickServ, u->nick, "show times to you in your preferred TimeZone instead of GMT, and");
    notice (s_NickServ, u->nick, "also shows your TimeZone in \2%s INFO\2.", s_NickServ);
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "If more than one TimeZone matches the short name you give, you will");
    notice (s_NickServ, u->nick, "be shown a list of TimeZones to choose from. Use the number given");
    notice (s_NickServ, u->nick, "to set your TimeZone to that Zone.");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Examples: \2SET ZONE PDT\2");
    notice (s_NickServ, u->nick, "          \2SET ZONE 4\2");
    notice (s_NickServ, u->nick, "          \2SET ZONE OFF\2");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, RPL_HELP_END);
}

void nickserv_help_access (User *u)
{
    notice (s_NickServ, u->nick, RPL_HELP_START, s_NickServ);
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Syntax: \2ACCESS ADD|DEL|LIST|CURRENT\2");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Add, remove, or list nickname access list entries.");
    notice (s_NickServ, u->nick, "Nickname access list entries help \2%s\2", s_NickServ);
    notice (s_NickServ, u->nick, "recognize you without requiring you to \2IDENTIFY\2.");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Use ACCESS CURRENT to have \2%s\2 remember", s_NickServ);
    notice (s_NickServ, u->nick, "your current address.");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Example: \2ACCESS ADD *@*.someisp.com\2");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, RPL_HELP_END);
}

void nickserv_help_recover (User *u)
{
    notice (s_NickServ, u->nick, RPL_HELP_START, s_NickServ);
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Syntax: \2RECOVER NickName Password\2");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Have \2%s\2 regain a nickname for use.", s_NickServ);
    notice (s_NickServ, u->nick, "If your nickname is being held by \2%s\2,", s_NickServ);
    notice (s_NickServ, u->nick, "or being used by someone else, this command will remove");
    notice (s_NickServ, u->nick, "them from the network so you may use your nickname.");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Example: \2RECOVER NickName PasSWORd\2");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, RPL_HELP_END);
}

void nickserv_help_status (User *u)
{
    notice (s_NickServ, u->nick, RPL_HELP_START, s_NickServ);
    notice (s_NickServ, u->nick, " ");

    if (is_csop (u))
	notice (s_NickServ, u->nick, "Syntax: \2STATUS [Nickname]\2");
    else
	notice (s_NickServ, u->nick, "Syntax: \2STATUS\2");

    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Show your current status to Services. This command will");
    notice (s_NickServ, u->nick, "show what nickname you are identified to, if any, and any");
    notice (s_NickServ, u->nick, "higher level access, such as IRCOp, CSOp and SRA.");
    notice (s_NickServ, u->nick, " ");

    if (is_csop (u))
    {
	notice (s_NickServ, u->nick, "If you specify another nickname, you will be shown the status");
	notice (s_NickServ, u->nick, "for that nickname instead of your own.");
	notice (s_NickServ, u->nick, " ");
	notice (s_NickServ, u->nick, "Examples: \2STATUS\2");
	notice (s_NickServ, u->nick, "          \2STATUS Nickname\2");
    }
    else
	notice (s_NickServ, u->nick, "Example: \2STATUS\2");	

    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, RPL_HELP_END);
}

void nickserv_help_link (User *u)
{
    if (!maxlinks)
    {
	notice (s_NickServ, u->nick, RPL_NO_HELP, "LINK");
	return;
    }

    notice (s_NickServ, u->nick, RPL_HELP_START, s_NickServ);
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Syntax: \2LINK NickName [Password]\2");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Allows you to link two nicknames together. Once");
    notice (s_NickServ, u->nick, "a nickname is linked to another, it shares the host");
    notice (s_NickServ, u->nick, "nicknames access lists, passwords, memos, etc.");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "If both nicknames are registered, then they are merged.");
    notice (s_NickServ, u->nick, "The host nickname's information takes precedence for");
    notice (s_NickServ, u->nick, "any duplicate information. The nickname you specify is");
    notice (s_NickServ, u->nick, "considered the host.");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "If the nickname you specify is registered, but your current");
    notice (s_NickServ, u->nick, "nickname is not, the specified nickname is the host.");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "If the nickname you specify is not registered, but your");
    notice (s_NickServ, u->nick, "current one is, your current nickname is the host. You do not");
    notice (s_NickServ, u->nick, "need to give a password in this case.");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Example: \2LINK NickName PasSWORd\2");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, RPL_HELP_END);
}

void nickserv_help_unlink (User *u)
{
    if (!maxlinks)
    {
	notice (s_NickServ, u->nick, RPL_NO_HELP, "UNLINK");
	return;
    }

    notice (s_NickServ, u->nick, RPL_HELP_START, s_NickServ);
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Syntax: \2UNLINK NickName\2");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Unlink two linked nicknames. When two nicknames are unlinked,");
    notice (s_NickServ, u->nick, "they become seperate nicknames with identical information. If");
    notice (s_NickServ, u->nick, "you wish to completely unregister a linked nickname, use the");
    notice (s_NickServ, u->nick, "\2DROP\2 command.");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Example: \2UNLINK NickName\2");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, RPL_HELP_END);
}

void nickserv_help_links (User *u)
{
    if (!maxlinks)
    {
	notice (s_NickServ, u->nick, RPL_NO_HELP, "LINKS");
	return;
    }

    notice (s_NickServ, u->nick, RPL_HELP_START, s_NickServ);
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Syntax: \2LINKS\2");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Show what nicknames are currently linked to the nickname");
    notice (s_NickServ, u->nick, "you have identified for. Note that this may not be your");
    notice (s_NickServ, u->nick, "current nickname.");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Example: \2LINKS\2");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, RPL_HELP_END);
}

void nickserv_help_chans (User *u)
{
    if (chanserv_on == FALSE)
    {
	notice (s_NickServ, u->nick, RPL_NO_HELP, "CHANS");
	return;
    }

    notice (s_NickServ, u->nick, RPL_HELP_START, s_NickServ);
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Syntax: \2CHANS\2");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Show what channels are currently registered to the nickname");
    notice (s_NickServ, u->nick, "you have identified for. Note that this may not be your");
    notice (s_NickServ, u->nick, "current nickname.");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Example: \2CHANS\2");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, RPL_HELP_END);
}

void nickserv_help_getpass (User *u)
{
    notice (s_NickServ, u->nick, RPL_HELP_START, s_NickServ);
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Syntax: \2GETPASS NickName\2");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Retrieves the password for a registered nickname. GETPASS");
    notice (s_NickServ, u->nick, "should only be used when SENDPASS is unavailable.");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Example: \2GETPASS NickName\2");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, RPL_HELP_END);
}

void nickserv_help_setpass (User *u)
{
    notice (s_NickServ, u->nick, RPL_HELP_START, s_NickServ);
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Syntax: \2SETPASS NickName NewPass NewPass\2");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Changes the password for a registered nickname.");
    notice (s_NickServ, u->nick, "You should choose a unique password, consisting of");
    notice (s_NickServ, u->nick, "random letters and numbers, at least 8 characters");
    notice (s_NickServ, u->nick, "in length.");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Example: \2SETPASS NickName PasSWORd PasSWORd\2");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, RPL_HELP_END);
}

void nickserv_help_sendpass (User *u)
{
    if (email_on == FALSE)
    {
	notice (s_NickServ, u->nick, RPL_NO_HELP, "SENDPASS");
	return;
    }

    notice (s_NickServ, u->nick, RPL_HELP_START, s_NickServ);
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Syntax: \2SENDPASS NickName\2");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "E-Mails the password for a registered nickname to the"); 
    notice (s_NickServ, u->nick, "E-Mail address stored in \2%s\2. If no E-Mail is", s_NickServ);
    notice (s_NickServ, u->nick, "stored, SENDPASS will fail. You should check \2%s\2 INFO", s_NickServ);
    notice (s_NickServ, u->nick, "for the nickname to see if they have set a valid E-Mail before");
    notice (s_NickServ, u->nick, "using SENDPASS.");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "If the nickname is not yet fully registered, SENDPASS will issue");
    notice (s_NickServ, u->nick, "the user a new key.");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Example: \2SENDPASS NickName\2");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, RPL_HELP_END);
}

void nickserv_help_freeze (User *u)
{
    notice (s_NickServ, u->nick, RPL_HELP_START, s_NickServ);
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Syntax: \2FREEZE NickName [Reason]\2");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Freeze a nickname. Once a nickname is frozen, it cannot");
    notice (s_NickServ, u->nick, "be used. Anyone attempting to use the nickname will");
    notice (s_NickServ, u->nick, "have their nickname changed, or be removed from the network.");
    notice (s_NickServ, u->nick, "FREEZE is permanent until undone with the UNFREEZE command.");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "FREEZE should only be used for short periods to punish abusive");
    notice (s_NickServ, u->nick, "users. Consider using the FORBID command to permanently ban");
    notice (s_NickServ, u->nick, "a nickname.");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Examples: \2FREEZE NickName\2");
    notice (s_NickServ, u->nick, "          \2FREEZE NickName Do not abuse Services");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, RPL_HELP_END);
}

void nickserv_help_unfreeze (User *u)
{           
    notice (s_NickServ, u->nick, RPL_HELP_START, s_NickServ);
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Syntax: \2UNFREEZE NickName\2");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Undo a Freeze on a nickname. The nickname will be");
    notice (s_NickServ, u->nick, "usable by its owner again.");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, "Example: \2UNFREEZE NickName\2");
    notice (s_NickServ, u->nick, " ");
    notice (s_NickServ, u->nick, RPL_HELP_END);
}

void chanserv_help_index (User *u)
{
    notice (s_ChanServ, u->nick, RPL_HELP_START, s_ChanServ);
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "\2%s\2 allows you to register channels. Once a",
	s_ChanServ);
    notice (s_ChanServ, u->nick, "channel is registered, you will be able to control who");

    if (ircdtype == UNREAL3 || ircdtype == UNREAL3_2)
	notice (s_ChanServ, u->nick, "gets opped, halfopped and voiced, who can join your");
    else
	notice (s_ChanServ, u->nick, "gets opped and voiced, who can join your");

    notice (s_ChanServ, u->nick, "channel, who can change the topic, and much more.");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "For more information on a specific topic, type:");
    notice (s_ChanServ, u->nick, "/%s%s%s%s HELP Topic\2", haveserv_on == TRUE ? "" :
	"MSG ", s_ChanServ, haveserv_on == TRUE ? "" : securitysetting == 1 ? "@" :
	"", haveserv_on == TRUE ? "" : securitysetting == 1 ? me.name : "");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "\2%s\2 contains information on the following topics:",
	s_ChanServ);
    notice (s_ChanServ, u->nick, " ");

    if (helpindex == 1)
    {
	char buf[2048];

	*buf = 0;

	/* Build a buffer of commands to list and throw it at helpcolumns */
	strcat (buf, "REGISTER DROP INFO IDENTIFY SET VOP ");

	if (ircdtype == UNREAL3 || ircdtype == UNREAL3_2)
	    strcat (buf, "HOP ");

	strcat (buf, "AOP SOP OP DEOP ");

	if (ircdtype == UNREAL3 || ircdtype == UNREAL3_2)
	    strcat (buf, "HALFOP DEHALFOP ");

	strcat (buf, "VOICE DEVOICE AKICK COUNT STATUS BANS UNBAN INVITE KICK CLEAR SEND ");

	if (is_csop (u))
	{
	    strcat (buf, "FREEZE UNFREEZE GETPASS SETPASS ");

	    if (email_on == TRUE)
		strcat (buf, "SENDPASS ");

	    if (csregistertype == 4)
		strcat (buf, "AUTH ");
	}

	helpcolumns (u, s_ChanServ, "", buf);
    }

    if (helpindex == 2)
    {
	char buf[2048];

	*buf = 0;

	notice (s_ChanServ, u->nick, "\2REGISTER\2        Register a channel with \2%s\2", s_ChanServ);
	notice (s_ChanServ, u->nick, "\2DROP\2            Drop a registered channel");
	notice (s_ChanServ, u->nick, "\2INFO\2            Show information on a registered channel");
	notice (s_ChanServ, u->nick, "\2IDENTIFY\2        Identify for a channel");
	notice (s_ChanServ, u->nick, "\2SET\2             Modify various channel settings");

	notice (s_ChanServ, u->nick, " ");

	/* Build a buffer of commands to list and throw it at helpcolumns */
	strcat (buf, "VOP ");

	if (ircdtype == UNREAL3 || ircdtype == UNREAL3_2)
	    strcat (buf, "HOP ");

	strcat (buf, "AOP SOP OP DEOP ");

	if (ircdtype == UNREAL3 || ircdtype == UNREAL3_2)
	    strcat (buf, "HALFOP DEHALFOP ");

	strcat (buf, "VOICE DEVOICE AKICK COUNT STATUS BANS UNBAN INVITE KICK CLEAR SEND ");

	if (is_csop (u))
	{
	    strcat (buf, "FREEZE UNFREEZE GETPASS SETPASS ");

	    if (email_on == TRUE)
		strcat (buf, "SENDPASS ");

	    if (csregistertype == 4)
		strcat (buf, "AUTH ");
	}

	helpcolumns (u, s_ChanServ, "Other commands: ", buf);
    }

    if (helpindex == 3)
    {
	notice (s_ChanServ, u->nick, "\2REGISTER\2        Register a channel with \2%s\2", s_ChanServ);
	notice (s_ChanServ, u->nick, "\2DROP\2            Drop a registered channel");
	notice (s_ChanServ, u->nick, "\2INFO\2            Show information on a registered channel");
	notice (s_ChanServ, u->nick, "\2IDENTIFY\2        Identify for a channel");
	notice (s_ChanServ, u->nick, "\2SET\2             Modify various channel settings");
	notice (s_ChanServ, u->nick, "\2VOP\2             Add, Remove, or List AutoVoices");

	if (ircdtype == UNREAL3 || ircdtype == UNREAL3_2)
	    notice (s_ChanServ, u->nick, "\2HOP\2             Add, Remove, or List AutoHalfOps");

	notice (s_ChanServ, u->nick, "\2AOP\2             Add, Remove, or List AutoOps");
	notice (s_ChanServ, u->nick, "\2SOP\2             Add, Remove, or List SuperOps");
	notice (s_ChanServ, u->nick, "\2OP\2              Op someone on a channel");
	notice (s_ChanServ, u->nick, "\2DEOP\2            DeOp someone on a channel");

	if (ircdtype == UNREAL3 || ircdtype == UNREAL3_2)
	{
	    notice (s_ChanServ, u->nick, "\2HALFOP\2          HalfOp someone on a channel");
	    notice (s_ChanServ, u->nick, "\2DEHALFOP\2        DeHalfOp someone on a channel");
	}

	notice (s_ChanServ, u->nick, "\2VOICE\2           Voice someone on a channel");
	notice (s_ChanServ, u->nick, "\2DEVOICE\2         DeVoice someone on a channel");
	notice (s_ChanServ, u->nick, "\2AKICK\2           Add, Remove, or List AutoKicks");
	notice (s_ChanServ, u->nick, "\2COUNT\2           Show access list totals for a channel");
	notice (s_ChanServ, u->nick, "\2STATUS\2          Show your status on a channel");
	notice (s_ChanServ, u->nick, "\2BANS\2            List the bans on a channel");
	notice (s_ChanServ, u->nick, "\2UNBAN\2           Remove a ban on a channel");
	notice (s_ChanServ, u->nick, "\2INVITE\2          Invite someone to a channel");
	notice (s_ChanServ, u->nick, "\2KICK\2            Kick someone from a channel");
	notice (s_ChanServ, u->nick, "\2CLEAR\2           Clear an item from a channel");
	notice (s_ChanServ, u->nick, "\2SEND\2            Send a channel memo");

	if (is_csop (u))
	{
	    notice (s_ChanServ, u->nick, "\2FREEZE\2          Stop a channel from being used");
	    notice (s_ChanServ, u->nick, "\2UNFREEZE\2        Undo a freeze and allow usage of a channel");

	    if (csregistertype == 4)
		notice (s_ChanServ, u->nick, "\2AUTH\2            List channels awaiting authentication");

	    notice (s_ChanServ, u->nick, "\2GETPASS\2         Get the password for a channel");
	    notice (s_ChanServ, u->nick, "\2SETPASS\2         Change the password for a channel");

	    if (email_on == TRUE)
		notice (s_ChanServ, u->nick, "\2SENDPASS\2        E-Mail a channel's password to the founder");
	}
    }

    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, RPL_HELP_END);
}


void chanserv_help_register (User *u)
{
    notice (s_ChanServ, u->nick, RPL_HELP_START, s_ChanServ);
    notice (s_ChanServ, u->nick, " ");

    if (!csregistertype || csregistertype == 4)
	notice (s_ChanServ, u->nick, "Syntax: \2REGISTER Channel Password\2");
    if (csregistertype == 1)
	notice (s_ChanServ, u->nick, "Syntax: \2REGISTER Channel\2");
    if (csregistertype == 2 || csregistertype == 3)
	notice (s_ChanServ, u->nick, "Syntax: \2REGISTER Channel Password Password\2");

    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Registers a channel under the nickname you've identified");
    notice (s_ChanServ, u->nick, "for. Once a channel is registered, you can add VOPs,");

    if (ircdtype == UNREAL3 || ircdtype == UNREAL3_2)
	notice (s_ChanServ, u->nick, "HOPs, AOPs and SOPs, place AKicks, and generally manage");
    else
	notice (s_ChanServ, u->nick, "AOPs and SOPs, place AKicks, and generally manage");

    notice (s_ChanServ, u->nick, "your channel. Channel registration also effectively");
    notice (s_ChanServ, u->nick, "prevents takeovers, and virtually eliminates the need");
    notice (s_ChanServ, u->nick, "for a bot.");
    notice (s_ChanServ, u->nick, " ");

    if (!csregistertype || csregistertype == 4)
	notice (s_ChanServ, u->nick, "Example: \2REGISTER #Channel PaSsWoRd\2");
    if (csregistertype == 1)
	notice (s_ChanServ, u->nick, "Example: \2REGISTER #Channel\2");
    if (csregistertype == 2 || csregistertype == 3)
	notice (s_ChanServ, u->nick, "Example: \2REGISTER #Channel PaSsWoRd PaSsWoRd\2");

    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, RPL_HELP_END);
}

void chanserv_help_drop (User *u)
{
    int csop = is_csop (u);

    notice (s_ChanServ, u->nick, RPL_HELP_START, s_ChanServ);
    notice (s_ChanServ, u->nick, " ");

    if (csop)
	notice (s_ChanServ, u->nick, "Syntax: \2DROP Channel [Password]\2");
    else
	notice (s_ChanServ, u->nick, "Syntax: \2DROP Channel Password\2");

    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Drops a registered channel. Once a channel has been");
    notice (s_ChanServ, u->nick, "dropped, it is free for anyone to register. You must");
    notice (s_ChanServ, u->nick, "\2IDENTIFY\2 with \2%s\2 in order to use drop.", s_NickServ);
    notice (s_ChanServ, u->nick, " ");

    if (csop)
    {
	notice (s_ChanServ, u->nick, "As a CSOp, you can drop channels without giving the password.");
	notice (s_ChanServ, u->nick, "You should be careful not to drop the wrong channel.");
	notice (s_ChanServ, u->nick, " ");
	notice (s_ChanServ, u->nick, "Examples: \2DROP #Channel\2");
	notice (s_ChanServ, u->nick, "          \2DROP #Channel PaSsWoRd\2");
    }
    else
	notice (s_ChanServ, u->nick, "Example: \2DROP #Channel PaSsWoRd\2");

    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, RPL_HELP_END);
}

void chanserv_help_info (User *u)
{
    notice (s_ChanServ, u->nick, RPL_HELP_START, s_ChanServ);
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Syntax: \2INFO Channel\2");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Shows you information on a registered channel.");
    notice (s_ChanServ, u->nick, "Information such as the channel's founder, time of");
    notice (s_ChanServ, u->nick, "registration, MLock, URL, etc is shown.");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Example: \2INFO #Channel\2");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, RPL_HELP_END);
}

void chanserv_help_identify (User *u)
{
    notice (s_ChanServ, u->nick, RPL_HELP_START, s_ChanServ);
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Syntax: \2IDENTIFY Channel Password\2");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Identifies for founder access for the given channel.");
    notice (s_ChanServ, u->nick, "You must \2IDENTIFY\2 for the channel in order to change");
    notice (s_ChanServ, u->nick, "the channel's settings.");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Example: \2IDENTIFY #Channel PaSsWoRd\2");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, RPL_HELP_END);
}

void chanserv_help_set (User *u)
{
    notice (s_ChanServ, u->nick, RPL_HELP_START, s_ChanServ);
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Syntax: \2SET Channel Option Parameters\2");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Allows you to modify various channel settings. You must");
    notice (s_ChanServ, u->nick, "\2IDENTIFY\2 with the founder password in order to change");
    notice (s_ChanServ, u->nick, "channel settings. The settings you can modify are listed");
    notice (s_ChanServ, u->nick, "below:");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "\2MLOCK\2        Set modes for \2%s\2 to enforce", s_ChanServ);
    notice (s_ChanServ, u->nick, "\2FOUNDER\2      Set yourself as the channel founder");
    notice (s_ChanServ, u->nick, "\2SUCCESSOR\2    Select someone to inherit your channel");
    notice (s_ChanServ, u->nick, "\2PASS\2         Change your channel's password");
    notice (s_ChanServ, u->nick, "\2URL\2          Attach a URL to your channel");
    notice (s_ChanServ, u->nick, "\2GREET\2        Change the channel's on join greeting message");
    notice (s_ChanServ, u->nick, "\2TOPIC\2        Change the channel's topic");
    notice (s_ChanServ, u->nick, "\2TOPICLOCK\2    Locks the channel topic to its current setting");
    notice (s_ChanServ, u->nick, "\2MEMOLEVEL\2    Set the access needed to send channel memos");
    notice (s_ChanServ, u->nick, "\2VERBOSE\2      Notices your channel's ops for some commands");
    notice (s_ChanServ, u->nick, "\2LIMITED\2      Have \2%s\2 maintain a dynamic limit", s_ChanServ);
    notice (s_ChanServ, u->nick, "\2VOPALL\2       Voices everyone on join");
    notice (s_ChanServ, u->nick, "\2SECURE\2       Makes \2%s\2 more strict about ops", s_ChanServ);
    notice (s_ChanServ, u->nick, "\2RESTRICTED\2   Restrict your channel to people on op lists only");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Examples: \2SET #Channel MLOCK +tnr-smlipk\2");
    notice (s_ChanServ, u->nick, "          \2SET #Channel PASS N3wP4SswOrd N3wP4SswOrd\2");
    notice (s_ChanServ, u->nick, "          \2SET #Channel URL http://www.example.net\2");
    notice (s_ChanServ, u->nick, "          \2SET #Channel SECURE ON\2");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, RPL_HELP_END);
}

void chanserv_help_set_mlock (User *u)
{
    notice (s_ChanServ, u->nick, RPL_HELP_START, s_ChanServ);
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Syntax: \2SET Channel MLOCK Modes\2");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Sets your channels ModeLock string. Modes that are");
    notice (s_ChanServ, u->nick, "locked on will always be set by \2%s\2, and", s_ChanServ);
    notice (s_ChanServ, u->nick, "modes that are locked off will not be allowed.");
    notice (s_ChanServ, u->nick, "Other modes can be set freely.");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Example: \2SET #Channel MLOCK +tnr-smlipk\2");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, RPL_HELP_END);
}

void chanserv_help_set_founder (User *u)
{
    notice (s_ChanServ, u->nick, RPL_HELP_START, s_ChanServ);
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Syntax: \2SET Channel FOUNDER\2");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Sets you as the founder of the given channel.");
    notice (s_ChanServ, u->nick, "You cannot \2SET FOUNDER\2 to anyone else. You");
    notice (s_ChanServ, u->nick, "must \2IDENTIFY\2 for the channel before you can");
    notice (s_ChanServ, u->nick, "use \2SET FOUNDER\2. You cannot use \2SET FOUNDER\2");
    notice (s_ChanServ, u->nick, "if you are already the channel founder or if you");
    notice (s_ChanServ, u->nick, "are the channel \2SUCCESSOR\2.");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Example: \2SET #Channel FOUNDER\2");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, RPL_HELP_END);
}

void chanserv_help_set_successor (User *u)
{
    notice (s_ChanServ, u->nick, RPL_HELP_START, s_ChanServ);
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Syntax: \2SET Channel SUCCESSOR Nickname\2");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Sets the \2SUCCESSOR\2 for your channel. The");
    notice (s_ChanServ, u->nick, "\2SUCCESSOR\2 will be made founder of the channel");
    notice (s_ChanServ, u->nick, "if your nickname expires. \2SUCCESSOR\2s also have");
    notice (s_ChanServ, u->nick, "limited Founder-level access, and can do anything");
    notice (s_ChanServ, u->nick, "the channel founder can do, excluding \2SET PASS\2,");
    notice (s_ChanServ, u->nick, "\2SET SUCCESSOR\2, and \2SET FOUNDER\2.");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Examples: \2SET #Channel SUCCESSOR Nickname\2");
    notice (s_ChanServ, u->nick, "          \2SET #Channel SUCCESSOR None\2");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, RPL_HELP_END);
}

void chanserv_help_set_pass (User *u)
{
    notice (s_ChanServ, u->nick, RPL_HELP_START, s_ChanServ);
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Syntax: \2SET Channel PASS Password Password\2");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Changes the password of your channel. You must");
    notice (s_ChanServ, u->nick, "give the new password twice to ensure you do not");
    notice (s_ChanServ, u->nick, "mistype it. Passwords are cAse SenSitIve.");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Example: \2SET #Channel PASS NewPasSwOrd NewPasSwOrd\2");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, RPL_HELP_END);
}

void chanserv_help_set_url (User *u)
{
    notice (s_ChanServ, u->nick, RPL_HELP_START, s_ChanServ);
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Syntax: \2SET Channel URL Address\2");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Sets a URL for your channel. The URL is shown");
    notice (s_ChanServ, u->nick, "in \2%s INFO\2 and is sent to users when", s_ChanServ);
    notice (s_ChanServ, u->nick, "they join your channel.");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Example: \2SET #Channel URL http://www.example.net\2");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, RPL_HELP_END);
}

void chanserv_help_set_greet (User *u)
{
    notice (s_ChanServ, u->nick, RPL_HELP_START, s_ChanServ);
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Syntax: \2SET Channel GREET Message\2");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Sets a \2GREET\2 message for your channel.");
    notice (s_ChanServ, u->nick, "This message is shown to users when they join");
    notice (s_ChanServ, u->nick, "your channel. \2GREET\2 messages can be up");
    notice (s_ChanServ, u->nick, "to 50 characters in length.");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Example: \2SET #Channel GREET Welcome to #Channel!\2");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, RPL_HELP_END);
}

void chanserv_help_set_topic (User *u)
{
    notice (s_ChanServ, u->nick, RPL_HELP_START, s_ChanServ);
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Syntax: \2SET Channel TOPIC Topic\2");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Changes the topic of your channel. Although the");
    notice (s_ChanServ, u->nick, "topic change is done through \2%s\2,", s_ChanServ);
    notice (s_ChanServ, u->nick, "your nickname will be shown as the topic setter.");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Example: \2SET #Channel TOPIC Welcome to #Channel!\2");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, RPL_HELP_END);
}

void chanserv_help_set_topiclock (User *u)
{
    notice (s_ChanServ, u->nick, RPL_HELP_START, s_ChanServ);
    notice (s_ChanServ, u->nick, " ");

    if (ircdtype == UNREAL3 || ircdtype == UNREAL3_2)
	notice (s_ChanServ, u->nick, "Syntax: \2SET Channel TOPICLOCK OFF|VOP|HOP|AOP|SOP|FOUNDER\2");
    else
	notice (s_ChanServ, u->nick, "Syntax: \2SET Channel TOPICLOCK OFF|VOP|AOP|SOP|FOUNDER\2");

    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Sets the \2TOPICLOCK\2 level of your channel. When");
    notice (s_ChanServ, u->nick, "\2TOPICLOCK\2 is on, only users who have sufficient");
    notice (s_ChanServ, u->nick, "access will be able to change the topic of the channel.");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Examples: \2SET #Channel TOPICLOCK OFF\2");
    notice (s_ChanServ, u->nick, "          \2SET #Channel TOPICLOCK SOP\2");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, RPL_HELP_END);
}

void chanserv_help_set_memolevel (User *u)
{
    notice (s_ChanServ, u->nick, RPL_HELP_START, s_ChanServ);
    notice (s_ChanServ, u->nick, " ");

    if (ircdtype == UNREAL3 || ircdtype == UNREAL3_2)
	notice (s_ChanServ, u->nick, "Syntax: \2SET Channel MEMOLEVEL VOP|HOP|AOP|SOP|FOUNDER\2");
    else
	notice (s_ChanServ, u->nick, "Syntax: \2SET Channel MEMOLEVEL VOP|AOP|SOP|FOUNDER\2");

    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Sets the \2MEMOLEVEL\2 of your channel. This controls");
    notice (s_ChanServ, u->nick, "who can use the \2%s SEND\2 function on your", s_ChanServ);
    notice (s_ChanServ, u->nick, "channel. If you do not want people to use \2SEND\2,");
    notice (s_ChanServ, u->nick, "you can set the \2MEMOLEVEL\2 to \2FOUNDER\2.");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Examples: \2SET #Channel MEMOLEVEL VOP\2");
    notice (s_ChanServ, u->nick, "          \2SET #Channel MEMOLEVEL FOUNDER\2");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, RPL_HELP_END);
}

void chanserv_help_set_verbose (User *u)
{
    notice (s_ChanServ, u->nick, RPL_HELP_START, s_ChanServ);
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Syntax: \2SET Channel VERBOSE ON|OFF\2");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Toggles your channel's \2VERBOSE\2 flag. When");
    notice (s_ChanServ, u->nick, "\2VERBOSE\2 is on, channel ops will be notified");
    notice (s_ChanServ, u->nick, "when certain things happen, such as modification");
    notice (s_ChanServ, u->nick, "of the access lists, and AutoKicks being added and");
    notice (s_ChanServ, u->nick, "removed.");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Examples: \2SET #Channel VERBOSE ON\2");
    notice (s_ChanServ, u->nick, "          \2SET #Channel VERBOSE OFF\2");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, RPL_HELP_END);
}

void chanserv_help_set_limited (User *u)
{
    notice (s_ChanServ, u->nick, RPL_HELP_START, s_ChanServ);
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Syntax: \2SET Channel LIMITED ON|OFF\2");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Toggles your channel's \2LIMITED\2 flag. When \2LIMITED\2");
    notice (s_ChanServ, u->nick, "is on, \2%s\2 will maintain a dynamic limit on your", s_ChanServ);
    notice (s_ChanServ, u->nick, "channel. Your channel's +l limit will always be around 5");
    notice (s_ChanServ, u->nick, "users more than are currently in your channel. This helps");
    notice (s_ChanServ, u->nick, "to limit the size of clone floods.");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Examples: \2SET #Channel LIMITED ON\2");
    notice (s_ChanServ, u->nick, "          \2SET #Channel LIMITED OFF\2");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, RPL_HELP_END);
}

void chanserv_help_set_vopall (User *u)
{
    notice (s_ChanServ, u->nick, RPL_HELP_START, s_ChanServ);
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Syntax: \2SET Channel VOPALL ON|OFF\2");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Toggles your channel's \2VOPALL\2 flag. When");
    notice (s_ChanServ, u->nick, "\2VOPALL\2 is on, everyone who joins your channel");
    notice (s_ChanServ, u->nick, "will be voiced, unless they have other access.");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Examples: \2SET #Channel VOPALL ON\2");
    notice (s_ChanServ, u->nick, "          \2SET #Channel VOPALL OFF\2");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, RPL_HELP_END);
}

void chanserv_help_set_secure (User *u)
{
    notice (s_ChanServ, u->nick, RPL_HELP_START, s_ChanServ);
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Syntax: \2SET Channel SECURE ON|OFF\2");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Toggles your channel's \2SECURE\2 flag. When");
    notice (s_ChanServ, u->nick, "\2SECURE\2 is on, only people on your channel's");
    notice (s_ChanServ, u->nick, "access lists will be able to get ops.");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Examples: \2SET #Channel SECURE ON\2");
    notice (s_ChanServ, u->nick, "          \2SET #Channel SECURE OFF\2");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, RPL_HELP_END);
}

void chanserv_help_set_restricted (User *u)
{
    notice (s_ChanServ, u->nick, RPL_HELP_START, s_ChanServ);
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Syntax: \2SET Channel RESTRICTED ON|OFF\2");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Toggles your channel's \2RESTRICTED\2 flag. When");
    notice (s_ChanServ, u->nick, "\2RESTRICTED\2 is on, only people on your channel's");
    notice (s_ChanServ, u->nick, "access lists will be able to join the channel.");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Examples: \2SET #Channel RESTRICTED ON\2");
    notice (s_ChanServ, u->nick, "          \2SET #Channel RESTRICTED OFF\2");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, RPL_HELP_END);
}

void chanserv_help_count (User *u)
{
    notice (s_ChanServ, u->nick, RPL_HELP_START, s_ChanServ);
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Syntax: \2COUNT Channel\2");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Shows you totals for the number of VOPs, %sAOPs,",
	(ircdtype == UNREAL3 || ircdtype == UNREAL3_2) ? "HOPs," : "");
    notice (s_ChanServ, u->nick, "SOPs and AutoKicks on the given channel.");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Example: \2COUNT #Channel\2");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, RPL_HELP_END);
}

void chanserv_help_status (User *u)
{
    notice (s_ChanServ, u->nick, RPL_HELP_START, s_ChanServ);
    notice (s_ChanServ, u->nick, " ");

    if (is_csop (u))
	notice (s_ChanServ, u->nick, "Syntax: \2STATUS Channel [NickName]");
    else
	notice (s_ChanServ, u->nick, "Syntax: \2STATUS Channel\2");

    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Shows you your status on the given channel.");

    if (is_csop (u))
    {
	notice (s_ChanServ, u->nick, " ");
	notice (s_ChanServ, u->nick, "As a CSOp, you can give a nickname to see someone elses status");
	notice (s_ChanServ, u->nick, "instead of your own.");
    }

    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Examples: \2STATUS #Channel\2");

    if (is_csop (u))
	notice (s_ChanServ, u->nick, "          \2STATUS #Channel NickName");

    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, RPL_HELP_END);
}

void chanserv_help_bans (User *u)
{
    notice (s_ChanServ, u->nick, RPL_HELP_START, s_ChanServ);
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Syntax: \2BANS Channel [Mask]\2");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Shows you the bans that are on the given channel. If");
    notice (s_ChanServ, u->nick, "you provide a Mask, only bans matching this will be shown.");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "You can use the \2UNBAN\2 command to remove a ban.");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Examples: \2BANS #Channel\2");
    notice (s_ChanServ, u->nick, "          \2BANS #Channel *mask*\2");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, RPL_HELP_END);
}

void chanserv_help_unban (User *u)
{
    notice (s_ChanServ, u->nick, RPL_HELP_START, s_ChanServ);
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Syntax: \2UNBAN Channel Num|Mask|Nickname\2");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Removes the given ban from the channel. You can specify");
    notice (s_ChanServ, u->nick, "either the number or the mask of the ban from \2BANS\2,");
    notice (s_ChanServ, u->nick, "or the nickname of the person you want to unban, if they're");
    notice (s_ChanServ, u->nick, "online.");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Examples: \2UNBAN #Channel 3\2");
    notice (s_ChanServ, u->nick, "          \2UNBAN #Channel *mask*\2");
    notice (s_ChanServ, u->nick, "          \2UNBAN #Channel Nickname\2");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, RPL_HELP_END);
}

void chanserv_help_kick (User *u)
{
    notice (s_ChanServ, u->nick, RPL_HELP_START, s_ChanServ);
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Syntax: \2KICK Channel Nickname\2");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Kicks the given person from the channel. Your nickname will");
    notice (s_ChanServ, u->nick, "be visible in the kick message, and the person will be told");
    notice (s_ChanServ, u->nick, "that you kicked them.");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Example: \2KICK #Channel Nickname\2");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, RPL_HELP_END);
}

void chanserv_help_clear (User *u)
{
    notice (s_ChanServ, u->nick, RPL_HELP_START, s_ChanServ);
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Syntax: \2CLEAR Channel BANS|MODES|USERS\2");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Clears the selected item from the channel. If you \2CLEAR BANS\2,");
    notice (s_ChanServ, u->nick, "all bans on the channel will be removed. If you \2CLEAR MODES\2,");
    notice (s_ChanServ, u->nick, "any modes not locked on in the MLOCK will be removed. If you");
    notice (s_ChanServ, u->nick, "\2CLEAR USERS\2, all users on the channel, including yourself,");
    notice (s_ChanServ, u->nick, "will be kicked.");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Examples: \2CLEAR #Channel BANS\2");
    notice (s_ChanServ, u->nick, "          \2CLEAR #Channel MODES\2");
    notice (s_ChanServ, u->nick, "          \2CLEAR #Channel USERS\2");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, RPL_HELP_END);
}

void chanserv_help_send (User *u)
{
    notice (s_ChanServ, u->nick, RPL_HELP_START, s_ChanServ);
    notice (s_ChanServ, u->nick, " ");

    if (ircdtype == UNREAL3 || ircdtype == UNREAL3_2)
	notice (s_ChanServ, u->nick, "Syntax: \2SEND Channel ALL|VOP|HOP|AOP|SOP Text\2");
    else
	notice (s_ChanServ, u->nick, "Syntax: \2SEND Channel ALL|VOP|AOP|SOP Text\2");

    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Sends a memo to users on the channel's access list. You");
    notice (s_ChanServ, u->nick, "can send the memo to \2ALL\2 users on the access list, or");
    notice (s_ChanServ, u->nick, "only to specific users, such as \2VOP\2s or \2SOP\2s.");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "The memo will arrive from you, and will be prefixed with");
    notice (s_ChanServ, u->nick, "the channel name.");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Examples: \2SEND #Channel ALL Memo Text\2");
    notice (s_ChanServ, u->nick, "          \2SEND #Channel VOP Memo Text\2");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, RPL_HELP_END);
}

void chanserv_help_invite (User *u)
{
    notice (s_ChanServ, u->nick, RPL_HELP_START, s_ChanServ);
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Syntax: \2INVITE Channel [Nickname]\2");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Invites you to the given channel. If you specify a nickname,");
    notice (s_ChanServ, u->nick, "that person will be invited if they are online.");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Examples: \2INVITE #Channel\2");
    notice (s_ChanServ, u->nick, "          \2INVITE #Channel Nickname\2");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, RPL_HELP_END);
}

void chanserv_help_vop (User *u)
{
    notice (s_ChanServ, u->nick, RPL_HELP_START, s_ChanServ);
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Syntax: \2VOP Channel ADD|DEL|LIST [Mask|Nickname]\2");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Allows you to add, delete, and list the AutoVoices on");
    notice (s_ChanServ, u->nick, "your channel. Only registered nicknames can be added to");
    notice (s_ChanServ, u->nick, "the VOP list.");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Examples: \2VOP #Channel ADD Nickname\2");
    notice (s_ChanServ, u->nick, "          \2VOP #Channel DEL 3\2");
    notice (s_ChanServ, u->nick, "          \2VOP #Channel LIST *nick*\2");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, RPL_HELP_END);
}

void chanserv_help_hop (User *u)
{
    if (!(ircdtype == UNREAL3 || ircdtype == UNREAL3_2))
    {
	notice (s_ChanServ, u->nick, RPL_NO_HELP, "HOP");
	return;
    }

    notice (s_ChanServ, u->nick, RPL_HELP_START, s_ChanServ);
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Syntax: \2HOP Channel ADD|DEL|LIST [Mask|Nickname]\2");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Allows you to add, delete, and list the AutoHalfOps on");
    notice (s_ChanServ, u->nick, "your channel. Only registered nicknames can be added to");
    notice (s_ChanServ, u->nick, "the HOP list.");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Examples: \2HOP #Channel ADD Nickname\2");
    notice (s_ChanServ, u->nick, "          \2HOP #Channel DEL 3\2");
    notice (s_ChanServ, u->nick, "          \2HOP #Channel LIST *nick*\2");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, RPL_HELP_END);
}

void chanserv_help_aop (User *u)
{
    notice (s_ChanServ, u->nick, RPL_HELP_START, s_ChanServ);
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Syntax: \2AOP Channel ADD|DEL|LIST [Mask|Nickname]\2");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Allows you to add, delete, and list the AutoOps on");
    notice (s_ChanServ, u->nick, "your channel. Only registered nicknames can be added to");
    notice (s_ChanServ, u->nick, "the AOP list.");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Examples: \2AOP #Channel ADD Nickname\2");
    notice (s_ChanServ, u->nick, "          \2AOP #Channel DEL 3\2");
    notice (s_ChanServ, u->nick, "          \2AOP #Channel LIST *nick*\2");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, RPL_HELP_END);
}

void chanserv_help_sop (User *u)
{
    notice (s_ChanServ, u->nick, RPL_HELP_START, s_ChanServ);
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Syntax: \2SOP Channel ADD|DEL|LIST [Mask|Nickname]\2");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Allows you to add, delete, and list the SuperOps on");
    notice (s_ChanServ, u->nick, "your channel. Only registered nicknames can be added to");
    notice (s_ChanServ, u->nick, "the SOP list.");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Examples: \2SOP #Channel ADD Nickname\2");
    notice (s_ChanServ, u->nick, "          \2SOP #Channel DEL 3\2");
    notice (s_ChanServ, u->nick, "          \2SOP #Channel LIST *nick*\2");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, RPL_HELP_END);
}

void chanserv_help_op (User *u)
{
    notice (s_ChanServ, u->nick, RPL_HELP_START, s_ChanServ);
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Syntax: \2OP Channel Nickname\2");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Tells \2%s\2 to op the specified nickname", s_ChanServ);
    notice (s_ChanServ, u->nick, "on your channel. If you wish to op yourself, you can");
    notice (s_ChanServ, u->nick, "omit the nickname.");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Examples: \2OP #Channel Nickname\2");
    notice (s_ChanServ, u->nick, "          \2OP #Channel\2");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, RPL_HELP_END);
}

void chanserv_help_deop (User *u)
{
    notice (s_ChanServ, u->nick, RPL_HELP_START, s_ChanServ);
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Syntax: \2DEOP Channel Nickname\2");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Tells \2%s\2 to deop the specified nickname", s_ChanServ);
    notice (s_ChanServ, u->nick, "on your channel. If you wish to deop yourself, you can");
    notice (s_ChanServ, u->nick, "omit the nickname.");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Examples: \2DEOP #Channel Nickname\2");
    notice (s_ChanServ, u->nick, "          \2DEOP #Channel\2");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, RPL_HELP_END);
}

void chanserv_help_halfop (User *u)
{
    if (!(ircdtype == UNREAL3 || ircdtype == UNREAL3_2))
    {
	notice (s_ChanServ, u->nick, RPL_NO_HELP, "HALFOP");
	return;
    }

    notice (s_ChanServ, u->nick, RPL_HELP_START, s_ChanServ);
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Syntax: \2HALFOP Channel Nickname\2");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Tells \2%s\2 to halfop the specified nickname", s_ChanServ);
    notice (s_ChanServ, u->nick, "on your channel. If you wish to halfop yourself, you can");
    notice (s_ChanServ, u->nick, "omit the nickname.");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Examples: \2HALFOP #Channel Nickname\2");
    notice (s_ChanServ, u->nick, "          \2HALFOP #Channel\2");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, RPL_HELP_END);
}

void chanserv_help_dehalfop (User *u)
{
    if (!(ircdtype == UNREAL3 || ircdtype == UNREAL3_2))
    {
	notice (s_ChanServ, u->nick, RPL_NO_HELP, "DEHALFOP");
	return;
    }

    notice (s_ChanServ, u->nick, RPL_HELP_START, s_ChanServ);
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Syntax: \2DEHALFOP Channel Nickname\2");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Tells \2%s\2 to dehalfop the specified nickname", s_ChanServ);
    notice (s_ChanServ, u->nick, "on your channel. If you wish to dehalfop yourself, you can");
    notice (s_ChanServ, u->nick, "omit the nickname.");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Examples: \2DEHALFOP #Channel Nickname\2");
    notice (s_ChanServ, u->nick, "          \2DEHALFOP #Channel\2");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, RPL_HELP_END);
}

void chanserv_help_voice (User *u)
{
    notice (s_ChanServ, u->nick, RPL_HELP_START, s_ChanServ);
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Syntax: \2VOICE Channel Nickname\2");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Tells \2%s\2 to voice the specified nickname", s_ChanServ);
    notice (s_ChanServ, u->nick, "on your channel. If you wish to voice yourself, you can");
    notice (s_ChanServ, u->nick, "omit the nickname.");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Examples: \2VOICE #Channel Nickname\2");
    notice (s_ChanServ, u->nick, "          \2VOICE #Channel\2");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, RPL_HELP_END);
}

void chanserv_help_devoice (User *u)
{
    notice (s_ChanServ, u->nick, RPL_HELP_START, s_ChanServ);
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Syntax: \2DEVOICE Channel Nickname\2");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Tells \2%s\2 to devoice the specified nickname", s_ChanServ);
    notice (s_ChanServ, u->nick, "on your channel. If you wish to devoice yourself, you can");
    notice (s_ChanServ, u->nick, "omit the nickname.");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Examples: \2DEVOICE #Channel Nickname\2");
    notice (s_ChanServ, u->nick, "          \2DEVOICE #Channel\2");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, RPL_HELP_END);
}

void chanserv_help_akick (User *u)
{
    notice (s_ChanServ, u->nick, RPL_HELP_START, s_ChanServ);
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Syntax: \2AKICK Channel ADD|DEL|LIST [FULL] [Mask] [Reason]\2");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Allows you to manage your channel's AutoKick list. Masks");
    notice (s_ChanServ, u->nick, "on the AKick list will be kicked and banned upon joining");
    notice (s_ChanServ, u->nick, "the channel. When adding AKicks, a reason can be optionally");
    notice (s_ChanServ, u->nick, "given.");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Examples: \2AKICK #Channel ADD *@*.abuse.com Abuse\2");
    notice (s_ChanServ, u->nick, "          \2AKICK #Channel DEL 5\2");
    notice (s_ChanServ, u->nick, "          \2AKICK #Channel LIST FULL");
    notice (s_ChanServ, u->nick, "          \2AKICK #Channel LIST *abuse*");
    notice (s_ChanServ, u->nick, "          \2AKICK #Channel LIST FULL *abuse*");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, RPL_HELP_END);
}

void chanserv_help_freeze (User *u)
{
    notice (s_ChanServ, u->nick, RPL_HELP_START, s_ChanServ);
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Syntax: \2FREEZE Channel Reason\2");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Stops usage of a channel. when a channel is frozen, users");
    notice (s_ChanServ, u->nick, "who join it will be kicked and banned. The reason, time and");
    notice (s_ChanServ, u->nick, "setter of the \2FREEZE\2 will be visible in the channel's info.");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Example: \2FREEZE #Channel Spamming\2");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, RPL_HELP_END);
}

void chanserv_help_unfreeze (User *u)
{
    notice (s_ChanServ, u->nick, RPL_HELP_START, s_ChanServ);
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Syntax: \2UNFREEZE Channel\2");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Undoes a \2FREEZE\2 on the channel, allowing it to be used again.");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Example: \2UNFREEZE #Channel\2");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, RPL_HELP_END);
}

void chanserv_help_getpass (User *u)
{
    notice (s_ChanServ, u->nick, RPL_HELP_START, s_ChanServ);
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Syntax: \2GETPASS Channel\2");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Retrieves the password for a channel. \2GETPASS\2 should only");
    notice (s_ChanServ, u->nick, "be used when \2SENDPASS\2 is not possible.");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Example: \2GETPASS #Channel\2");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, RPL_HELP_END);
}

void chanserv_help_setpass (User *u)
{
    notice (s_ChanServ, u->nick, RPL_HELP_START, s_ChanServ);
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Syntax: \2SETPASS Channel NewPass NewPass\2");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Sets the password of the channel to a new one which you");
    notice (s_ChanServ, u->nick, "specify. This should only be done after you have determined");
    notice (s_ChanServ, u->nick, "the user is the actual founder of the channel and that a");
    notice (s_ChanServ, u->nick, "\2SENDPASS\2 is not possible.");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Example: \2SETPASS #Channel PaSsWoRd PaSsWoRd\2");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, RPL_HELP_END);
}

void chanserv_help_sendpass (User *u)
{
    if (email_on == FALSE)
    {
	notice (s_ChanServ, u->nick, RPL_NO_HELP, "SENDPASS");
	return;
    }

    notice (s_ChanServ, u->nick, RPL_HELP_START, s_ChanServ);
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Syntax: \2SENDPASS Channel\2");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Makes \2%s\2 E-Mail the password for the channel", s_ChanServ);
    notice (s_ChanServ, u->nick, "to the E-Mail address \2%s\2 has for the founder.", s_NickServ);
    notice (s_ChanServ, u->nick, "You should always check that the E-Mail address saved in");
    notice (s_ChanServ, u->nick, "\2%s\2 appears to be real.", s_NickServ);
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "If the channel is not yet fully registered, SENDPASS will issue");
    notice (s_ChanServ, u->nick, "the user a new key.");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Example: \2SENDPASS #Channel\2");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, RPL_HELP_END);
}

void chanserv_help_auth (User *u)
{
    if (csregistertype != 4)
    {
	notice (s_ChanServ, u->nick, RPL_NO_HELP, "AUTH");
	return;
    }

    notice (s_ChanServ, u->nick, RPL_HELP_START, s_ChanServ);
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Syntax: \2AUTH VERIFY|DENY|LIST [Channel] [Reason]\2");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Allows you to verify, deny, or list channels awaiting");
    notice (s_ChanServ, u->nick, "authentication. You should only deny authentication for");
    notice (s_ChanServ, u->nick, "a channel which violates network policy. The length of");
    notice (s_ChanServ, u->nick, "time the channel was waiting, and your nickname, will be");
    notice (s_ChanServ, u->nick, "logged and shown to other CSOps. The owner of the channel");
    notice (s_ChanServ, u->nick, "will not be informed who verified or denied their channel.");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "If you are denying a channel, you may provide a reason. This");
    notice (s_ChanServ, u->nick, "will be logged, and shown to the channel founder.");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, "Examples: \2AUTH VERIFY #Channel\2");
    notice (s_ChanServ, u->nick, "          \2AUTH DENY #Channel\2");
    notice (s_ChanServ, u->nick, "          \2AUTH LIST\2");
    notice (s_ChanServ, u->nick, " ");
    notice (s_ChanServ, u->nick, RPL_HELP_END);
}

void memoserv_help_index (User *u)
{
    notice (s_MemoServ, u->nick, RPL_HELP_START, s_MemoServ);
    notice (s_MemoServ, u->nick, " ");
    notice (s_MemoServ, u->nick, "\2%s\2 allows you to send and receive memos to and",
	s_MemoServ);
    notice (s_MemoServ, u->nick, "from other users with registered nicknames.");
    notice (s_MemoServ, u->nick, "Memos can be up to 256 characters long.");
    notice (s_MemoServ, u->nick, " ");
    notice (s_MemoServ, u->nick, "For more information on a specific topic, type:");
    notice (s_MemoServ, u->nick, "/%s%s%s%s HELP Topic\2", haveserv_on == TRUE ? "" :
	"MSG ", s_MemoServ, haveserv_on == TRUE ? "" : securitysetting == 1 ? "@" :
	"", haveserv_on == TRUE ? "" : securitysetting == 1 ? me.name : "");
    notice (s_MemoServ, u->nick, " ");
    notice (s_MemoServ, u->nick, "\2%s\2 contains information on the following topics:",
	s_MemoServ);
    notice (s_MemoServ, u->nick, " ");

    if (helpindex == 1)
    {
	char buf[2048];

	*buf = 0;

	/* Build a buffer of commands to list and throw it at helpcolumns */
	strcat (buf, "SEND READ LIST DEL RECALL NEWS SET ");

	helpcolumns (u, s_MemoServ, "", buf);
    }

    if (helpindex == 2)
    {
	char buf[2048];

	*buf = 0;

	notice (s_MemoServ, u->nick, "\2SEND\2            Send a memo to another registered nickname");
	notice (s_MemoServ, u->nick, "\2READ\2            Read one or more of your memos");
	notice (s_MemoServ, u->nick, "\2DEL\2             Delete one or more of your memos");
	notice (s_MemoServ, u->nick, "\2LIST\2            List memos for your nick or another nick");

	notice (s_MemoServ, u->nick, " ");

	/* Build a buffer of commands to list and throw it at helpcolumns */
	strcat (buf, "RECALL NEWS SET ");

	helpcolumns (u, s_MemoServ, "Other commands: ", buf);
    }

    if (helpindex == 3)
    {
	notice (s_MemoServ, u->nick, "\2SEND\2            Send a memo to another registered nickname");
	notice (s_MemoServ, u->nick, "\2READ\2            Read one or more of your memos");
	notice (s_MemoServ, u->nick, "\2DEL\2             Delete one or more of your memos");
	notice (s_MemoServ, u->nick, "\2LIST\2            List memos for your nick or another nick");
	notice (s_MemoServ, u->nick, "\2RECALL\2          Recall a memo you've sent to another user");
	notice (s_MemoServ, u->nick, "\2NEWS\2            View the latest network news");
	notice (s_MemoServ, u->nick, "\2SET\2             Modify \2%s\2 settings for your nickname", s_MemoServ);
    }

    notice (s_MemoServ, u->nick, " ");
    notice (s_MemoServ, u->nick, RPL_HELP_END);
}

void memoserv_help_send (User *u)
{
    notice (s_MemoServ, u->nick, RPL_HELP_START, s_MemoServ);
    notice (s_MemoServ, u->nick, " ");
    notice (s_MemoServ, u->nick, "Syntax: \2SEND Nickname Text\2");
    notice (s_MemoServ, u->nick, " ");
    notice (s_MemoServ, u->nick, "Sends a memo to another registered nickname. You must \2IDENTIFY\2");
    notice (s_MemoServ, u->nick, "with \2%s\2 before you can send memos. Memos can only be", s_NickServ);
    notice (s_MemoServ, u->nick, "up to 256 characters in length. If you decide later that you don't");
    notice (s_MemoServ, u->nick, "want the memo you sent to be read, you can \2RECALL\2 the memo,");
    notice (s_MemoServ, u->nick, "as long as the person you sent it to hasn't yet read it.");
    notice (s_MemoServ, u->nick, " ");
    notice (s_MemoServ, u->nick, "Example: \2SEND Nickname Hey, how's it going?\2");
    notice (s_MemoServ, u->nick, " ");
    notice (s_MemoServ, u->nick, RPL_HELP_END);
}

void memoserv_help_read (User *u)
{
    notice (s_MemoServ, u->nick, RPL_HELP_START, s_MemoServ);
    notice (s_MemoServ, u->nick, " ");
    notice (s_MemoServ, u->nick, "Syntax: \2READ Number|ALL|NEW\2");
    notice (s_MemoServ, u->nick, " ");
    notice (s_MemoServ, u->nick, "Reads one or more of your memos. You can either specify a number");
    notice (s_MemoServ, u->nick, "from \2LIST\2, which will show you a specific memo, ALL, which");
    notice (s_MemoServ, u->nick, "will show you all of your memos, and NEW, which will show you");
    notice (s_MemoServ, u->nick, "only memos you have not read yet.");
    notice (s_MemoServ, u->nick, " ");
    notice (s_MemoServ, u->nick, "Examples: \2READ 2\2");
    notice (s_MemoServ, u->nick, "          \2READ ALL\2");
    notice (s_MemoServ, u->nick, "          \2READ NEW\2");
    notice (s_MemoServ, u->nick, " ");
    notice (s_MemoServ, u->nick, RPL_HELP_END);
}

void memoserv_help_del (User *u)
{
    notice (s_MemoServ, u->nick, RPL_HELP_START, s_MemoServ);
    notice (s_MemoServ, u->nick, " ");
    notice (s_MemoServ, u->nick, "Syntax: \2DEL Number|ALL|READ\2");
    notice (s_MemoServ, u->nick, " ");
    notice (s_MemoServ, u->nick, "Deletes one or more of your memos. You can either specify a number");
    notice (s_MemoServ, u->nick, "from \2LIST\2, which will delete a specific memo, ALL, which will");
    notice (s_MemoServ, u->nick, "delete all of your memos, or READ, which will delete memos you have");
    notice (s_MemoServ, u->nick, "read.");
    notice (s_MemoServ, u->nick, " ");
    notice (s_MemoServ, u->nick, "Examples: \2DEL 2\2");
    notice (s_MemoServ, u->nick, "          \2DEL ALL\2");
    notice (s_MemoServ, u->nick, "          \2DEL NEW\2");
    notice (s_MemoServ, u->nick, " ");
    notice (s_MemoServ, u->nick, RPL_HELP_END);
}

void memoserv_help_list (User *u)
{
    notice (s_MemoServ, u->nick, RPL_HELP_START, s_MemoServ);
    notice (s_MemoServ, u->nick, " ");
    notice (s_MemoServ, u->nick, "Syntax: \2LIST [Nickname]\2");
    notice (s_MemoServ, u->nick, " ");
    notice (s_MemoServ, u->nick, "Shows memos you have received. If you specify a nickname,");
    notice (s_MemoServ, u->nick, "\2%s\2 will show memos you have sent to that nickname.", s_MemoServ);
    notice (s_MemoServ, u->nick, "You can then \2RECALL\2 a specific memo you have sent to that user.");
    notice (s_MemoServ, u->nick, "The first 10 characters of any memo will be shown to help you find");
    notice (s_MemoServ, u->nick, "a specific memo.");
    notice (s_MemoServ, u->nick, " ");
    notice (s_MemoServ, u->nick, "Examples: \2LIST\2");
    notice (s_MemoServ, u->nick, "          \2LIST Nickname\2");
    notice (s_MemoServ, u->nick, " ");
    notice (s_MemoServ, u->nick, RPL_HELP_END);
}

void memoserv_help_recall (User *u)
{
    notice (s_MemoServ, u->nick, RPL_HELP_START, s_MemoServ);
    notice (s_MemoServ, u->nick, " ");
    notice (s_MemoServ, u->nick, "Syntax: \2RECALL Nickname Number|ALL\2");
    notice (s_MemoServ, u->nick, " ");
    notice (s_MemoServ, u->nick, "Allows you to recall a memo you have sent to someone. Once a memo");
    notice (s_MemoServ, u->nick, "has been recalled, the person you sent it to will not be able to");
    notice (s_MemoServ, u->nick, "read it. You can get a specific memo number to recall by using");
    notice (s_MemoServ, u->nick, "the \2LIST Nickname\2 command.");
    notice (s_MemoServ, u->nick, " ");
    notice (s_MemoServ, u->nick, "Examples: \2RECALL Nickname 2\2");
    notice (s_MemoServ, u->nick, "          \2RECALL Nickname ALL");
    notice (s_MemoServ, u->nick, " ");
    notice (s_MemoServ, u->nick, RPL_HELP_END);
}

void memoserv_help_set (User *u)
{
    notice (s_MemoServ, u->nick, RPL_HELP_START, s_MemoServ);
    notice (s_MemoServ, u->nick, " ");
    notice (s_MemoServ, u->nick, "Syntax: \2SET Option Parameters\2");
    notice (s_MemoServ, u->nick, " ");
    notice (s_MemoServ, u->nick, "Allows you to modify various memo settings. You must \2IDENTIFY\2");
    notice (s_MemoServ, u->nick, "for your nickname in order to change memo settings. The settings");
    notice (s_MemoServ, u->nick, "you can modify are listed below:");
    notice (s_MemoServ, u->nick, " ");
    notice (s_MemoServ, u->nick, "\2RECEIPTS\2     Have \2%s\2 send you receipts for memos", s_MemoServ);
    notice (s_MemoServ, u->nick, "\2MEMOBOX\2      Change the size of your memobox");
    notice (s_MemoServ, u->nick, "\2NOMEMO\2       Deny all memos from everyone");

    if (memomail_on == TRUE)
        notice (s_MemoServ, u->nick, "\2MEMOMAIL\2     Have memos E-Mailed to you");

    notice (s_MemoServ, u->nick, "\2FORWARD\2      Have your memos forwarded to another nickname");
    notice (s_MemoServ, u->nick, " ");
    notice (s_MemoServ, u->nick, "Examples: \2SET RECEIPTS ON\2");
    notice (s_MemoServ, u->nick, "          \2SET MEMOBOX 5\2");
    notice (s_MemoServ, u->nick, "          \2SET FORWARD Nickname\2");
    notice (s_MemoServ, u->nick, " ");
    notice (s_MemoServ, u->nick, RPL_HELP_END);
}

void memoserv_help_set_receipts (User *u)
{
    notice (s_MemoServ, u->nick, RPL_HELP_START, s_MemoServ);
    notice (s_MemoServ, u->nick, " ");
    notice (s_MemoServ, u->nick, "Syntax: \2SET RECEIPTS ON|OFF\2");
    notice (s_MemoServ, u->nick, " ");
    notice (s_MemoServ, u->nick, "Toggles your \2RECEIPTS\2 flag. When \2RECEIPTS\2");
    notice (s_MemoServ, u->nick, "is on, you will receive a memo from \2%s\2 when", s_MemoServ);
    notice (s_MemoServ, u->nick, "a memo you sent is read.");
    notice (s_MemoServ, u->nick, " ");
    notice (s_MemoServ, u->nick, "Examples: \2SET RECEIPTS ON\2");
    notice (s_MemoServ, u->nick, "          \2SET RECEIPTS OFF\2");
    notice (s_MemoServ, u->nick, " ");
    notice (s_MemoServ, u->nick, RPL_HELP_END);
}

void memoserv_help_set_memobox (User *u)
{
    notice (s_MemoServ, u->nick, RPL_HELP_START, s_MemoServ);
    notice (s_MemoServ, u->nick, " ");
    notice (s_MemoServ, u->nick, "Syntax: \2SET MEMOBOX Size\2");
    notice (s_MemoServ, u->nick, " ");
    notice (s_MemoServ, u->nick, "Allows you to set the size of your MemoBox. If you");
    notice (s_MemoServ, u->nick, "make your MemoBox smaller, you will not be able");
    notice (s_MemoServ, u->nick, "to receive as many memos. Your memobox can be set");
    notice (s_MemoServ, u->nick, "between 1 and %d. If you don't want to receive any", memobox_size);
    notice (s_MemoServ, u->nick, "memos, turn the \2NOMEMO\2 option on.");
    notice (s_MemoServ, u->nick, " ");
    notice (s_MemoServ, u->nick, "Example: \2SET MEMOBOX 5\2");
    notice (s_MemoServ, u->nick, " ");
    notice (s_MemoServ, u->nick, RPL_HELP_END);
}

void memoserv_help_set_nomemo (User *u)
{
    notice (s_MemoServ, u->nick, RPL_HELP_START, s_MemoServ);
    notice (s_MemoServ, u->nick, " ");
    notice (s_MemoServ, u->nick, "Syntax: \2SET NOMEMO ON|OFF\2");
    notice (s_MemoServ, u->nick, " ");
    notice (s_MemoServ, u->nick, "Toggles your \2NOMEMO\2 flag. When \2NOMEMO\2 is on,");
    notice (s_MemoServ, u->nick, "no one will be able to send memos to you.");
    notice (s_MemoServ, u->nick, " ");
    notice (s_MemoServ, u->nick, "Examples: \2SET NOMEMO ON\2");
    notice (s_MemoServ, u->nick, "          \2SET NOMEMO OFF\2");
    notice (s_MemoServ, u->nick, " ");
    notice (s_MemoServ, u->nick, RPL_HELP_END);
}

void memoserv_help_set_memomail (User *u)
{
    if (memomail_on == FALSE)
    {
	notice (s_MemoServ, u->nick, RPL_NO_HELP, "SET MEMOMAIL");
	return;
    }

    notice (s_MemoServ, u->nick, RPL_HELP_START, s_MemoServ);
    notice (s_MemoServ, u->nick, " ");
    notice (s_MemoServ, u->nick, "Syntax: \2SET MEMOMAIL ON|OFF\2");
    notice (s_MemoServ, u->nick, " ");
    notice (s_MemoServ, u->nick, "Toggles your \2MEMOMAIL\2 flag. When \2MEMOMAIL\2 is");
    notice (s_MemoServ, u->nick, "on, memos sent to you will be E-Mailed to the address");
    notice (s_MemoServ, u->nick, "you set in \2%s\2.", s_NickServ);
    notice (s_MemoServ, u->nick, " ");
    notice (s_MemoServ, u->nick, "Examples: \2SET MEMOMAIL ON\2");
    notice (s_MemoServ, u->nick, "          \2SET MEMOMAIL OFF\2");
    notice (s_MemoServ, u->nick, " ");
    notice (s_MemoServ, u->nick, RPL_HELP_END);
}

void memoserv_help_set_forward (User *u)
{
    notice (s_MemoServ, u->nick, RPL_HELP_START, s_MemoServ);
    notice (s_MemoServ, u->nick, " ");
    notice (s_MemoServ, u->nick, "Syntax: \2SET FORWARD OFF|Nickname [Password]\2");
    notice (s_MemoServ, u->nick, " ");
    notice (s_MemoServ, u->nick, "Sets your \2FORWARD\2 setting. This makes \2%s\2", s_MemoServ);
    notice (s_MemoServ, u->nick, "forward memos sent to you to another nickname. The nickname");
    notice (s_MemoServ, u->nick, "must be registered, and you must give the password for");
    notice (s_MemoServ, u->nick, "it. That nickname also cannot have a \2FORWARD\2 setting.");
    notice (s_MemoServ, u->nick, " ");
    notice (s_MemoServ, u->nick, "Examples: \2SET FORWARD Nickname Password\2");
    notice (s_MemoServ, u->nick, "          \2SET FORWARD OFF\2");
    notice (s_MemoServ, u->nick, " ");
    notice (s_MemoServ, u->nick, RPL_HELP_END);
}

void memoserv_help_news (User *u)
{
    notice (s_MemoServ, u->nick, RPL_HELP_START, s_MemoServ);
    notice (s_MemoServ, u->nick, " ");
    notice (s_MemoServ, u->nick, "Syntax: \2NEWS\2");
    notice (s_MemoServ, u->nick, " ");
    notice (s_MemoServ, u->nick, "Shows you the network news. \2%s\2 will notify you if there", s_MemoServ);
    notice (s_MemoServ, u->nick, "is new network news you haven't read yet.");
    notice (s_MemoServ, u->nick, " ");
    notice (s_MemoServ, u->nick, "Example: \2NEWS\2");
    notice (s_MemoServ, u->nick, " ");
    notice (s_MemoServ, u->nick, RPL_HELP_END);
}

void rootserv_help_index (User *u)
{
    notice (s_RootServ, u->nick, RPL_HELP_START, s_RootServ);
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, "\2%s\2 gives IRC Operators greater control over", s_RootServ);
    notice (s_RootServ, u->nick, "the network through the use of JUPEs, AKILLs, and other");
    notice (s_RootServ, u->nick, "commands.");
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, "For more information on a specific topic, type:");
    notice (s_RootServ, u->nick, "/%s%s%s%s HELP Topic\2", haveserv_on == TRUE ? "" :
	"MSG ", s_RootServ, haveserv_on == TRUE ? "" : securitysetting == 1 ? "@" :
	"", haveserv_on == TRUE ? "" : securitysetting == 1 ? me.name : "");
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, "\2%s\2 contains information on the following topics:",
	s_RootServ);
    notice (s_RootServ, u->nick, " ");

    if (helpindex == 1)
    {
	char buf[2048];

	*buf = 0;

	/* Build a buffer of commands to list and throw it at helpcolumns */
	strcat (buf, "JUPE AKILL STATS AUTH ");

	if (maxclones)
	    strcat (buf, "CLONES TRIGGER EXCEPTION ");

	if (globalnoticer_on == TRUE)
	    strcat (buf, "GLOBAL ");

	if (is_csop (u))
	    strcat (buf, "SEARCH LISTNICKS LISTCHANS ");

	if (is_sra (u))
	{
	    strcat (buf, "DEAUTH SHUTDOWN RESTART CSOP RESETNEWS DEBUG UPDATE REHASH SETTINGS HOLD MARK CYCLELOGS ");

#ifdef RAWINJECT
	    strcat (buf, "RAW INJECT ");
#endif
	}

	helpcolumns (u, s_RootServ, "", buf);
    }

    if (helpindex == 2)
    {
	char buf[2048];

	*buf = 0;

	notice (s_RootServ, u->nick, "\2JUPE\2            Jupiter a server or nick");
	notice (s_RootServ, u->nick, "\2AKILL\2           Add, Remove, or List AutoKills");

	if (maxclones)
	{
	    notice (s_RootServ, u->nick, "\2CLONES\2          List the current clones on the network");
	    notice (s_RootServ, u->nick, "\2TRIGGER\2         Add, Remove, or List Triggers");
	    notice (s_RootServ, u->nick, "\2EXCEPTION\2       Add, Remove, or List Exceptions");
	}

	notice (s_RootServ, u->nick, "\2AUTH\2            Authenticate as an SRA");

	notice (s_RootServ, u->nick, " ");

	strcat (buf, "STATS ");

	if (globalnoticer_on == TRUE)
	    strcat (buf, "GLOBAL ");

	if (is_csop (u))
	    strcat (buf, "SEARCH LISTNICKS LISTCHANS ");

	/* Build a buffer of commands to list and throw it at helpcolumns */
	if (is_sra (u))
	{
	    strcat (buf, "DEAUTH SHUTDOWN RESTART CSOP RESETNEWS DEBUG UPDATE REHASH SETTINGS HOLD MARK CYCLELOGS ");

#ifdef RAWINJECT
	    strcat (buf, "RAW INJECT ");
#endif
	}

	helpcolumns (u, s_RootServ, "Other commands: ", buf);
    }

    if (helpindex == 3)
    {
	notice (s_RootServ, u->nick, "\2JUPE\2            Jupiter a server or nick");
	notice (s_RootServ, u->nick, "\2AKILL\2           Add, Remove, or List AutoKills");
	notice (s_RootServ, u->nick, "\2STATS\2           Show statistics of the network and services");

	if (maxclones)
	{
	    notice (s_RootServ, u->nick, "\2CLONES\2          List the current clones on the network");
	    notice (s_RootServ, u->nick, "\2TRIGGER\2         Add, Remove, or List Triggers");
	    notice (s_RootServ, u->nick, "\2EXCEPTION\2       Add, Remove, or List Exceptions");
	}

	if (globalnoticer_on == TRUE)
	    notice (s_RootServ, u->nick, "\2GLOBAL\2          Send a global notice");

	if (is_csop (u))
	{
	    notice (s_RootServ, u->nick, "\2SEARCH\2          Search Cygnus' logfile");
	    notice (s_RootServ, u->nick, "\2LISTNICKS\2       List registered nicknames");
	    notice (s_RootServ, u->nick, "\2LISTCHANS\2       List registered channels");
	}

	notice (s_RootServ, u->nick, "\2AUTH\2            Authenticate as an SRA");

	if (is_sra (u))
	{
	    notice (s_RootServ, u->nick, "\2DEAUTH\2          De-Authenticate as an SRA");
	    notice (s_RootServ, u->nick, "\2HOLD\2            Toggle HOLD on a nickname or channel");
	    notice (s_RootServ, u->nick, "\2MARK\2            Toggle MARK on a nickname or channel");
	    notice (s_RootServ, u->nick, "\2SHUTDOWN\2        Terminate Cygnus");
	    notice (s_RootServ, u->nick, "\2RESTART\2         Restart Cygnus");
#ifdef RAWINJECT
	    notice (s_RootServ, u->nick, "\2RAW\2             Send information to the uplink");
	    notice (s_RootServ, u->nick, "\2INJECT\2          Fake information from the uplink");
#endif
	    notice (s_RootServ, u->nick, "\2CSOP\2            Add, Remove, or List CSOps");
	    notice (s_RootServ, u->nick, "\2RESETNEWS\2       Reset the read news flag for all nicks");
	    notice (s_RootServ, u->nick, "\2DEBUG\2           Set debugging level");
	    notice (s_RootServ, u->nick, "\2UPDATE\2          Force a database update");
	    notice (s_RootServ, u->nick, "\2REHASH\2          Re-Read %s", CONFIGFILE);
	    notice (s_RootServ, u->nick, "\2CYCLELOGS\2       Close and reopen Services' logfiles");
	    notice (s_RootServ, u->nick, "\2SETTINGS\2        Show various Cygnus settings");
	}
    }

    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, RPL_HELP_END);
}

void rootserv_help_global (User *u)
{
    notice (s_RootServ, u->nick, RPL_HELP_START, s_RootServ);
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, "Syntax: \2GLOBAL Message\2");
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, "Sends a global notice. If your TLD setting is correct, all users");
    notice (s_RootServ, u->nick, "on the network will see the notice.");
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, "Example: \2GLOBAL We are doing some routing.\2");
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, RPL_HELP_END);
}

void rootserv_help_jupe (User *u)
{
    notice (s_RootServ, u->nick, RPL_HELP_START, s_RootServ);
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, "Syntax: \2JUPE Server|User [Reason]\2");
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, "Jupiters the specified server or user. This will remove");
    notice (s_RootServ, u->nick, "the server or user from the network if it already exists.");
    notice (s_RootServ, u->nick, "Jupes will remain in place until SQUIT/KILLed, or until");
    notice (s_RootServ, u->nick, "Cygnus is reset. If a reason is given, it will be used");
    notice (s_RootServ, u->nick, "in any SQUIT/KILL of an existing server/user, and in the");
    notice (s_RootServ, u->nick, "jupe's description/realname.");
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, "Examples: \2JUPE server.example.net Delinked\2");
    notice (s_RootServ, u->nick, "          \2JUPE someuser This nick may not be used.\2");
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, RPL_HELP_END);
}

void rootserv_help_clones (User *u)
{
    notice (s_RootServ, u->nick, RPL_HELP_START, s_RootServ);
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, "Syntax: \2CLONES Pattern [Limit]\2");
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, "Lists the current clones on the network. Only hostnames matching");
    notice (s_RootServ, u->nick, "Pattern will be shown. Use * to show all clones. If you give Limit,");
    notice (s_RootServ, u->nick, "only Limit matching hosts will be shown.");
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, "Regardless of the given Limit, no more than 250 matches will be shown.");
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, "Examples: \2CLONES *hostname.com 25\2");
    notice (s_RootServ, u->nick, "          \2CLONES *\2");
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, RPL_HELP_END);
}

void rootserv_help_akill (User *u)
{
    notice (s_RootServ, u->nick, RPL_HELP_START, s_RootServ);
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, "Syntax: \2AKILL ADD|DEL|LIST [Mask|Number|Option]\2");
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, "Allows you to add, remove, or list AutoKills. There are a");
    notice (s_RootServ, u->nick, "number of parameters for each command:");
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, "\2ADD Mask|Nick [!P] [!R] [!T Expire Time] Reason\2 - The expire");
    notice (s_RootServ, u->nick, "time is optional. If no expire time is given, the default will");
    notice (s_RootServ, u->nick, "be used. Expire times are in the format of Days, Hours, Minutes,");
    notice (s_RootServ, u->nick, "Seconds. For example, an expire time of 5 days, 1 hour and 30");
    notice (s_RootServ, u->nick, "minutes would be 5d1h30m. You must give the \2!T\2 token to");
    notice (s_RootServ, u->nick, "have an expire time understood. If the \2!R\2 token is given,");
    notice (s_RootServ, u->nick, "Cygnus will treat the mask as a realname, and will AKill");
    notice (s_RootServ, u->nick, "any users with matching realnames. If the \2!P\2 token is given,");
    notice (s_RootServ, u->nick, "the AKill will never expire. If both the \2!T\2 and \2!P\2 tokens are");
    notice (s_RootServ, u->nick, "given, The \2!P\2 token will have no effect. If you give a nickname");
    notice (s_RootServ, u->nick, "instead of a mask, Cygnus will find that user's mask and");
    notice (s_RootServ, u->nick, "AutoKill it. If the user is not online, you will have to provide");
    notice (s_RootServ, u->nick, "a valid mask. The \2!P\2 token must always be given before the \2!R\2");
    notice (s_RootServ, u->nick, "token, and the \2!R\2 token must always be given before the \2!T\2");
    notice (s_RootServ, u->nick, "token.");
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, "\2DEL Mask|Number|ALL\2 - Remove an AutoKill.");
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, "\2LIST [FULL] [Match]\2 - Search for an AKill. If the");
    notice (s_RootServ, u->nick, "first parameter is \2FULL\2, AKill reasons will be displayed,");
    notice (s_RootServ, u->nick, "otherwise they will be omitted. If \2Match\2 is specified, it");
    notice (s_RootServ, u->nick, "will be matched against the AKill mask and setter.");
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, "Examples: \2AKILL ADD *@*.someisp.com You are not welcome.\2");
    notice (s_RootServ, u->nick, "          \2AKILL ADD *@*.someisp.com !T 5d1h30m You are not welcome.\2");
    notice (s_RootServ, u->nick, "          \2AKILL ADD *@*.someisp.com !P You are not welcome.\2");
    notice (s_RootServ, u->nick, "          \2AKILL ADD *sub7* !R Sub7 - You are not welcome.\2");
    notice (s_RootServ, u->nick, "          \2AKILL ADD *sub7* !R !T 10d Sub7 - You are not welcome.\2");
    notice (s_RootServ, u->nick, "          \2AKILL DEL *@*.someisp.com\2");
    notice (s_RootServ, u->nick, "          \2AKILL DEL 25\2");
    notice (s_RootServ, u->nick, "          \2AKILL DEL ALL\2");
    notice (s_RootServ, u->nick, "          \2AKILL LIST\2");
    notice (s_RootServ, u->nick, "          \2AKILL LIST *match*\2");
    notice (s_RootServ, u->nick, "          \2AKILL LIST FULL\2");
    notice (s_RootServ, u->nick, "          \2AKILL LIST FULL *match*\2");
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, RPL_HELP_END);
}

void rootserv_help_trigger (User *u)
{
    notice (s_RootServ, u->nick, RPL_HELP_START, s_RootServ);
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, "Syntax: \2TRIGGER ADD|DEL|LIST [Host|Number|ALL] [Limit]");
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, "Allows you to add, remove or list Triggers. A Trigger allows");
    notice (s_RootServ, u->nick, "the Triggered host to have the defined number of connections.");
    notice (s_RootServ, u->nick, "This allows you to set individual limits for certain hosts, such");
    notice (s_RootServ, u->nick, "as your network's channel and nickname services.");
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, "Examples: \2TRIGGER ADD service@example.net 20\2");
    notice (s_RootServ, u->nick, "          \2TRIGGER DEL 1\2");
    notice (s_RootServ, u->nick, "          \2TRIGGER DEL ALL\2");
    notice (s_RootServ, u->nick, "          \2TRIGGER DEL service@example.net\2");
    notice (s_RootServ, u->nick, "          \2TRIGGER LIST\2");
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, RPL_HELP_END);
}

void rootserv_help_exception (User *u)
{
    notice (s_RootServ, u->nick, RPL_HELP_START, s_RootServ);
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, "Syntax: \2EXCEPTION ADD|DEL|LIST [Host|Number|ALL]");
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, "Allows you to add, remove or list Exceptions. An Exception allows");
    notice (s_RootServ, u->nick, "the specified host to have total immunity to clone detection.");
    notice (s_RootServ, u->nick, "Exceptions also override any Trigger-set limits.");
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, "Examples: \2EXCEPTION ADD service@example.net\2");
    notice (s_RootServ, u->nick, "          \2EXCEPTION DEL 1\2");
    notice (s_RootServ, u->nick, "          \2EXCEPTION DEL ALL\2");
    notice (s_RootServ, u->nick, "          \2EXCEPTION DEL service@example.net\2");
    notice (s_RootServ, u->nick, "          \2EXCEPTION LIST\2");
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, RPL_HELP_END);
}

void rootserv_help_stats (User *u)
{
    notice (s_RootServ, u->nick, RPL_HELP_START, s_RootServ);
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, "Syntax: \2STATS\2");
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, "Shows statistics on the network and services, such as uptime,");
    notice (s_RootServ, u->nick, "current user, channel and server counts, and counts for nicknames,");
    notice (s_RootServ, u->nick, "channels, memos, etc.");
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, "Example: \2STATS\2");
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, RPL_HELP_END);
}

void rootserv_help_auth (User *u)
{
    notice (s_RootServ, u->nick, RPL_HELP_START, s_RootServ);
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, "Syntax: \2AUTH NickName Password\2");
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, "Allows you to authenticate for SRA access. Once you have");
    notice (s_RootServ, u->nick, "authenticated, you will be recognized as an SRA until you");
    notice (s_RootServ, u->nick, "disconnect from the network or \2DEAUTH\2.");
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, "Example: \2AUTH SRANick SRAPass\2");
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, RPL_HELP_END);
}

void rootserv_help_deauth (User *u)
{
    notice (s_RootServ, u->nick, RPL_HELP_START, s_RootServ);
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, "Syntax: \2DEAUTH\2");
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, "Causes you to no longer be recognized as an SRA. You will");
    notice (s_RootServ, u->nick, "need to re-\2AUTH\2 to regain SRA access.");
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, "Example: \2DEAUTH\2");
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, RPL_HELP_END);
}

void rootserv_help_shutdown (User *u)
{
    notice (s_RootServ, u->nick, RPL_HELP_START, s_RootServ);
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, "Syntax: \2SHUTDOWN [NOSAVE] [Reason]\2");
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, "Causes Cygnus to terminate. If you give the NOSAVE token,");
    notice (s_RootServ, u->nick, "the DBs will not be saved. Otherwise, they will be updated before");
    notice (s_RootServ, u->nick, "Cygnus shuts down. If you give a reason, this will be used in a");
    notice (s_RootServ, u->nick, "GlobOps and a log entry.");
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, "Examples: \2SHUTDOWN\2");
    notice (s_RootServ, u->nick, "          \2SHUTDOWN NOSAVE Reason\2");
    notice (s_RootServ, u->nick, "          \2SHUTDOWN Reason\2");
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, RPL_HELP_END);
}

void rootserv_help_hold (User *u)
{
    notice (s_RootServ, u->nick, RPL_HELP_START, s_RootServ);
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, "Syntax: \2HOLD NickName|Channel ON|OFF\2");
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, "Toggle HOLD for a nickname or channel. When HOLD is");
    notice (s_RootServ, u->nick, "on, the nickname or channel will not expire.");
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, "Examples: \2HOLD NickName ON\2");
    notice (s_RootServ, u->nick, "          \2HOLD NickName OFF\2");
    notice (s_RootServ, u->nick, "          \2HOLD #Channel ON\2");
    notice (s_RootServ, u->nick, "          \2HOLD #Channel OFF\2");
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, RPL_HELP_END);
}

void rootserv_help_mark (User *u)
{
    notice (s_RootServ, u->nick, RPL_HELP_START, s_RootServ);
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, "Syntax: \2MARK NickName|Channel ON|OFF\2");
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, "Toggle MARK for a nickname or channel. When MARK is");
    notice (s_RootServ, u->nick, "on, only SRAs will be able to GET, SET or SENDPASS the");
    notice (s_RootServ, u->nick, "nickname or channel.");
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, "Examples: \2MARK NickName ON\2");
    notice (s_RootServ, u->nick, "          \2MARK NickName OFF\2");
    notice (s_RootServ, u->nick, "          \2MARK #Channel ON\2");
    notice (s_RootServ, u->nick, "          \2MARK #Channel OFF\2");
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, RPL_HELP_END);
}

void rootserv_help_restart (User *u)
{
    notice (s_RootServ, u->nick, RPL_HELP_START, s_RootServ);
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, "Syntax: \2RESTART [NOSAVE] [Reason]\2");
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, "Causes Cygnus to restart. If you give the NOSAVE token,");
    notice (s_RootServ, u->nick, "the DBs will not be saved. Otherwise, they will be updated before");
    notice (s_RootServ, u->nick, "Cygnus shuts down. If you give a reason, this will be used in a");
    notice (s_RootServ, u->nick, "GlobOps and a log entry.");
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, "Examples: \2RESTART\2");
    notice (s_RootServ, u->nick, "          \2RESTART NOSAVE Reason\2");
    notice (s_RootServ, u->nick, "          \2RESTART Reason\2");
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, RPL_HELP_END);
}

void rootserv_help_search (User *u)
{
    notice (s_RootServ, u->nick, RPL_HELP_START, s_RootServ);
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, "Syntax: \2SEARCH MatchText [Num]\2");
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, "Allows you to search Cygnus' logfiles for specific text.");
    notice (s_RootServ, u->nick, "If \2Num\2 is specified, that amount of matches will be shown.");
    notice (s_RootServ, u->nick, "\2Num\2 defaults to 50, and cannot be more than 250.");
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, "Example: \2SEARCH *akill* 25\2");
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, RPL_HELP_END);
}

void rootserv_help_listnicks (User *u)
{
    notice (s_RootServ, u->nick, RPL_HELP_START, s_RootServ);
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, "Syntax: \2LISTNICKS Pattern [Max]\2");
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, "Lists registered nicknames. You must provide a pattern to");
    notice (s_RootServ, u->nick, "search by. Wildcards are valid. By default, \2LISTNICKS\2 will");
    notice (s_RootServ, u->nick, "only show the first 50 results. You can specify Max to show");
    notice (s_RootServ, u->nick, "more or less results. \2LISTNICKS\2 will not show more than");
    notice (s_RootServ, u->nick, "250 results. Pattern is matched against the nickname, last");
    notice (s_RootServ, u->nick, "usermask, E-Mail, URL, host nickname, name, age, and sex.");
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, "Examples: \2LISTNICKS *b* 100\2");
    notice (s_RootServ, u->nick, "          \2LISTNICKS Male");
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, RPL_HELP_END);
}

void rootserv_help_listchans (User *u)
{
    notice (s_RootServ, u->nick, RPL_HELP_START, s_RootServ);
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, "Syntax: \2LISTCHANS Pattern [Max]\2");
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, "Lists registered channels. You must provide a pattern to");
    notice (s_RootServ, u->nick, "search by. Wildcards are valid. By default, \2LISTCHANS\2 will");
    notice (s_RootServ, u->nick, "only show the first 50 results. You can specify Max to show");
    notice (s_RootServ, u->nick, "more or less results. \2LISTCHANS\2 will not show more than");
    notice (s_RootServ, u->nick, "250 results. Pattern is matched against the channel name,");
    notice (s_RootServ, u->nick, "founder's nickname, successor, and URL.");
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, "Examples: \2LISTCHANS *b* 100\2");
    notice (s_RootServ, u->nick, "          \2LISTCHANS User");
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, RPL_HELP_END);
}

#ifdef RAWINJECT
void rootserv_help_raw (User *u)
{
    notice (s_RootServ, u->nick, RPL_HELP_START, s_RootServ);
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, "Syntax: \2RAW Data\2");
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, "Sends information to Cygnus' uplink. Syntax is important.");
    notice (s_RootServ, u->nick, "There is no limit to what you can do with \2RAW\2, provided");
    notice (s_RootServ, u->nick, "your IRCd supports it.");
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, "The \2RAW\2 command is not supported in any way.");
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, "Example: \2RAW SVSNICK OldNick NewNick :0\2");
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, RPL_HELP_END);
}

void rootserv_help_inject (User *u)
{
    notice (s_RootServ, u->nick, RPL_HELP_START, s_RootServ);
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, "Syntax: \2INJECT Data\2");
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, "Fakes information from Cygnus' uplink. Only certain information");
    notice (s_RootServ, u->nick, "will be processed. See process.c for examples on what types of");
    notice (s_RootServ, u->nick, "information will be processed. Note that misuse of this command");
    notice (s_RootServ, u->nick, "(such as injecting a QUIT from a user) WILL cause Cygnus to be");
    notice (s_RootServ, u->nick, "desync'd from the network and may cause crashes.");
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, "The \2INJECT\2 command is not supported in any way.");
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, "Example: \2INJECT :User PRIVMSG StatServ :STATS\2");
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, RPL_HELP_END);
}
#endif /* RAWINJECT */

void rootserv_help_csop (User *u)
{
    notice (s_RootServ, u->nick, RPL_HELP_START, s_RootServ);
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, "Syntax: CSOP ADD|DEL|LIST [Nickname|Number|Pattern] [Max]");
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, "Allows you to manage the CSOp list. CSOps have higher access");
    notice (s_RootServ, u->nick, "than IRCOps, but not as much as SRAs. CSOps can use the");
    notice (s_RootServ, u->nick, "\2GET/SET/SENDPASS\2 commands, \2FREEZE\2, and other commands.");
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, "Examples: \2CSOP ADD Nickname\2");
    notice (s_RootServ, u->nick, "          \2CSOP DEL 3\2");
    notice (s_RootServ, u->nick, "          \2CSOP LIST\2");
    notice (s_RootServ, u->nick, "          \2CSOP LIST *nick*\2");
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, RPL_HELP_END);
}

void rootserv_help_debug (User *u)
{
    notice (s_RootServ, u->nick, RPL_HELP_START, s_RootServ);
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, "Syntax: \2DEBUG Level\2");
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, "Sets the debugging level. There are 4 debug mode levels:");
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, "    \2Level 0\2: No debug logging (disabled)");
    notice (s_RootServ, u->nick, "    \2Level 1\2: Server<->server traffic is logged.");
    notice (s_RootServ, u->nick, "    \2Level 2\2: Function calls are logged.");
    notice (s_RootServ, u->nick, "    \2Level 3\2: Server<->server traffic & function calls are logged");
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, "Logging will be done in debug.log, not %s", LOGFILE);
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, "Example: \2DEBUG 3\2");
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, RPL_HELP_END);
}

void rootserv_help_update (User *u)
{
    notice (s_RootServ, u->nick, RPL_HELP_START, s_RootServ);
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, "Syntax: \2UPDATE\2");
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, "Forces Cygnus to save the DBs to disk. This will also");
    notice (s_RootServ, u->nick, "reset the sync timer.");
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, "Example: \2UPDATE\2");
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, RPL_HELP_END);
}

void rootserv_help_rehash (User *u)
{
    notice (s_RootServ, u->nick, RPL_HELP_START, s_RootServ);
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, "Syntax: \2REHASH\2");
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, "Re-Reads %s. If you have any invalid settings, this", CONFIGFILE);
    notice (s_RootServ, u->nick, "will cause Cygnus to shut down. The DBs will be saved to disk");
    notice (s_RootServ, u->nick, "beforehand in case this happens.");
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, "Example: \2REHASH\2");
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, RPL_HELP_END);
}

void rootserv_help_settings (User *u)
{
    notice (s_RootServ, u->nick, RPL_HELP_START, s_RootServ);
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, "Syntax: \2SETTINGS\2");
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, "Shows various Cygnus settings as defined in %s.", CONFIGFILE);
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, "Example: \2SETTINGS\2");
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, RPL_HELP_END);
}

void rootserv_help_resetnews (User *u)
{
    notice (s_RootServ, u->nick, RPL_HELP_START, s_RootServ);
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, "Syntax: \2RESETNEWS\2");
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, "Resets the NEWS flag on every nickname, causing \2%s\2", s_MemoServ);
    notice (s_RootServ, u->nick, "to notify users about new news. This should only be done when the");
    notice (s_RootServ, u->nick, "%s file has been updated.", NEWSFILE);
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, "Example: \2RESETNEWS\2");
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, RPL_HELP_END);
}

void rootserv_help_cyclelogs (User *u)
{
    notice (s_RootServ, u->nick, RPL_HELP_START, s_RootServ);
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, "Syntax: \2CYCLELOGS\2");
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, "Closes and reopens the logfiles. This is useful if you wish to");
    notice (s_RootServ, u->nick, "delete the logfiles and have services continue logging without");
    notice (s_RootServ, u->nick, "restarting them.");
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, "Example: \2CYCLELOGS\2");
    notice (s_RootServ, u->nick, " ");
    notice (s_RootServ, u->nick, RPL_HELP_END);
}
