/* Config file routines

   Cygnus IRC Services - Copyright (c) 2001-2002 Darcy Grexton
   Contact: skold@habber.net, skold @ HabberNet

   See doc/LICENSE for licensing details.
 */

#include "../inc/services.h"

SRA *sralist = NULL;

/* Some vars */
char s_RootServ[NICKLEN], s_NickServ[NICKLEN], s_MemoServ[NICKLEN];
char s_ChanServ[NICKLEN], s_GlobalNoticer[NICKLEN], tlds[64];
char snoopchan[32], def_akill_reason[256], joinchan[32], def_modes[32];
char sendmail_path[512], network_name[32], nsregister_url[256], salt[2];
char csregister_url[256], collision_url[256], globalmsg[64];
char def_topic[350], def_akick_reason[256], operstats_server[65];

Boolean_T rootserv_on = FALSE, nickserv_on = FALSE, memoserv_on = FALSE;
Boolean_T chanserv_on = FALSE, globalnoticer_on = FALSE, fakehost_on = FALSE;
Boolean_T globalonakill_on = FALSE, logupdates_on = FALSE, age_on = FALSE;
Boolean_T shareakills_on = FALSE, sex_on = FALSE, recoverkill_on = FALSE;
Boolean_T name_on = FALSE, location_on = FALSE, privmsg_on = FALSE, webint_on = FALSE;
Boolean_T showmail_on = FALSE, sendmail_on = FALSE, email_on = FALSE;
Boolean_T url_on = FALSE, uin_on = FALSE, memomail_on = FALSE, securevop_on = FALSE;
Boolean_T securesra_on = FALSE, globalonauth_on = FALSE, haveserv_on = FALSE;
Boolean_T statglobal_on = FALSE, noisyflood_on = FALSE, sharesras_on = FALSE;

uint8 unreal_numeric, nonwildreq, passfails, chanlimit, maxclones, maxclonekills;
uint8 maxlinks, memobox_size, memomailmax, memosfromuser, csregistertype;
uint8 nsregistertype, securitysetting, emaillimit, collidetype, floodmsgs;
uint8 akickmax, helpindex, ircdtype;
uint16 update_timeout, wait_restart, floodtime;
uint32 nick_expire, chan_expire, memo_delay, nick_delay, chan_delay, tempexpire;
uint32 def_akill_time, clonekill_time, defnickflags, defchanflags, defmlock_on;
uint32 defmlock_off;

/* Reset the state of conf values before a rehash */
void reset_conf ()
{
    rootserv_on = nickserv_on = memoserv_on = chanserv_on = FALSE;
    globalnoticer_on = logupdates_on = age_on = sex_on = FALSE;
    location_on = name_on = fakehost_on = globalonakill_on = FALSE;
    logupdates_on = shareakills_on = sharesras_on = recoverkill_on = FALSE;
    privmsg_on = webint_on = showmail_on = sendmail_on = email_on = FALSE;
    url_on = uin_on = memomail_on = securevop_on = securesra_on = FALSE;
    globalonauth_on = haveserv_on = statglobal_on = noisyflood_on = FALSE;

    unreal_numeric = nonwildreq = passfails = chanlimit = maxclones = 0;
    maxclonekills = maxlinks = memobox_size = memomailmax = ircdtype = 0;
    memosfromuser = csregistertype = nsregistertype = securitysetting = 0;
    emaillimit = collidetype = floodmsgs = akickmax = helpindex = 0;
    update_timeout = wait_restart = floodtime = nick_expire = 0;
    chan_expire = memo_delay = nick_delay = chan_delay = tempexpire = 0;
    def_akill_time = clonekill_time = defnickflags = defchanflags = 0;
    defmlock_on = defmlock_off = 0;
}

/* Add a new SRA into the sra list. */ 
static SRA *new_sra (const char *nick, const char *pass)
{
    SRA *sra;

    sra = scalloc (sizeof (SRA), 1);

    sra->nick = sstrdup (nick);
    sra->pass = sstrdup (pass);

    sra->next = sralist;

    if (sra->next)
        sra->next->prev = sra;

    sralist = sra;

    return sra;
}

/* Load and parse the conf file */
void load_conf ()
{
    FILE *f = fopen (CONFIGFILE, "r");
    char *item, *s, dBuf[BUFSIZE];
    int confin = 0, linecnt = 0;
#ifdef HAVE_GETTIMEOFDAY
    struct timeval start, now, tmp;
#endif

#ifdef HAVE_GETTIMEOFDAY
    log_sameline (1, "CONF: Loading.... ");
#else
    log ("CONF: Loading....");
#endif

    if (!f)
    {
	log (RPL_NO_CONFIG);
	exit (1);
    }

#ifdef HAVE_GETTIMEOFDAY
    gettimeofday (&(start), NULL);
#endif

    while (fgets (dBuf, 2047, f))
    {
	linecnt++;

	item = strtok (dBuf, " ");
	strip (item);

	if (*item == '#' || *item == '\t' || *item == ' ' || !*item)
	    continue;

	if (!stricmp (item, "Info"))
	{
	    if (debuglevel > 1)
	    {
		debug ("Parsing conf directive: Info");
		confin++;
	    }

	    s = strtok (NULL, " ");
	    strip (s);

	    if (s && strchr (s, '.'))
		memcpy (me.name, s, sizeof (me.name));
	    else
		fatal (0, "Config: Line %d: Info is not set properly: No server name.", linecnt);

	    s = strtok (NULL, "");
	    strip (s);

	    if (s)
		memcpy (me.desc, s, sizeof (me.desc));
	    else
	    {
		char tmpchr[32];

		sprintf (tmpchr, "Cygnus IRC Services v%s", version);
		memcpy (me.desc, tmpchr, sizeof (me.desc));
	    }

	    continue;
	}

	if (!stricmp (item, "BindTo"))
	{
	    if (debuglevel > 1)
	    {
		debug ("Parsing conf directive: BindTo");
		confin++;
	    }

	    s = strtok (NULL, " ");
	    strip (s);

	    if (s)
		memcpy (me.bindhost, s, sizeof (me.bindhost));
	    else
		fatal (0, "Config: Line %d: BindTo is not set properly: No host.", linecnt);

	    s = strtok (NULL, " ");   
	    strip (s);

	    if (s)
		me.bindport = atoi (s);
	    else  
		fatal (0, "Config: Line %d: BindTo is not set properly: No port.", linecnt);

	    continue;
	}

	if (!stricmp (item, "Connect"))
	{
	    if (debuglevel > 1)
	    {
		debug ("Parsing conf directive: Connect");
		confin++;
	    }

	    s = strtok (NULL, " ");
	    strip (s);

	    if (s)
		memcpy (me.uplink, s, sizeof (me.uplink));
	    else
		fatal (0, "Config: Line %d: Connect is not set properly: No uplink.", linecnt);

	    s = strtok (NULL, " ");
	    strip (s);

	    if (s)
		me.port = atoi (s);
	    else
		fatal (0, "Config: Line %d: Connect is not set properly: No port.", linecnt);

	    s = strtok (NULL, " ");
	    strip (s);

	    if (s)
		memcpy (me.pass, s, sizeof (me.pass));
	    else
		fatal (0, "Config: Line %d: Connect is not set properly: No password.", linecnt);

	    continue;
	}

	if (!stricmp (item, "SRAService"))
	{
	    /* In case the client info changes */
	    char nick[NICKLEN], user[USERLEN], host[HOSTLEN];
	    char real[REALLEN], mode[12];

	    if (debuglevel > 1)
	    {
		debug ("Parsing conf directive: SRAService");
		confin++;
	    }

	    rootserv_on = TRUE;

	    strscpy (nick, s_RootServ, sizeof (nick));
	    strscpy (user, rs.user, sizeof (user));
	    strscpy (host, rs.host, sizeof (host));
	    strscpy (real, rs.real, sizeof (real));
	    strscpy (mode, rs.mode, sizeof (mode));

	    s = strtok (NULL, " ");
	    strip (s);

	    if (s)
		memcpy (s_RootServ, s, sizeof (s_RootServ));
	    else
		fatal (0, "Config: Line %d: SRAService is not set properly: No nickname.", linecnt);

	    s = strtok (NULL, " ");
	    strip (s);

	    if (s)
		memcpy (rs.user, s, sizeof (rs.user));
	    else
		fatal (0, "Config: Line %d: SRAService is not set properly: No username.", linecnt);

	    s = strtok (NULL, " ");
	    strip (s);

	    if (s)
		memcpy (rs.host, s, sizeof (rs.host));
	    else
		fatal (0, "Config: Line %d: SRAService is not set properly: No hostname.", linecnt);

	    s = strtok (NULL, " ");
	    strip (s);

	    if (s)
	    {
		if (!strchr (s, '+'))
		    fatal (0, "Config: Line %d: SRAService: You need a + for modes!", linecnt);

		memcpy (rs.mode, s, sizeof (rs.mode));
	    }
	    else
		fatal (0, "Config: Line %d: SRAService is not set properly: No modes.", linecnt);

	    s = strtok (NULL, "");
	    strip (s);

	    if (s)
		memcpy (rs.real, s, sizeof (rs.real));
	    else
		fatal (0, "Config: Line %d: SRAService is not set properly: No realname.", linecnt);

	    if (!(runflags & RUN_STARTING))
	    {
		/* Check if the client info changed. If so, reintroduce the
		   client with the new info.
		 */
		if (rs.isonline && (strcmp (s_RootServ, nick) ||
		    strcmp (rs.user, user) || strcmp (rs.host, host) ||
		    strcmp (rs.mode, mode) || strcmp (rs.real, real)))
		{
		    send_cmd (nick, "%s :Client info changed",
			me.token ? "," : "QUIT");
		    intro_user (s_RootServ, rs.user, rs.host, rs.real, rs.mode);
		}

		/* If RootServ was previously off, and is now on, introduce
		   the pseudo client if needed.
		 */
		if (!rs.isonline)
		{
		    intro_user (s_RootServ, rs.user, rs.host, rs.real, rs.mode);
		    userstat++;
		    rs.isonline = 1;
		}
	    }

	    continue;
	}

	if (!stricmp (item, "NickNameService"))
	{
	    /* In case the client info changes */
	    char nick[NICKLEN], user[USERLEN], host[HOSTLEN];
	    char real[REALLEN], mode[12];

	    if (debuglevel > 1)
	    {
		debug ("Parsing conf directive: NickNameService");
		confin++;
	    }

	    nickserv_on = TRUE;

	    strscpy (nick, s_NickServ, sizeof (nick));
	    strscpy (user, ns.user, sizeof (user));
	    strscpy (host, ns.host, sizeof (host));
	    strscpy (real, ns.real, sizeof (real));
	    strscpy (mode, ns.mode, sizeof (mode));

	    s = strtok (NULL, " ");
	    strip (s);

	    if (s)
		memcpy (s_NickServ, s, sizeof (s_NickServ));
	    else
		fatal (0, "Config: Line %d: NickNameService is not set properly: No nickname.", linecnt);

	    s = strtok (NULL, " ");
	    strip (s);

	    if (s)
		memcpy (ns.user, s, sizeof (ns.user));
	    else
		fatal (0, "Config: Line %d: NickNameService is not set properly: No username.", linecnt);

	    s = strtok (NULL, " ");
	    strip (s);

	    if (s)
		memcpy (ns.host, s, sizeof (ns.host));
	    else
		fatal (0, "Config: Line %d: NickNameService is not set properly: No hostname.", linecnt);

	    s = strtok (NULL, " ");
	    strip (s);

	    if (s)
	    {
		if (!strchr (s, '+'))
		    fatal (0, "Config: Line %d: NickNameService: You need a + for modes!", linecnt);

		memcpy (ns.mode, s, sizeof (ns.mode));
	    }
	    else
		fatal (0, "Config: Line %d: NickNameService is not set properly: No modes.", linecnt);

	    s = strtok (NULL, "");
	    strip (s);

	    if (s)
		memcpy (ns.real, s, sizeof (ns.real));
	    else
		fatal (0, "Config: Line %d: NickNameService is not set properly: No realname.", linecnt);

	    if (!(runflags & RUN_STARTING))
	    {
		/* Check if the client info changed. If so, reintroduce the  
		   client with the new info.
		 */
		if (ns.isonline && (strcmp (s_NickServ, nick) ||
		    strcmp (ns.user, user) || strcmp (ns.host, host) ||
		    strcmp (ns.mode, mode) || strcmp (ns.real, real)))
		{
		    send_cmd (nick, "%s :Client info changed",
			me.token ? "," : "QUIT");
		    intro_user (s_NickServ, ns.user, ns.host, ns.real, ns.mode);
		}

		/* If NickServ was previously off, and is now on, introduce
		   the pseudo client if needed.
		 */
		if (!ns.isonline)
		{
		    intro_user (s_NickServ, ns.user, ns.host, ns.real, ns.mode);
		    userstat++;
		    ns.isonline = 1;
		}
	    }

	    continue;
	}

	if (!stricmp (item, "ChannelService"))
	{
	    /* In case the client info changes */
	    char nick[NICKLEN], user[USERLEN], host[HOSTLEN];
	    char real[REALLEN], mode[12];

	    if (debuglevel > 1)
	    {
		debug ("Parsing conf directive: ChannelService");
		confin++;
	    }

	    chanserv_on = TRUE;

	    strscpy (nick, s_ChanServ, sizeof (nick));
	    strscpy (user, cs.user, sizeof (user));
	    strscpy (host, cs.host, sizeof (host));
	    strscpy (real, cs.real, sizeof (real));
	    strscpy (mode, cs.mode, sizeof (mode));

	    s = strtok (NULL, " ");
	    strip (s);

	    if (s)
		memcpy (s_ChanServ, s, sizeof (s_ChanServ));
	    else
		fatal (0, "Config: Line %d: ChannelService is not set properly: No nickname.", linecnt);

	    s = strtok (NULL, " ");
	    strip (s);

	    if (s)
		memcpy (cs.user, s, sizeof (cs.user));
	    else
		fatal (0, "Config: Line %d: ChannelService is not set properly: No username.", linecnt);

	    s = strtok (NULL, " ");
	    strip (s);

	    if (s)
		memcpy (cs.host, s, sizeof (cs.host));
	    else
		fatal (0, "Config: Line %d: ChannelService is not set properly: No hostname.", linecnt);

	    s = strtok (NULL, " ");
	    strip (s);

	    if (s)
	    {
		if (!strchr (s, '+'))
		    fatal (0, "Config: Line %d: ChannelService: You need a + for modes!", linecnt);

		memcpy (cs.mode, s, sizeof (cs.mode));
	    }
	    else
		fatal (0, "Config: Line %d: ChannelService is not set properly: No modes.", linecnt);

	    s = strtok (NULL, "");
	    strip (s);

	    if (s)
		memcpy (cs.real, s, sizeof (cs.real));
	    else
		fatal (0, "Config: Line %d: ChannelService is not set properly: No realname.", linecnt);

	    if (!(runflags & RUN_STARTING))
	    {
		/* Check if the client info changed. If so, reintroduce the  
		   client with the new info.
		 */
		if (cs.isonline && (strcmp (s_ChanServ, nick) ||
		    strcmp (cs.user, user) || strcmp (cs.host, host) ||
		    strcmp (cs.mode, mode) || strcmp (cs.real, real)))
		{
		    send_cmd (nick, "%s :Client info changed",
			me.token ? "," : "QUIT");
		    intro_user (s_ChanServ, cs.user, cs.host, cs.real, cs.mode);
		}

		/* If ChanServ was previously off, and is now on, introduce
		   the pseudo client if needed.
		 */
		if (!cs.isonline)
		{
		    intro_user (s_ChanServ, cs.user, cs.host, cs.real, cs.mode);
		    userstat++;
		    cs.isonline = 1;
		}
	    }

	    continue;
	}

	if (!stricmp (item, "MemoService"))
	{
	    /* In case the client info changes */
	    char nick[NICKLEN], user[USERLEN], host[HOSTLEN];
	    char real[REALLEN], mode[12];

	    if (debuglevel > 1)
	    {
		debug ("Parsing conf directive: MemoService");
		confin++;
	    }

	    memoserv_on = TRUE;

	    strscpy (nick, s_MemoServ, sizeof (nick));
	    strscpy (user, ms.user, sizeof (user));
	    strscpy (host, ms.host, sizeof (host));
	    strscpy (real, ms.real, sizeof (real));
	    strscpy (mode, ms.mode, sizeof (mode));

	    s = strtok (NULL, " ");
	    strip (s);

	    if (s)
		memcpy (s_MemoServ, s, sizeof (s_MemoServ));
	    else
		fatal (0, "Config: Line %d: MemoService is not set properly: No nickname.", linecnt);

	    s = strtok (NULL, " ");
	    strip (s);

	    if (s)
		memcpy (ms.user, s, sizeof (ms.user));
	    else
		fatal (0, "Config: Line %d: MemoService is not set properly: No username.", linecnt);

	    s = strtok (NULL, " ");
	    strip (s);

	    if (s)
		memcpy (ms.host, s, sizeof (ms.host));
	    else
		fatal (0, "Config: Line %d: MemoService is not set properly: No hostname.", linecnt);

	    s = strtok (NULL, " ");
	    strip (s);

	    if (s)
	    {
		if (!strchr (s, '+'))
		    fatal (0, "Config: Line %d: MemoService: You need a + for modes!", linecnt);

		memcpy (ms.mode, s, sizeof (ms.mode));
	    }
	    else
		fatal (0, "Config: Line %d: MemoService is not set properly: No modes.", linecnt);

	    s = strtok (NULL, "");
	    strip (s);

	    if (s)
		memcpy (ms.real, s, sizeof (ms.real));
	    else
		fatal (0, "Config: Line %d: MemoService is not set properly: No realname.", linecnt);

	    if (!(runflags & RUN_STARTING))
	    {
		/* Check if the client info changed. If so, reintroduce the  
		   client with the new info.
		 */
		if (ms.isonline && (strcmp (s_MemoServ, nick) ||
		    strcmp (ms.user, user) || strcmp (ms.host, host) ||
		    strcmp (ms.mode, mode) || strcmp (ms.real, real)))
		{
		    send_cmd (nick, "%s :Client info changed",
			me.token ? "," : "QUIT");
		    intro_user (s_MemoServ, ms.user, ms.host, ms.real, ms.mode);
		}

		/* If MemoServ was previously off, and is now on, introduce
		   the pseudo client if needed.
		 */
		if (!ms.isonline)
		{
		    intro_user (s_MemoServ, ms.user, ms.host, ms.real, ms.mode);
		    userstat++;
		    ms.isonline = 1;
		}
	    }

	    continue;
	}

	if (!stricmp (item, "GlobalNoticer"))
	{
	    /* In case the client info changes */
	    char nick[NICKLEN], user[USERLEN], host[HOSTLEN];
	    char real[REALLEN], mode[12];

	    if (debuglevel > 1)
	    {
		debug ("Parsing conf directive: GlobalNoticer");
		confin++;
	    }

	    globalnoticer_on = TRUE;

	    strscpy (nick, s_GlobalNoticer, sizeof (nick));
	    strscpy (user, gn.user, sizeof (user));
	    strscpy (host, gn.host, sizeof (host));
	    strscpy (real, gn.real, sizeof (real));
	    strscpy (mode, gn.mode, sizeof (mode));

	    globalnoticer_on = TRUE;

	    s = strtok (NULL, " ");
	    strip (s);

	    if (s)
		memcpy (s_GlobalNoticer, s, sizeof (s_GlobalNoticer));
	    else
		fatal (0, "Config: Line %d: GlobalNoticer is not set properly: No nickname.", linecnt);

	    s = strtok (NULL, " ");
	    strip (s);

	    if (s)
		memcpy (gn.user, s, sizeof (gn.user));
	    else
		fatal (0, "Config: Line %d: GlobalNoticer is not set properly: No username.", linecnt);

	    s = strtok (NULL, " ");
	    strip (s);

	    if (s)
		memcpy (gn.host, s, sizeof (gn.host));
	    else
		fatal (0, "Config: Line %d: GlobalNoticer is not set properly: No hostname.", linecnt);

	    s = strtok (NULL, " ");
	    strip (s);

	    if (s)
	    {
		if (!strchr (s, '+'))
		    fatal (0, "Config: Line %d: GlobalNoticer: You need a + for modes!", linecnt); 

		memcpy (gn.mode, s, sizeof (gn.mode));
	    }
	    else
		fatal (0, "Config: Line %d: GlobalNoticer is not set properly: No modes.", linecnt);

	    s = strtok (NULL, "");
	    strip (s);

	    if (s)
		memcpy (gn.real, s, sizeof (gn.real));
	    else
		fatal (0, "Config: Line %d: GlobalNoticer is not set properly: No realname.", linecnt);

	    if (!(runflags & RUN_STARTING))
	    {
		/* Check if the client info changed. If so, reintroduce the
		   client with the new info.
		 */
		if (gn.isonline && (strcmp (s_GlobalNoticer, nick) ||
		    strcmp (gn.user, user) || strcmp (gn.host, host) ||
		    strcmp (gn.mode, mode) || strcmp (gn.real, real)))
		{
		    send_cmd (nick, "%s :Client info changed",
			me.token ? "," : "QUIT");
		    intro_user (s_GlobalNoticer, gn.user, gn.host, gn.real,
			gn.mode);
		}

		/* If the GlobalNoticer was previously off, and is now on,
		   introduce the pseudo client if needed.
		 */
		if (!gn.isonline)
		{
		    intro_user (s_GlobalNoticer, gn.user, gn.host, gn.real,
			gn.mode);
		    userstat++;
		    gn.isonline = 1;
		}
	    }

	    continue;
	}

	if (!stricmp (item, "SRA"))
	{
	    char *nick, *pass;

	    if (debuglevel > 1)
	    {
		debug ("Parsing conf directive: SRA");
		confin++;
	    }

	    s = strtok (NULL, " ");
	    strip (s);

	    if (s)
		nick = s;
	    else
		nick = "";

	    s = strtok (NULL, " ");
	    strip (s);

	    if (s)
		pass = s;
	    else
		pass = "";

	    if (!pass)
		fatal (0, "Config: Line %d: Missing password for SRA %s", linecnt, nick);
	    else
		new_sra (nick, pass);

	    continue;
	}

	if (!stricmp (item, "Trigger"))
	{
	    char *host;
	    int limit;

	    if (debuglevel > 1)
	    {
		debug ("Parsing conf directive: Trigger");
		confin++;
	    }

	    s = strtok (NULL, " ");
	    strip (s);

	    if (s)
		host = s;
	    else
		host = "";

	    s = strtok (NULL, " ");
	    strip (s);

	    if (s)
		limit = atoi (s);
	    else
		limit = 0;

	    if (!limit)
		fatal (0, "Config: Line %d: Missing limit for Trigger %s", linecnt, host);
	    else
		new_trigger (host, limit);

	    continue;
	}

	if (!stricmp (item, "Exception"))
	{
	    char *host;

	    if (debuglevel > 1)
	    {
		debug ("Parsing conf directive: Exception");
		confin++;
	    }

	    s = strtok (NULL, " ");
	    strip (s);

	    if (s)
		host = s;
	    else
		host = "";

	    new_exception (host);

	    continue;
	}

	if (!stricmp (item, "SyncTime"))
	{
	    if (debuglevel > 1)
	    {
		debug ("Parsing conf directive: SyncTime");
		confin++;
	    }

	    s = strtok (NULL, " ");
	    strip (s);

	    if (s)
		update_timeout = dotime (s);  
	    else
		fatal (0, "Config: Line %d: SyncTime is not set properly: No time value.", linecnt);

	    continue;
	}

	if (!stricmp (item, "NickExpire"))
	{
	    if (debuglevel > 1)
	    {
		debug ("Parsing conf directive: NickExpire");
		confin++;
	    }

	    s = strtok (NULL, " ");
	    strip (s);

	    if (s)
		nick_expire = dotime (s);
	    else
		fatal (0, "Config: Line %d: NickExpire is not set properly: No time value.", linecnt);

	    continue;
	}

	if (!stricmp (item, "ChanExpire"))
	{
	    if (debuglevel > 1)
	    {
		debug ("Parsing conf directive: ChanExpire");
		confin++;
	    }

	    s = strtok (NULL, " ");
	    strip (s);

	    if (s)
		chan_expire = dotime (s);
	    else
		fatal (0, "Config: Line %d: ChanExpire is not set properly: No time value.", linecnt);

	    continue;
	}

	if (!stricmp (item, "OperStatsServer"))
	{
	    if (debuglevel > 1)
	    {
		debug ("Parsing conf directive: OperStatsServer");
		confin++;
	    }

	    s = strtok (NULL, " ");
	    strip (s);

	    if (s)
		memcpy (operstats_server, s, sizeof (operstats_server));
	    else
		fatal (0, "Config: Line %d: OperStatsServer is not set properly: No value.", linecnt);
	}

	if (!stricmp (item, "MaxConnections"))
	{
	    if (debuglevel > 1)
	    {
		debug ("Parsing conf directive: MaxConnections");
		confin++;
	    }

	    s = strtok (NULL, " ");
	    strip (s);

	    if (s)
		maxclones = atoi (s);
	    else
		fatal (0, "Config: Line %d: MaxConnections is not set properly: No value.", linecnt);

	    s = strtok (NULL, " ");
	    strip (s);

	    if (s)
		clonekill_time = dotime (s);

	    continue;
	}

        if (!stricmp (item, "MaxCloneKills"))
        {
	    if (debuglevel > 1)
	    {
		debug ("Parsing conf directive: MaxCloneKills");
		confin++;
	    }

	    s = strtok (NULL, " ");
	    strip (s);

	    if (s)
		maxclonekills = atoi (s);
	    else
		fatal (0, "Config: Line %d: MaxCloneKills is not set properly: No value.", linecnt);

	    continue;
	}

	if (!stricmp (item, "SnoopChan"))
	{
	    if (debuglevel > 1)
	    {
		debug ("Parsing conf directive: SnoopChan");
		confin++;
	    }

	    s = strtok (NULL, " ");
	    strip (s);

	    if (s)
		memcpy (snoopchan, s, sizeof (snoopchan));
	    else
		fatal (0, "Config: Line %d: SnoopChan is not set properly: No channel.", linecnt);

	    continue;
	}

	if (!stricmp (item, "NSRegisterURL"))
	{
	    if (debuglevel > 1)
	    {
		debug ("Parsing conf directive: NSRegisterURL");
		confin++;
	    }

	    s = strtok (NULL, " ");
	    strip (s);

	    if (s)
		memcpy (nsregister_url, s, sizeof (nsregister_url));
	    else
		fatal (0, "Config: Line %d: NSRegisterURL is not set properly: No URL.", linecnt);

	    continue;
	}

	if (!stricmp (item, "CSRegisterURL"))
	{
	    if (debuglevel > 1)
	    {
		debug ("Parsing conf directive: CSRegisterURL");
		confin++;
	    }

	    s = strtok (NULL, " ");
	    strip (s);

	    if (s)
		memcpy (csregister_url, s, sizeof (csregister_url));
	    else
		fatal (0, "Config: Line %d: CSRegisterURL is not set properly: No URL.", linecnt);

	    continue;
	}

	if (!stricmp (item, "DefaultTopic"))
	{
	    if (debuglevel > 1)
	    {
		debug ("Parsing conf directive: DefaultTopic");
		confin++;
	    }

	    s = strtok (NULL, "");
	    strip (s);

	    if (s)
		memcpy (def_topic, s, sizeof (def_topic));
	    else
		fatal (0, "Config: Line %d: DefaultTopic is not set properly: No topic.", linecnt);

	    continue;
	}

	if (!stricmp (item, "CollisionURL"))
	{
	    if (debuglevel > 1)
	    {
		debug ("Parsing conf directive: CollisionURL");
		confin++;
	    }

	    s = strtok (NULL, " ");
	    strip (s);

	    if (s)
		memcpy (collision_url, s, sizeof (collision_url));
	    else
		fatal (0, "Config: Line %d: CollisionURL is not set properly: No URL.", linecnt);

	    continue;
	}

	if (!stricmp (item, "NetworkName"))
	{
	    if (debuglevel > 1)
	    {
		debug ("Parsing conf directive: NetworkName");
		confin++;
	    }

	    s = strtok (NULL, " ");
	    strip (s);

	    if (s)
		memcpy (network_name, s, sizeof (network_name));
	    else
		fatal (0, "Config: Line %d: NetworkName is not set properly: No value.", linecnt);

	    continue;
	}

	if (!stricmp (item, "SendMailPath"))
	{
	    if (debuglevel > 1)
	    {
		debug ("Parsing conf directive: SendMailPath");
		confin++;
	    }

	    s = strtok (NULL, " ");
	    strip (s);

	    if (s)
	    {
		sendmail_on = TRUE;
		memcpy (sendmail_path, s, sizeof (sendmail_path));
	    }
	    else
		fatal (0, "Config: Line %d: SendMailPath is not set properly: No value.", linecnt);

	    continue;
	}

	if (!stricmp (item, "JoinChan"))
	{
	    if (debuglevel > 1)
	    {
		debug ("Parsing conf directive: JoinChan");
		confin++;
	    }

	    s = strtok (NULL, " ");
	    strip (s);

	    if (s)
		memcpy (joinchan, s, sizeof (joinchan));
	    else
		fatal (0, "Config: Line %d: JoinChan is not set properly: No channel.", linecnt);

	    continue;
	}

	if (!stricmp (item, "TLD"))
	{
	    if (debuglevel > 1)
	    {
		debug ("Parsing conf directive: TLD");
		confin++;
	    }

	    s = strtok (NULL, "");
	    strip (s);

	    if (s)
		memcpy (tlds, s, sizeof (tlds));
	    else
		fatal (0, "Config: Line %d: TLD is not set properly: No TLDs", linecnt);

	    continue;
        }

	if (!stricmp (item, "Salt"))
	{
	    if (debuglevel > 1)
	    {
		debug ("Parsing conf directive: Salt");
		confin++;
	    }

	    s = strtok (NULL, "");
	    strip (s);

	    if (s)
		memcpy (salt, s, sizeof (salt));
	    else
		fatal (0, "Config: Line %d: Salt is not set properly: No value", linecnt);

	    continue;
	}

	if (!stricmp (item, "AKillExpire"))
	{
	    if (debuglevel > 1)
	    {
		debug ("Parsing conf directive: AKillExpire");
		confin++;
	    }

	    s = strtok (NULL, "");
	    strip (s);

	    if (s)
		def_akill_time = dotime (s);
	    else
		fatal (0, "Config: Line %d: AKillExpire is not set properly: No time value.", linecnt);

	    continue;
	}

	if (!stricmp (item, "TempExpire"))
	{
	    if (debuglevel > 1)
	    {
		debug ("Parsing conf directive: TempExpire");
		confin++;
	    }

	    s = strtok (NULL, "");
	    strip (s);

	    if (s)
		tempexpire = dotime (s);
	    else
		fatal (0, "Config: Line %d: TempExpire is not set properly: No time value.", linecnt);

	    continue;
	}

	if (!stricmp (item, "NonWildCards"))
	{
	    if (debuglevel > 1)
	    {
		debug ("Parsing conf directive: NonWildCards");
		confin++;
	    }

	    s = strtok (NULL, "");
	    strip (s);

	    if (s)
		nonwildreq = atol (s);
	    else
		fatal (0, "Config: Line %d: NonWildCards is not set properly: No value.", linecnt);

	    continue;
	}

	if (!stricmp (item, "NSRegisterType"))
	{
	    if (debuglevel > 1)
	    {
		debug ("Parsing conf directive: NSRegisterType");
		confin++;
	    }

	    s = strtok (NULL, "");
	    strip (s);

	    if (s)
	    {
		if (!stricmp (s, "Normal"))
		    nsregistertype = 0;
		if (!stricmp (s, "EMailAuth"))
		    nsregistertype = 1;
		if (!stricmp (s, "EMailNoAuth"))
		    nsregistertype = 2;
		if (!stricmp (s, "PassAuth"))
		    nsregistertype = 3;
		if (!stricmp (s, "Verify"))
		    nsregistertype = 4;
		if (!stricmp (s, "EMailVerify"))
		    nsregistertype = 5;
		if (!stricmp (s, "AuthVerify"))
		    nsregistertype = 6;
	    }
	    else
		fatal (0, "Config: Line %d: NSRegisterType is not set properly: No value.", linecnt);

	    continue;
	}

	if (!stricmp (item, "CSRegisterType"))
	{
	    if (debuglevel > 1)
	    {
		debug ("Parsing conf directive: CSRegisterType");
		confin++;
	    }

	    s = strtok (NULL, "");
	    strip (s);

	    if (s)
	    {
		if (!stricmp (s, "Normal"))
		    csregistertype = 0;
		if (!stricmp (s, "EMailAuth"))
		    csregistertype = 1;
		if (!stricmp (s, "Verify"))
		    csregistertype = 2;
		if (!stricmp (s, "AuthVerify"))
		    csregistertype = 3;
		if (!stricmp (s, "CSOpVerify"))
		    csregistertype = 4;
	    }
	    else
		fatal (0, "Config: Line %d: CSRegisterType is not set properly: No value.", linecnt);

	    continue;
	}

	if (!stricmp (item, "AKickMax"))
	{
	    if (debuglevel > 1)
	    {
		debug ("Parsing conf directive: AKickMax");
		confin++;
	    }

	    s = strtok (NULL, " ");
	    strip (s);

	    if (s)
		akickmax = atoi (s);
	    else
		fatal (0, "Config: Line %d: AKickMax is not set properly: No value.", linecnt);

	    continue;
	}

	if (!stricmp (item, "EMailLimit"))
	{
	    if (debuglevel > 1)
	    {
		debug ("Parsing conf directive: EMailLimit");
		confin++;
	    }

	    s = strtok (NULL, " ");
	    strip (s);

	    if (s)
		emaillimit = atoi (s);
	    else
		fatal (0, "Config: Line %d: EMailLimit is not set properly: No value.", linecnt);

	    continue;
	}

	if (!stricmp (item, "ChannelLimit"))
	{
	    if (debuglevel > 1)
	    {
		debug ("Parsing conf directive: ChannelLimit");
		confin++;
	    }

	    s = strtok (NULL, " ");
	    strip (s);

	    if (s)
		chanlimit = atoi (s);
	    else
		fatal (0, "Config: Line %d: ChannelLimit is not set properly: No value.", linecnt);

	    continue;
	}

	if (!stricmp (item, "SecuritySetting"))
	{
	    if (debuglevel > 1)
	    {
		debug ("Parsing conf directive: SecuritySetting");
		confin++;
	    }

	    s = strtok (NULL, "");
	    strip (s);

	    if (s)
	    {
		if (!stricmp (s, "All"))
		    securitysetting = 1;
		if (!stricmp (s, "Passwords"))
		    securitysetting = 2;
		if (!stricmp (s, "None"))
		    securitysetting = 0;
	    }
	    else
		fatal (0, "Config: Line %d: SecuritySetting is not set properly: No value.", linecnt);

	    continue;
	}

	if (!stricmp (item, "GlobalMSG"))
	{
	    if (debuglevel > 1)
	    {
		debug ("Parsing conf directive: GlobalMSG");
		confin++;
	    }

	    s = strtok (NULL, "");
	    strip (s);

	    if (s)
		memcpy (globalmsg, s, sizeof (globalmsg));
	    else
		fatal (0, "Config: Line %d: GlobalMSG is not set properly: No message.", linecnt);

	    continue;
	}

	if (!stricmp (item, "UnrealNumeric"))
	{
	    if (debuglevel > 1)
	    {
		debug ("Parsing conf directive: UnrealNumeric");
		confin++;
	    }

	    s = strtok (NULL, "");
	    strip (s);

	    if (s)
		unreal_numeric = atol (s);
	    else
		fatal (0, "Config: Line %d: UnrealNumeric is not set properly: No value.", linecnt);

	    continue;
	}

	if (!stricmp (item, "DefaultAKillReason"))
	{
	    if (debuglevel > 1)
	    {
		debug ("Parsing conf directive: DefaultAKillReason");
		confin++;
	    }

	    s = strtok (NULL, "");
	    strip (s);

	    if (s)
		memcpy (def_akill_reason, s, sizeof (def_akill_reason));
	    else
		fatal (0, "Config: Line %d: DefaultAKillReason is not set properly: No reason.", linecnt);

	    continue;
	}

	if (!stricmp (item, "DefaultAKickReason"))
	{
	    if (debuglevel > 1)
	    {
		debug ("Parsing conf directive: DefaultAKickReason");
		confin++;
	    }

	    s = strtok (NULL, "");
	    strip (s);

	    if (s)
		memcpy (def_akick_reason, s, sizeof (def_akick_reason));
	    else
		fatal (0, "Config: Line %d: DefaultAKickReason is not set properly: No reason.", linecnt);

	    continue;
	}

	if (!stricmp (item, "WaitRestart"))
	{
	    if (debuglevel > 1)
	    {
		debug ("Parsing conf directive: WaitRestart");
		confin++;
	    }

	    s = strtok (NULL, "");
	    strip (s);

	    if (s)
		wait_restart = dotime (s);
	    else
		fatal (0, "Config: Line %d: WaitRestart is not set properly: No time value.", linecnt);

	    continue;
	}

	if (!stricmp (item, "PassFails"))
	{
	    if (debuglevel > 1)
	    {
		debug ("Parsing conf directive: PassFails");
		confin++;
	    }

	    s = strtok (NULL, "");
	    strip (s);

	    if (s)
		passfails = atol (s);
	    else
		fatal (0, "Config: Line %d: PassFails is not set properly.", linecnt);

	    continue;
	}

	if (!stricmp (item, "MaxLinks"))
	{
	    if (debuglevel > 1)
	    {
		debug ("Parsing conf directive: MaxLinks");
		confin++;
	    }

	    s = strtok (NULL, "");
	    strip (s);

	    if (s)
		maxlinks = atol (s);
	    else
		fatal (0, "Config: Line %d: MaxLinks is not set properly.", linecnt);

	    continue;
	}

	if (!stricmp (item, "MemoMailMax"))
	{
	    if (debuglevel > 1)
	    {
		debug ("Parsing conf directive: MemoMailMax");
		confin++;
	    }

	    s = strtok (NULL, "");
	    strip (s);

	    if (s)
		memomailmax = atol (s);
	    else
		fatal (0, "Config: Line %d: MemoMailMax is not set properly.", linecnt);

	    continue;
	}

	if (!stricmp (item, "MemosFromUser"))
	{
	    if (debuglevel > 1)
	    {
		debug ("Parsing conf directive: MemosFromUser");
		confin++;
	    }

	    s = strtok (NULL, "");
	    strip (s);

	    if (s)
		memosfromuser = atol (s);
	    else
		fatal (0, "Config: Line %d: MemosFromUser is not set properly.", linecnt);

	    continue;
	}

	if (!stricmp (item, "MemoBoxSize"))
	{
	    if (debuglevel > 1)
	    {
		debug ("Parsing conf directive: MemoBoxSize");
		confin++;
	    }

	    s = strtok (NULL, "");
	    strip (s);

	    if (s)
		memobox_size = atol (s);
	    else
		fatal (0, "Config: Line %d: MemoBoxSize is not set properly.", linecnt);

	    continue;
	}

	if (!stricmp (item, "Delays"))
	{
	    if (debuglevel > 1)
	    {
		debug ("Parsing conf directive: Delays");
		confin++;
	    }

	    s = strtok (NULL, " ");
	    strip (s);

	    if (s)
		nick_delay = dotime (s);
	    else
		fatal (0, "Config: Line %d: Delays is not set properly: No Nick Reg Delay.", linecnt);

	    s = strtok (NULL, " ");
	    strip (s);

	    if (s)
		chan_delay = dotime (s);
	    else
		fatal (0, "Config: Line %d: Delays is not set properly: No Chan Reg Delay.", linecnt);

	    s = strtok (NULL, " ");
	    strip (s);

	    if (s)
		memo_delay = dotime (s);
	    else
		fatal (0, "Config: Line %d: Delays is not set properly: No Memo Send Delay.", linecnt);

	    continue;
	}

	if (!stricmp (item, "NickFlags"))
	{
	    if (debuglevel > 1)
	    {
		debug ("Parsing conf directive: NickFlags");
		confin++;
	    }

	    s = strtok (NULL, "");
	    strip (s);

	    if (!s)
		fatal (0, "Config: Line %d: NickFlags is not set properly: No value.", linecnt);

	    if (stristr (s, "Enforce"))
		defnickflags |= NF_ENFORCE;

	    if (stristr (s, "Secure"))
		defnickflags |= NF_SECURE;

	    if (stristr (s, "MailVisibility"))
	    {
		if (showmail_on == TRUE)
		    defnickflags |= NF_SHOWMAIL;
		else
		    defnickflags |= NF_HIDEMAIL;
	    }

	    if (stristr (s, "NeverOp"))
		defnickflags |= NF_NEVEROP;

	    if (stristr (s, "NoOp"))
		defnickflags |= NF_NOOP;

	    if (stristr (s, "NoSuccessor"))
		defnickflags |= NF_NOSUCCESSOR;

	    if (stristr (s, "Private"))
		defnickflags |= NF_PRIVATE;

	    if (stristr (s, "NoMemo"))
		defnickflags |= NF_NOMEMO;

	    if (stristr (s, "Receipts"))
		defnickflags |= NF_RECEIPTS;

	    /* We'll turn this off when we run checkconf if we need to */
	    if (stristr (s, "MemoMail"))
		defnickflags |= NF_MEMOMAIL;

	    continue;
	}

	if (!stricmp (item, "ChanFlags"))
	{
	    if (debuglevel > 1)
	    {
		debug ("Parsing conf directive: ChanFlags");
		confin++;
	    }

	    s = strtok (NULL, "");
	    strip (s);

	    if (!s)
		fatal (0, "Config: Line %d: ChanFlags is not set properly: No value.", linecnt);

	    if (stristr (s, "Verbose"))
		defchanflags |= CF_VERBOSE;

	    if (stristr (s, "VOPAll"))
		defchanflags |= CF_VOPALL;

	    if (stristr (s, "Secure"))
		defchanflags |= CF_SECURE;

	    if (stristr (s, "Restricted"))
		defchanflags |= CF_RESTRICTED;

	    continue;
	}

	if (!stricmp (item, "DefaultModes"))
	{
	    if (debuglevel > 1)
	    {
		debug ("Parsing conf directive: DefaultModes");
		confin++;
	    }

	    s = strtok (NULL, " ");
	    strip (s);

	    if (!s)
		fatal (0, "Config: Line %d: DefaultModes is not set properly: No value.", linecnt);

	    if (strstr (s, "+") || strstr (s, "-"))
		fatal (0, "Config: Line %d: DefaultModes is not set properly. Do not use + or -.", linecnt);

	    defmlock_on = string_to_flags (s);

	    s = strtok (NULL, " ");
	    strip (s);

	    if (s)
	    {
		if (strstr (s, "+") || strstr (s, "-"))
		    fatal (0, "Config: Line %d: DefaultModes is not set properly. Do not use + or -.", linecnt);

		defmlock_off = string_to_flags (s);
	    }

	    continue;
	}

	if (!stricmp (item, "IRCdType"))
	{
	    if (debuglevel > 1)
	    {
		debug ("Parsing conf directive: IRCdType");
		confin++;
	    }

	    s = strtok (NULL, "");
	    strip (s);

	    if (!s)
		fatal (0, "Config: Line %d: IRCdType is not set properly: No value.", linecnt);

	    if (stristr (s, "DreamForge"))
		ircdtype = DREAMFORGE;

	    else if (stristr (s, "Prometheus"))
		ircdtype = PROMETHEUS;

	    else if (stristr (s, "Bahamut"))
		ircdtype = BAHAMUT;

	    else if (stristr (s, "Unreal 3"))
		ircdtype = UNREAL3;

	    else if (stristr (s, "Unreal 3.2"))
		ircdtype = UNREAL3_2;

	    else
		fatal (0, "Config: Line %d: IRCdType is not set properly: Invalid value.", linecnt);

	    continue;
	}

	if (!stricmp (item, "CollideType"))
	{
	    if (debuglevel > 1)
	    {
		debug ("Parsing conf directive: CollideType");
		confin++;
	    }

	    s = strtok (NULL, "");
	    strip (s);

	    if (!s)
		fatal (0, "Config: Line %d: CollideType is not set properly: No value.", linecnt);

	    if (stristr (s, "Guest"))
		collidetype = 1;

	    if (stristr (s, "User"))
		collidetype = 2;

	    if (stristr (s, "Nick"))
		collidetype = 3;

	    if (stristr (s, "Underscore"))
		collidetype = 4;

	    if (stristr (s, "Hyphen"))
		collidetype = 5;

	    if (stristr (s, "Kill"))
		collidetype = 6;

	    continue;
	}

	if (!stricmp (item, "HelpIndex"))
	{
	    if (debuglevel > 1)
	    {
		debug ("Parsing conf directive: HelpIndex");
		confin++;
	    }

	    s = strtok (NULL, "");
	    strip (s);

	    if (!s)
		fatal (0, "Config: Line %d: HelpIndex is not set properly: No value.", linecnt);

	    if (stristr (s, "Short"))
		helpindex = 1;

	    if (stristr (s, "Medium"))
		helpindex = 2;

	    if (stristr (s, "Long"))
		helpindex = 3;

	    continue;
	}

	if (!stricmp (item, "FloodTrigger"))
	{
	    if (debuglevel > 1)
	    {
		debug ("Parsing conf directive: FloodTrigger");
		confin++;
	    }

	    s = strtok (NULL, " ");
	    strip (s);

	    if (s)
		floodmsgs = atoi (s);
	    else
		fatal (0, "Config: Line %d: FloodTrigger is not set properly: No message amount.", linecnt);

	    s = strtok (NULL, " ");
	    strip (s);

	    if (s)
		floodtime = dotime (s);
	    else
		fatal (0, "Config: Line %d: FloodTrigger is not set properly: No message time.", linecnt);

	    continue;
	}

	if (!stricmp (item, "GlobalOnAKill"))
	{
	    if (debuglevel > 1)
	    {
		debug ("Parsing conf directive: GlobalOnAKill");
		confin++;
	    }

	    globalonakill_on = TRUE;
	    continue;
	}

	if (!stricmp (item, "GlobalOnAuth"))
	{
	    if (debuglevel > 1)
	    {
		debug ("Parsing conf directive: GlobalOnAuth");
		confin++;
	    }

	    globalonauth_on = TRUE;
	    continue;
	}

	if (!stricmp (item, "ShareAKills"))
	{
	    if (debuglevel > 1)
	    {
		debug ("Parsing conf directive: ShareAkills");
		confin++;
	    }

	    shareakills_on = TRUE;
	    continue;
	}

	if (!stricmp (item, "ShareSRAs"))
	{
	    if (debuglevel > 1)
	    {
		debug ("Parsing conf directive: ShareSRAs");
		confin++;
	    }

	    sharesras_on = TRUE;
	    continue;
	}

	if (!stricmp (item, "LogUpdates"))
	{
	    if (debuglevel > 1)
	    {
		debug ("Parsing conf directive: LogUpdates");
		confin++;
	    }

	    logupdates_on = TRUE;
	    continue;
	}

	if (!stricmp (item, "SecureSRA"))
	{
	    if (debuglevel > 1)
	    {
		debug ("Parsing conf directive: SecureSRA");
		confin++;
	    }

	    securesra_on = TRUE;
	    continue;
	}

	if (!stricmp (item, "HaveServ"))
	{
	    if (debuglevel > 1)
	    {
		debug ("Parsing conf directive: HaveServ");
		confin++;
	    }

	    haveserv_on = TRUE;
	    continue;
	}

	if (!stricmp (item, "UseEMail"))
	{
	    if (debuglevel > 1)
	    {
		debug ("Parsing conf directive: UseEMail");
		confin++;
	    }

	    email_on = TRUE;
	    continue;
	}

	if (!stricmp (item, "UseURL"))
	{
	    if (debuglevel > 1)
	    {
		debug ("Parsing conf directive: UseURL");
		confin++;
	    }

	    url_on = TRUE;
	    continue;
	}

	if (!stricmp (item, "UseUIN"))
	{
	    if (debuglevel > 1)
	    {
		debug ("Parsing conf directive: UseUIN");
		confin++;
	    }

	    uin_on = TRUE;
	    continue;
	}

	if (!stricmp (item, "UseMemoMail"))
	{
	    if (debuglevel > 1)
	    {
		debug ("Parsing conf directive: UseMemoMail");
		confin++;
	    }

	    memomail_on = TRUE;
	    continue;
	}

	if (!stricmp (item, "UsePrivMSG"))
	{
	    if (debuglevel > 1)
	    {
		debug ("Parsing conf directive: UsePrivMSG");
		confin++;
	    }

	    privmsg_on = TRUE;
	    continue;
	}

	if (!stricmp (item, "UseShowMail"))
	{
	    if (debuglevel > 1)
	    {
		debug ("Parsing conf directive: UseShowMail");
		confin++;
	    }

	    showmail_on = TRUE;
	    continue;
	}

	if (!stricmp (item, "UseName"))
	{
	    if (debuglevel > 1)
	    {
		debug ("Parsing conf directive: UseName");
		confin++;
	    }

	    name_on = TRUE;
	    continue;
	}

	if (!stricmp (item, "UseAge"))
	{
	    if (debuglevel > 1)
	    {
		debug ("Parsing conf directive: UseAge");
		confin++;
	    }

	    age_on = TRUE;
	    continue;
	}

	if (!stricmp (item, "UseSex"))
	{
	    if (debuglevel > 1)
	    {
		debug ("Parsing conf directive: UseSex");
		confin++;
	    }

	    sex_on = TRUE;
	    continue;
	}

	if (!stricmp (item, "UseLocation"))
	{
	    if (debuglevel > 1)
	    {
		debug ("Parsing conf directive: UseLocation");
		confin++;
	    }

	    location_on = TRUE;
	    continue;
	}

	if (!stricmp (item, "SecureVOP"))
	{
	    if (debuglevel > 1)
	    {
		debug ("Parsing conf directive: SecureVOP");
		confin++;
	    }

	    securevop_on = TRUE;
	    continue;
	}

	if (!stricmp (item, "StatusGlobals"))
	{
	    if (debuglevel > 1)
	    {
		debug ("Parsing conf directive: StatusGlobals");
		confin++;
	    }

	    statglobal_on = TRUE;
	    continue;
	}

	if (!stricmp (item, "NoisyFlood"))
	{
	    if (debuglevel > 1)
	    {
		debug ("Parsing conf directive: NoisyFlood");
		confin++;
	    }

	    noisyflood_on = TRUE;
	    continue;
	}

	if (!stricmp (item, "WebIntegration"))
	{
	    if (debuglevel > 1)
	    {
		debug ("Parsing conf directive: WebIntegration");
		confin++;
	    }

	    webint_on = TRUE;
	    continue;
	}

	if (!stricmp (item, "RecoverKill"))
	{
	    if (debuglevel > 1)
	    {
		debug ("Parsing conf directive: RecoverKill");
		confin++;
	    }

	    recoverkill_on = TRUE;
	    continue;
	}

	if (!stricmp (item, "UseFakeHost"))
	{
	    if (debuglevel > 1)
	    {
		debug ("Parsing conf directive: UseFakeHost");
		confin++;
	    }

	    fakehost_on = TRUE;
	    continue;
	}
    }

    fclose (f);

#ifdef HAVE_GETTIMEOFDAY
    gettimeofday (&now, NULL);
    timersub (&now, &start, &tmp);
    log_sameline (0, "finished in %d ms", tv2ms (&tmp));
#endif

    if (debuglevel > 1)
#ifdef HAVE_GETTIMEOFDAY
        debug ("Parsed %d conf options in %d ms", confin, tv2ms (&tmp));
#else
	debug ("Parsed %d conf options", confin);
#endif
}

/* Sanity checks on the config options */
int check_conf ()
{
    SRA *sra;
    int i = 0;

    for (sra = sralist; sra; sra = sra->next)
	i++;

    if (!i)
	fatal (0, "Config: You must have at least one SRA.");

    if (!ircdtype)
	fatal (0, "Config: IRCdType must be set.");

    if (strlen (salt) && !(strlen (salt) == 2))
	fatal (0, "Config: Invalid Salt setting. Salt must be TWO CHARACTERS.");

    if (rootserv_on == FALSE)
	fatal (0, "Config: SRAService cannot be disabled.");

    if (memoserv_on == TRUE && nickserv_on == FALSE)
    {
	printf ("Warning: MemoService requires NickNameService. MemoService disabled.\n");
	memoserv_on = FALSE;
    }

    if (memomail_on == TRUE && sendmail_on == FALSE)
    {
	printf ("Warning: MemoMail requires SendMailPath. MemoMail disabled.\n");

	/* Turn memomail off */
	memomail_on = FALSE;

	/* Take it out of defnickflags if we need to */
	defnickflags &= ~NF_MEMOMAIL;
    }

    if (memomail_on == TRUE && email_on == FALSE)
    {
	printf ("Warning: MemoMail requires UseEMail. MemoMail disabled.\n");

	/* Turn memomail off */
	memomail_on = FALSE;

	/* Take it out of defnickflags if we need to */
	defnickflags &= ~NF_MEMOMAIL;
    }

    if (sendmail_on == TRUE && email_on == FALSE)
    {
	printf ("Warning: SendMailPath can't do anything without UseEMail. SendMailPath disabled.\n");
	sendmail_on = FALSE;
	*sendmail_path = 0;
    }

    if (memomail_on == TRUE && !memomailmax)
    {
	printf ("Warning: MemoMailMax is required for MemoMail. MemoMail disabled.\n");

	/* Turn memomail off */
	memomail_on = FALSE;

	/* Take it out of defnickflags if we need to */
	defnickflags &= ~NF_MEMOMAIL;
    }

    if (sendmail_on == FALSE && (nsregistertype == 1 || nsregistertype == 3 ||
				 nsregistertype == 6 || csregistertype == 1 ||
				 csregistertype == 3))
	fatal (0, "Config: E-Mail Auth Registration requires SendMail.");

    if (!collidetype)
	collidetype = 1;

    if (!helpindex)
	helpindex = 2;

    if (!memobox_size)
	memobox_size = 25;

    if (!akickmax)
	akickmax = 50;

    if (!chanlimit)
	chanlimit = 5;

    if (!update_timeout)
	update_timeout = 300;

    if (!def_akill_time)
	def_akill_time = 604800; /* One week */

    if (!clonekill_time)
	clonekill_time = def_akill_time;

    if (!nonwildreq)
	nonwildreq = 5;

    if (update_timeout < 60)
	printf ("Warning: Setting SyncTime less than 1 minute is unwise!\n");

    defmlock_on |= CMODE_r;

    if (wait_restart < 5)
	fatal (0, "Config: WaitRestart cannot be less than 5s.");

    if (!strlen (tlds) && (globalnoticer_on == TRUE))
    {
        printf ("Config: TLD is not set properly. GlobalNoticer disabled.\n");
	globalnoticer_on = FALSE;
    }

    if (globalnoticer_on == FALSE)
	statglobal_on = FALSE;

    if (!strlen (network_name))
	fatal (0, "Config: NetworkName must be set.");

    if (!strlen (def_akick_reason))
	memcpy (def_akick_reason, "User has been banned from channel", sizeof (def_akick_reason));

    if ((ircdtype == UNREAL3 || ircdtype == UNREAL3_2) && !unreal_numeric)
	fatal (0, "Config: UnrealNumeric is required for UnrealIRCd.");

    if ((ircdtype == UNREAL3 || ircdtype == UNREAL3_2) && (unreal_numeric < 1 || unreal_numeric > 255))
	fatal (0, "Config: UnrealNumeric is not set properly: Must be between 1 and 255.");

    if (!nick_expire)
	fatal (0, "Config: NickExpire is not set properly.");

    if (!chan_expire)
	fatal (0, "Config: ChanExpire is not set properly.");

    return 1;
}
