/* External functions

   Cygnus IRC Services - Copyright (c) 2001-2002 Darcy Grexton
   Contact: skold@habber.net, skold @ HabberNet

   See doc/LICENSE for licensing details.
 */

#define E extern	/* Save us some typing */

/* conf.c */
E SRA *sralist;
E void reset_conf ();
E void load_conf ();
E int check_conf ();
E char s_RootServ[NICKLEN], s_NickServ[NICKLEN], s_MemoServ[NICKLEN];
E char s_ChanServ[NICKLEN], s_GlobalNoticer[NICKLEN], tlds[64];
E char snoopchan[32], def_akill_reason[256], joinchan[32], def_modes[32];
E char sendmail_path[512], network_name[32], nsregister_url[256], salt[2];
E char csregister_url[256], collision_url[256], globalmsg[64];
E char def_topic[350], def_akick_reason[256], operstats_server[65];
E Boolean_T rootserv_on, nickserv_on, memoserv_on;
E Boolean_T chanserv_on, globalnoticer_on, fakehost_on;
E Boolean_T globalonakill_on, logupdates_on, age_on;
E Boolean_T shareakills_on, sex_on, recoverkill_on;
E Boolean_T name_on, location_on, privmsg_on, webint_on;
E Boolean_T showmail_on, sendmail_on, email_on;
E Boolean_T url_on, uin_on, memomail_on, securevop_on;
E Boolean_T securesra_on, globalonauth_on, haveserv_on;
E Boolean_T statglobal_on, noisyflood_on, sharesras_on;
E uint8 unreal_numeric, nonwildreq, passfails, chanlimit, maxclones, maxclonekills;
E uint8 maxlinks, memobox_size, memomailmax, memosfromuser, csregistertype;
E uint8 nsregistertype, securitysetting, emaillimit, collidetype, floodmsgs;
E uint8 akickmax, helpindex, ircdtype;
E uint16 update_timeout, wait_restart, floodtime;
E uint32 nick_expire, chan_expire, memo_delay, nick_delay, chan_delay, tempexpire;
E uint32 def_akill_time, clonekill_time, defnickflags, defchanflags, defmlock_on;
E uint32 defmlock_off;

/* socket.c */
E int16 conn (const char *host, int port, const char *lhost, int lport);
E void disconn (int s);
E void sendtoserver (char *fmt,...);
E void read_loop ();

/* main.c */
E Mail *emaillist[HASHSIZE];
E Zone *zonelist;
E struct timeval burstnow, burstms, bursttmp;
E char quitmsg[BUFSIZE], inbuf[BUFSIZE * 8];
E int8 servsock;
E uint8 debuglevel, servcnt, bursting, bursted, force, rehashing;
E uint32 usercnt, chancnt, userstat, maxuptime, runflags;               
E time_t last_update, last_check, news_time, burststart;
E void intro_user (const char *nick, const char *user, const char *host, const char *real, const char *modes);
E int is_one_of_mine (const char *nick);
E const char version[];
E const char build[];
E const char compile_time[];
E const char *infotext[];
E void chk ();

/* function.c */
E void open_log ();
E void open_debug ();
E void log (const char *fmt,...);
E void log_sameline (int sameline, const char *fmt,...);
E void debug (const char *fmt,...);
E void close_log ();
E void close_debug ();
E void fatal (int sameline, const char *fmt,...);
E void send_cmd (const char *source, const char *fmt, ...);
E void vsend_cmd (const char *source, const char *fmt, va_list args);
E void notice (const char *source, const char *dest, const char *fmt, ...); 
E void opnotice (const char *source, const char *dest, const char *fmt,...);
E void noticeall (const char *fmt, ...);
E void noticecsops (const char *source, const char *fmt, ...);
E void globops (const char *whoami, const char *fmt, ...);
E void ctcpreply (const char *source, const char *dest, const char *fmt, ...);
E int is_sra (User *u);
E int is_csop (User *u);
E int is_oper (User *u);
E int is_on_chan (const char *nick, const char *chan);
E int is_opped (const char *nick, const char *chan);
E int is_voiced (const char *nick, const char *chan);
E int is_halfopped (const char *nick, const char *chan);
E int can_sra (const char *nick);
E int can_csop (const char *nick);
E size_t sstrlcpy (char *dst, const char *src, size_t siz);
E size_t sstrlcat (char *dst, const char *src, size_t siz);
E void *smalloc (long size);
E void *scalloc (long elsize, long els);
E void *srealloc (void *oldptr, long newsize);
E char *sstrdup (const char *s);
E char *stristr (char *s1, char *s2);
E int match_wild (const char *pattern, const char *str);
E int match_wild_nocase (const char *pattern, const char *str);   
E char *strupper (char *s);
E char *strlower (char *s);
E void strip (char *line);
E void notice_list (const char *source, const char *dest, const char **text);
E SRA *findsra (const char *nick);
E Zone *findzone (int zindex);
E int is_akilled (const char *mask);
E int dotime (const char *s);
E char *create_mask (User *u);
E void snoop (const char *source, const char *fmt,...);
E char *duration (time_t event, int format);
E char *strscpy (char *d, const char *s, size_t len);
E char *time_ago (time_t event);
E char *zone_time (NickInfo *ni, time_t event, int fulldate);
E char *get_time (time_t event, int fulldate, int offset, char *zone);
E char *stripcodes (char *buffer);
E char *replace (char *s, int32 size, const char *old, const char *new);
#ifdef WIN32
#define itoa in_itoa
#endif
E char *itoa (int num);
E void flushlists ();
E NickInfo *findnick (const char *nick);
E NickInfo *nextni ();
E NickInfo *firstni ();
E NickInfo *get_nick (User *u);
E int ispass (char *text);
E int isctcp (char *command);
E int validemail (char *email, const char *source);
E Verify *findverify (const char *name);
E Mail *findemail (const char *email);
E int check_email (const char *email);
E void expire_emails ();
E void check_verifies (User *u);
E void scan_verifies ();
E void verify_notice (Verify *vf);
E unsigned long makekey ();
E void sendemail (const char *what, const char *param, int type);
E int check_ns_auth (const char *whoami, const char *source, NickInfo *ni);
E int check_cs_auth (const char *whoami, const char *source, ChanInfo *ci);
E void errmoreinfo (const char *whoami, const char *source, char *text);
E void joinchan_join ();
E void joinchan_part ();
E int32 string_to_flags (char *modes);
E char *flags_to_string (int32 flags);
E int32 mode_to_flag (char c);
E char mode_to_char (int32 f);
E int32 prefix_to_flag (char c);
E uint32 time_msec ();
E int tv2ms (struct timeval *tv);
E void check_eb ();
E void notify_new_memo (NickInfo *ni, Memo *m);
E void save_web_dbase ();
E void read_web_log ();
E void passfail (const char *whoami, const char *what, const char *str, User *u);
E void load_zones ();
E unsigned long shash (const unsigned char *text);
E void db_backup (int delete);
E void helpcolumns (User *u, const char *whoami, const char *prefix, const char *commands);
E void svssend (const char *fmt,...);
E int servcount ();

/* process.c */
E int8 split_buf (char *buf, char ***argv_ptr);
E void process ();

/* timeout.c */
E void check_timeouts ();
E Timeout *add_timeout_ms (int delay, void (*code)(Timeout *), int repeat);
E Timeout *add_timeout (int delay, void (*code)(Timeout *), int repeat);
E void del_timeout (Timeout *t);
E void add_ns_timeout (NickInfo *ni, int type, time_t delay);
E void add_cs_timeout (ChanInfo *ci, int type, time_t delay);
E void del_ns_timeout (NickInfo *ni, int type, int del_to);
E void del_cs_timeout (ChanInfo *ci, int type, int del_to);

/* server.c */
E Channel *chanlist[HASHSIZE];
E User *userlist[HASHSIZE];
E Server *servlist[HASHSIZE];
E Clone *clonelist[HASHSIZE];
E User *finduser (const char *nick);
E User *firstuser ();
E User *nextuser (); 
E Server *new_server (const char *name);
E void delete_server (Server *server);
E Server *findserv (const char *name);
E Server *firstserv ();
E Server *nextserv ();
E Channel *findchan (const char *chan);
E Channel *firstchan ();
E Channel *nextchan ();
E Channel *chan_adduser (User *user, const char *chan, int32 modes);
E void chan_deluser (User *user, Channel *c);
E void do_nick (const char *source, int8 ac, char **av);
E void do_umode (const char *source, int8 ac, char **av);
E void do_cmode (const char *source, int8 ac, char **av);
E void delete_user (User * user);
E void do_join (const char *source, int8 ac, char **av);
E void do_part (const char *source, int8 ac, char **av);
E void do_kick (const char *source, int8 ac, char **av);
E void do_quit (const char *source, int8 ac, char **av);
E void do_topic (const char *source, int8 ac, char **av);
E void do_kill (const char *source, int8 ac, char **av);
E void kill_user (const char *source, const char *user, const char *reason);
E void do_sjoin (const char *source, int8 ac, char **av);
E void send_cmode (const char *sender, ...);
E void flush_cmodes ();

/* rootserv.c */
E int32 akillcnt;
E int32 akill_size;
E struct akill_ *akills;
E Trigger *triggerlist;
E Exception *exceptionlist;
E void globalnoticer (User *u, char *buf);
E void rootserv (User *u, char *buf);
E int check_akill (const char *nick, const char *user, const char *host, const char *real);
E void load_rs_dbase ();
E void save_rs_dbase ();
E void expire_akills ();
E void rehash (const char *source);
E Trigger *new_trigger (const char *host, int limit);
E Trigger *findtrig (const char *user, const char *host);
E Exception *findexcept (const char *user, const char *host);
E Exception *new_exception (const char *host);

/* nickserv.c */
E NickInfo *nicklist[HASHSIZE];
E int delnick (NickInfo *ni);
E int sstamp;
E void nickserv (User *u, char *buf);
E void load_ns_dbase ();
E void save_ns_dbase ();
E int validate_user (User *u);
E void cancel_user (User * u);
E void release (NickInfo *ni, int from_timeout);
E void collide (NickInfo *ni, int from_timeout, int recovered);
E void expire_nicks ();
E int islinked (const char *nick, NickInfo *ni);

/* chanserv.c */
E ChanInfo *cs_chanlist[HASHSIZE];
E int32 verifycnt;
E int32 verify_size;
E struct verify_ *verify;
E int delchan (ChanInfo *ci, int fromdelnick);
E ChanInfo *cs_findchan (const char *chan);
E ChanInfo *firstci ();
E ChanInfo *nextci ();
E void chanserv (User *u, char *buf);
E void load_cs_dbase ();
E void save_cs_dbase ();
E void expire_chans ();
E void restore_channel (Channel *c);
E void check_modes (const char *chan);
E void set_topic (ChanInfo *ci, const char *topic, const char *setter);
E int get_access (User *u, ChanInfo *ci);
E int is_akicked (User *u, ChanInfo *ci);
E int cs_join (User *u, const char *c, int fromburst);

/* memoserv.c */
E void memoserv (User *u, char *buf);
E void check_memos (User *u);
E void check_news (User *u);
E void send_memo (NickInfo *ni, const char *from, const char *text);

/* help.c */
E void nickserv_help_index (User *u);
E void nickserv_help_register (User *u);
E void nickserv_help_drop (User *u);
E void nickserv_help_identify (User *u);
E void nickserv_help_set (User *u);
E void nickserv_help_set_pass (User *u);
E void nickserv_help_set_email (User *u);
E void nickserv_help_set_url (User *u);
E void nickserv_help_set_uin (User *u);
E void nickserv_help_set_name (User *u);
E void nickserv_help_set_age (User *u);
E void nickserv_help_set_sex (User *u);
E void nickserv_help_set_location (User *u);
E void nickserv_help_set_neverop (User *u);
E void nickserv_help_set_noop (User *u);
E void nickserv_help_set_nosuccessor (User *u);
E void nickserv_help_set_hidemail (User *u);
E void nickserv_help_set_showmail (User *u);
E void nickserv_help_set_privmsg (User *u);
E void nickserv_help_set_notice (User *u);
E void nickserv_help_set_private (User *u);
E void nickserv_help_set_zone (User *u);
E void nickserv_help_set_enforce (User *u);
E void nickserv_help_set_secure (User *u);
E void nickserv_help_access (User *u);
E void nickserv_help_recover (User *u);
E void nickserv_help_link (User *u);
E void nickserv_help_unlink (User *u);
E void nickserv_help_links (User *u);
E void nickserv_help_chans (User *u);
E void nickserv_help_status (User *u);
E void nickserv_help_info (User *u);
E void nickserv_help_getpass (User *u);
E void nickserv_help_setpass (User *u);
E void nickserv_help_sendpass (User *u);
E void nickserv_help_freeze (User *u);
E void nickserv_help_unfreeze (User *u);
E void chanserv_help_index (User *u);
E void chanserv_help_register (User *u);
E void chanserv_help_drop (User *u);
E void chanserv_help_identify (User *u);
E void chanserv_help_info (User *u);
E void chanserv_help_list (User *u);
E void chanserv_help_set (User *u);
E void chanserv_help_set_mlock (User *u);
E void chanserv_help_set_founder (User *u);
E void chanserv_help_set_successor (User *u);
E void chanserv_help_set_pass (User *u);
E void chanserv_help_set_url (User *u);
E void chanserv_help_set_greet (User *u);
E void chanserv_help_set_topic (User *u);
E void chanserv_help_set_topiclock (User *u);
E void chanserv_help_set_memolevel (User *u);
E void chanserv_help_set_verbose (User *u);
E void chanserv_help_set_limited (User *u);
E void chanserv_help_set_vopall (User *u);
E void chanserv_help_set_secure (User *u);
E void chanserv_help_set_restricted (User *u);
E void chanserv_help_count (User *u);
E void chanserv_help_status (User *u);
E void chanserv_help_bans (User *u);
E void chanserv_help_unban (User *u);
E void chanserv_help_invite (User *u);
E void chanserv_help_kick (User *u);
E void chanserv_help_clear (User *u);
E void chanserv_help_send (User *u);
E void chanserv_help_vop (User *u);
E void chanserv_help_hop (User *u);
E void chanserv_help_aop (User *u);
E void chanserv_help_sop (User *u);
E void chanserv_help_op (User *u);
E void chanserv_help_deop (User *u);
E void chanserv_help_halfop (User *u);
E void chanserv_help_dehalfop (User *u);
E void chanserv_help_voice (User *u);
E void chanserv_help_devoice (User *u);
E void chanserv_help_akick (User *u);
E void chanserv_help_freeze (User *u);
E void chanserv_help_unfreeze (User *u);
E void chanserv_help_getpass (User *u);
E void chanserv_help_setpass (User *u);
E void chanserv_help_sendpass (User *u);
E void chanserv_help_auth (User *u);
E void memoserv_help_index (User *u);
E void memoserv_help_send (User *u);
E void memoserv_help_read (User *u);
E void memoserv_help_del (User *u);
E void memoserv_help_list (User *u);
E void memoserv_help_recall (User *u);
E void memoserv_help_set (User *u);
E void memoserv_help_set_receipts (User *u);
E void memoserv_help_set_memobox (User *u);
E void memoserv_help_set_nomemo (User *u);
E void memoserv_help_set_memomail (User *u);
E void memoserv_help_set_forward (User *u);
E void memoserv_help_news (User *u);
E void rootserv_help_index (User *u);
E void rootserv_help_auth (User *u);
E void rootserv_help_deauth (User *u);
E void rootserv_help_akill (User *u);
E void rootserv_help_jupe (User *u);
E void rootserv_help_settings (User *u);
E void rootserv_help_csop (User *u);
E void rootserv_help_global (User *u);
E void rootserv_help_clones (User *u);
E void rootserv_help_trigger (User *u);
E void rootserv_help_exception (User *u);
E void rootserv_help_stats (User *u);
E void rootserv_help_search (User *u);
E void rootserv_help_listnicks (User *u);
E void rootserv_help_listchans (User *u);
E void rootserv_help_shutdown (User *u);
E void rootserv_help_hold (User *u);
E void rootserv_help_mark (User *u);
E void rootserv_help_restart (User *u);
E void rootserv_help_debug (User *u);
E void rootserv_help_rehash (User *u);
E void rootserv_help_update (User *u);
#ifdef RAWINJECT
E void rootserv_help_raw (User *u);
E void rootserv_help_inject (User *u);
#endif
E void rootserv_help_resetnews (User *u);
E void rootserv_help_cyclelogs (User *u);
