<?
/* Cygnus Web Integration - web.php

   Cygnus IRC Services - Copyright (c) 2001-2002 Darcy Grexton
   Contact: skold@habber.net, skold @ HabberNet

   Web Integration scripts by Ray Beliveau

   See doc/LICENSE for licensing details.
 */

/*
  The location in the function LogLocate() should point to the location of where you want the log to be written.
  The user running the httpd (usually nobody) needs permissions to the directory where this file is.

  The location in the function DBLocate() should point to the location of where services places the database file.
  The user running the httpd (usually nobody) needs permissions to the directory where this file is.

  The location in the function AccessLocate() should point to the location of where you want the failed logins to be written.
  The user running the httpd (usually nobody) needs permissions to the directory where this file is.
  If AccessLocate() is 0, then the web access log will be set to disabled.

  For security purposes, it would be a good idea not to have these files in a publicly accessible folder (i.e. your
  web folder).
 */
  function LogLocate() {
    return "/home/user/services/web.log";
  }
  function DBLocate() {
    return "/home/user/services/web.db";
  }
  function AccessLocate() {
    return "/home/user/services/webaccess.log";
  }

/*
  If the number in CryptPass() is a 1 or true, passwords are crypted, and will be when used to compare passwords.
  If the number in CryptPass() is a 0 or false, passwords are not crypted, and will not be when used to compare passwords.
 */
  function CryptPass() {
    return true;
  }
/*
  The following will disable/enable any options in the menu that you want it to.
  If the return value is 1 or true, then it is enabled
  If it is 0 or false, it is disabled.

  NickServ
 */
  function EnableNickReg() {
    return false;
  }
  function EnableNickDrop() {
    return false;
  }
/*
  ChanServ
 */
  function EnableChanReg() {
    return false;
  }
  function EnableChanDrop() {
    return false;
  }
  function EnableChanAccessList() {
    return true;
  }
  function EnableChanAccessDelete() {
    return true;
  }
/*
  MemoServ
 */
  function EnableMemoList() {
    return true;
  }
  function EnableMemoRead() {
    return true;
  }
  function EnableMemoSend() {
    return true;
  }
  function EnableMemoDelete() {
    return true;
  }
/*
  Don't edit this part.
 */
  function EnableMemoCheck() {
    if (EnableMemoList() || EnableMemoRead() || EnableMemoSend()) return true;
    else return false;
  }

 @session_start();
 @session_register("nick","password","channel","cpassword","saveinfo");

?>
<html>
 <head>
  <title>Cygnus Web Interface</title>
 </head>

 <?

/*
 The following is pretty much self-explanitory.
 This will help you format the text on the page.
 .rtexts is the layout used when there is an error.
 .buttons is the layout used for the smaller buttons.
 .buttons2 is the layout used for the larger buttons.
 .desctext is the layout used for the descriptive text, under the title of the page.
 .texts is the layout used for the rest of the text on the page, not mentioned.
*/

 ?>
 <style type="text/css">
  A         { text-decoration: none; color: white; }
  .texts    { font-family: Verdana; font-size: 9pt; }
  .rtexts   { font-family: Verdana; font-size: 9pt; color: white; font-weight: bold; }
  .buttons  { font-family: Verdana; font-size: 8pt; width: 85px; height: 25px; }
  .buttons2 { font-family: Verdana; font-size: 8pt; width: 105px; height: 25px; }
  .desctext { font-family: Verdana; font-size: 9pt; }
 </style>
 <body bgcolor="#637CA4" text="white">

 <?
/*
  It is not advisable to edit below this point unless you have some knowledge of what you are doing.

  Miscellaneous Functions
 */
  $host = gethostbyaddr($HTTP_SERVER_VARS['REMOTE_ADDR']);

  function TimeSince ($timer) {
    $timer = time() - $timer;
    while ($timer >= 31536000) {
      $yrs++;
      $timer -= 31536000;
    }
    while ($timer >= 604800) {
      $wks++;
      $timer -= 604800;
    }
    while ($timer >= 86400) {
      $days++;
      $timer -= 86400;
    }
    while ($timer >= 3600) {
      $hrs++;
      $timer -= 3600;
    }
    while ($timer >= 60) {
      $mins++;
      $timer -= 60;
    }
    if ($yrs) $timed .= "$yrs year" . $ttmp = ($yrs>1) ? "s " : " ";
    if ($wks) $timed .= "$wks week" . $ttmp = ($wks>1) ? "s " : " ";
    if ($days) $timed .= "$days day" . $ttmp = ($days>1) ? "s " : " ";
    if ($hrs) $timed .= "$hrs hour" . $ttmp = ($hrs>1) ? "s " : " ";
    if ($mins) $timed .= "$mins minute" . $ttmp = ($mins>1) ? "s " : " ";
    if ($timer) $timed .= "$timer second" . $ttmp = ($timer>1) ? "s " : " ";
    return $timed .= "ago";
  }
  function WriteLog ($logentry) {
    fwrite($logfile = fopen(LogLocate(),"a"), $logentry .= "\n", strlen($logentry));
    fclose($logfile);
  }
  function WriteALog ($type,$name,$host) {
    if (AccessLocate()) {
      $timer = "[" . date("d//m H:i:s") . "] $type" . ":BP: $name $host\n";
      fwrite($logfile = fopen(AccessLocate(),"a"), $timer, strlen($timer));
      fclose($logfile);
    }
  }
  function ScanDB ($lineh,$name) {
    $dbfile = fopen(DBLocate(),"r");
    while ($scanstr = fscanf($dbfile, "%s\x20%s\x20%s\x20%s\x20%s\x20%s\x20%s\n")) {
      if (strtoupper($lineh . $name) == strtoupper($scanstr[0] . $scanstr[1])) {
        array_shift($scanstr);
        array_shift($scanstr);
        if (!$retarray) $retarray[0] = implode(" ",$scanstr);
        else array_push($retarray, implode(" ",$scanstr));
      }
    }
    fclose($dbfile);
    return $retarray;
  }
  function ScanLog ($lineh,$name) {
    if ($logfile = @fopen(LogLocate(),"r")) {
      while ($scanstr = fscanf($logfile, "%s\x20%s\x20%s\n")) {
        if (strtoupper($lineh . $name) == strtoupper($scanstr[0] . $scanstr[1])) {
          array_shift($scanstr);
          array_shift($scanstr);
          if (!$retarray) $retarray[0] = $scanstr[0];
          else array_push($retarray, $scanstr[0]);
        }
      }
      fclose($logfile);
    }
    return $retarray;
  }
  function EmailCheck ($email) {
    if (strlen($email) < 6) return false;
    if (!strchr($email,"@") || !strchr($email,".")) return false;
    if (strchr($email, "$") || strchr($email, "/") || strchr($email, ";") || strchr($email, "<") || strchr($email, ">") || strchr($email, "&")) return false;
    else return true;
  }
  function PassCheck ($name,$passwd) {
    if ($passwd == "password") return false;
    elseif ($passwd == $name) return false;
    elseif (strlen($passwd) < 5) return false;
    else return true;
  }
  function LogStatus ($lineh,$name,$entry) {
    if ($scanstr = ScanLog($lineh,$name)) {
      for($i=0; $i<sizeof($scanstr); $i++) {
        if (!$entry) $scanfound = true;
        elseif ($scanstr[$i] == $entry) $scanfound = true;
      }
    }
    return $scanfound;
  }
  function LoginCheck ($lname,$pass) {
    if (!$lname || !$pass) return false;
    if ($user = ScanDB("NI",$lname)) {
      $realpass = explode(" ",$user[0]);
      $realpass = $realpass[0];
      if (CryptPass()) {
        $pass = crypt($pass,substr($realpass,0,2));
      }
      if ($pass === $realpass) return true;
      else return false;
    }
    else return false;
  }
  function ParsePass ($passwd) {
    return stripslashes($passwd);
  }
  function CLoginCheck ($cname,$pass,$lname) {
    if (!$cname || !$pass || !$lname) return false;
    if ($chan = ScanDB("CI",$cname)) {
      $realpass = explode(" ",$chan[0]);
      $chans = $realpass[0];
      $realpass = $realpass[1];
      if (CryptPass()) {
        $pass = crypt($pass,substr($realpass,0,2));
      }
      if ($pass == $realpass && $chans == $lname) return true;
      else return false;
    }
    else return false;
  }
  function Logout() {
    session_unregister("nick");
    session_unregister("password");
    LogoutChan();
  }
  function LogoutChan() {
    session_unregister("channel");
    session_unregister("cpassword");
  }

/*
  MemoServ Functions
 */
  function CheckMemos ($nick) {
   $memos = ScanDB("MO",$nick);
     for ($i=0; $i<sizeof($memos); $i++) {
      $memos[$i] = explode(" ",$memos[$i]);
      if (!LogStatus("MD",$nick,$memos[$i][1])) {
         if (LogStatus("MR",$nick,$memos[$i][1])) $memos[$i][0] = "READ";
         if (!$memos2) $memos2[0] = $memos[$i];
         else array_push($memos2, $memos[$i]);
      }
    }
    return $memos2;
  }
  function ReadMemos ($nick,$ts) {
    $dbfile = fopen(DBLocate(),"r");
    $dbdata = fread($dbfile, filesize(DBLocate()));
    $dbdata = explode("\n",$dbdata);
    for($i=0; $i<sizeof($dbdata); $i++) {
      $temp = explode(" ",$dbdata[$i]);
      $tmp = "$temp[0] " . strtoupper($temp[1]) . " $temp[3]";
      if ($tmp == "MO " . strtoupper($nick) . " $ts") {
        array_shift($temp);
        array_shift($temp);
        array_shift($temp);
        array_shift($temp);
        array_shift($temp);
        $blah = implode(" ",$temp);
        break;
      }
    }
    fclose($dbfile);
    return $blah;
  }
  function SendMemo ($nick,$memoto,$memotext) {
    WriteLog("MS $memoto $nick $memotext");
  }
  function ReadMemo ($nick,$ts) {
    if (!LogStatus("MR",$nick,$ts)) WriteLog("MR $nick $ts");
  }
  function DeleteMemo ($nick,$ts) {
    WriteLog("MD $nick $ts");
  }

/*
  ChanServ Functions
 */
  function CheckChan ($name) {
    if (substr($name,0,1) != "#") return false;
    if (strchr($email, ",") || strchr($email, " ")) return false;
    else return true;
  }
  function ScanChan ($name) {
    $dbfile = fopen(DBLocate(),"r");
    while ($scanstr = fscanf($dbfile, "%s\x20%s\x20%s\x20%s\n")) {
      if ($scanstr[0] == "CA" && strtoupper($scanstr[2]) == strtoupper($name)) {
        $scanstr[2] = $scanstr[1];
        array_shift($scanstr);
        array_shift($scanstr);
        switch ($scanstr[1]) {
          case "0":
            $scanstr[1] = "AutoKicked";
            break;
          case "1":
            $scanstr[1] = "VOP";
            break;
          case "2":
            $scanstr[1] = "HOP";
            break;
          case "3":
            $scanstr[1] = "AOP";
            break;
          case "4":
            $scanstr[1] = "SOP";
            break;
          case "5":
            $scanstr[1] = "Founder";
            break;
        }
        if (!LogStatus("AD",$scanstr[0],$name)) {
          if (!$retarray) $retarray[0] = $scanstr;
          else array_push($retarray, $scanstr);
        }
      }
    }
    fclose($dbfile);
    return $retarray;
  }
  function AccessDelete ($name, $chan) {
    WriteLog("AD $chan $name");
  }
  function RegisterChannel ($chan,$name,$cpass) {
    WriteLog("CR $chan $name $cpass");
  }
  function DropChannel ($name) {
    WriteLog("CD $name");
  }

/*
  NickServ Functions
 */
  function RegisterNick ($name,$host,$npass,$email) {
    WriteLog("NR $name $host $npass $email");
  }
  function DropNick ($name) {
    WriteLog("ND $name");
  }

/*
  Menus
 */
 ?>
 <table width="100%">
  <tr>
   <td align="left" valign="top" width="175">
    <font class="texts">
     <?
      if (EnableNickReg() || EnableNickDrop()) $nschk = 1;
      else unset($nschk);
      if ($nschk) echo("<b>NickServ</b><br>");
      if (EnableNickReg()) echo("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href=\"web.php?f=nickserv&p=regnick\">Register a nickname</a><br>");
      if (EnableNickDrop()) echo("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href=\"web.php?f=nickserv&p=dropnick\">Drop a nickname</a><br>");
      echo("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href=\"web.php?f=nickserv&p=login&s=logout\">Logout nickname</a><br>");
      if ($nschk) echo("<br>");
      echo("<b>ChanServ</b><br>");
      echo("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href=\"web.php?f=chanserv&p=clogin\">Login</a><br>");
      if (EnableChanReg()) echo("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href=\"web.php?f=chanserv&p=regchan\">Register a channel</a><br>");
      if (EnableChanDrop()) echo("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href=\"web.php?f=chanserv&p=dropchan\">Drop a channel</a><br>");
      if (EnableChanAccessList()) echo("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href=\"web.php?f=chanserv&p=caccess\">Check channel access</a><br>");
      echo("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href=\"web.php?f=chanserv&p=clogin&s=clogout\">Logout channel</a><br>");
      echo("<br>");
      if (EnableMemoCheck()) echo("<b>MemoServ</b><br>");
      if (EnableMemoList()) echo("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href=\"web.php?f=memoserv&p=memolist&s=list\">List memos</a><br>");
      if (EnableMemoRead()) echo("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href=\"web.php?f=memoserv&p=memolist&s=read\">Read a memo</a><br>");
      if (EnableMemoSend()) echo("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href=\"web.php?f=memoserv&p=memosend\">Send a memo</a><br>");
     ?>
    </font>
   </td>
   <td align="justify" valign="top" width="600">
 <?
/*
  Main Code

  The following code is what the main page reads from every time the page loads.
 */

  if (!$p) $p = "login";
  if (!$f) $f = "nickserv";
  if (!LoginCheck($nick,$password)) {
    switch ($p) {
      case "login":
      case "regnick":
      case "dropnick":
         break;
      default:
         $p = "login";
         $f = "nickserv";
         $notlogged = 1;
         break;
    }
  }
  if (!CLoginCheck($channel,$cpassword,$nick) && $f == "chanserv") {
    switch ($p) {
      case "clogin":
      case "regchan":
      case "caccess":
      case "dropchan":
         break;
      default:
         $p = "clogin";
         $cnotlogged = 1;
         break;
    }
  }

/*
  MemoServ Pages
 */
  if ($f == "memoserv") {

/*
  Memo Listing
 */
    if ($p == "memolist" && EnableMemoList()) {
      if ($delete && $del) DeleteMemo($nick,$del);
      if ($delete && $memolist && !$del) {
        $rmemos = CheckMemos($nick);
        for($i=0; $i<sizeof($memolist); $i++) {
          DeleteMemo($nick,$rmemos[$memolist[$i]][1]);
        }
      }
      if ((!$read || !$memolist) && !$reply) {
        $memos = CheckMemos($nick);
        for ($i=0; $i<sizeof($memos); $i++) {
        if ($memos[$i][0] == "UNREAD") $new++;
      }
      $new = ($new) ? $new : "0";
      $nmemo = ($memos) ? sizeof($memos) : "0";
  ?>
  <form name="regnick" method="post" action="web.php">
   <input type="hidden" name="p" value="memolist">
   <input type="hidden" name="f" value="memoserv">
   <input type="hidden" name="s" value="<? echo $S ?>">
   <table width="100%">
    <tr>
     <td align="left" colspan="4">
      <font class="texts">
       <b><? echo($s == "read") ? "Read a memo" : "List memos"; ?></b>
      </font>
     </td>
    </tr>
    <tr>
     <td align="justify" colspan="4" width="100%">
      <?
       if ($delete && !$memolist && !$del) {
      ?>
       <font class="rtexts">
        To delete, you must select memos.
       </font><br>
      <?
       }
       elseif ($read && !$memolist) {
      ?>
       <font class="rtexts">
        To read, you must select memos.
       </font><br>
      <?
       }
      ?>
      <font class="desctext">
      <?
        if ($delete && ($memolist || $del)) {
          if ($del) $mdele = 1;
          else {
            for($i=0; $i<sizeof($memolist); $i++) {
              $mdele++;
            }
          }
          echo $mdele;
        ?>
        memo<? echo($mdele>1 || $mdele == 0) ? "s " : " "; ?>erased.<br>
        <? } ?>
       You have <? echo $nmemo ?> memo<? echo($nmemo>1 || $nmemo == 0) ? "s," : ","; ?> <? echo $new ?> <? echo($new>1 || $new == 0) ? "are" : "is"; ?> new.
      </font>
     </td>
    </tr>
    <?
      if ($nmemo != "0") {
    ?>
    <tr>
     <td height="5">
     </td>
    </tr>
    <tr>
     <td align="justify" width="1">
     </td>
     <td align="justify" width="20">
      <font class="texts">
       <b>Status</b>
      </font> 
     </td>
     <td align="justify" width="30">
      <font class="texts">
       <b>From</b>
      </font> 
     </td>
     <td align="justify">
      <font class="texts">
       <b>Sent</b>
     </font> 
    </td>
   </tr>
   <?
     for ($i=0; $i<sizeof($memos); $i++) {
       echo("<tr>\n  <td align=\"justify\" width=\"1\">\n");
       if (EnableMemoDelete() || EnableMemoRead()) echo("<input type=\"checkbox\" name=\"memolist[]\" value=\"" . $i . "\">\n");
       echo("</td>\n");
       echo("  <td align=\"justify\" width=\"20\">\n<font class=\"texts\">" . ucfirst(strtolower($memos[$i][0])) . "</font>\n  </td>\n");
       echo("  <td align=\"justify\" width=\"30\">\n<font class=\"texts\">" . $memos[$i][2] . "</font>\n  </td>\n");
       $timed = TimeSince($memos[$i][1]);
       echo("  <td align=\"justify\">\n<font class=\"texts\">" . $timed . "</font>\n  </td>\n</tr>");
     }
   ?>
   <tr>
    <td align="justify" height="15" colspan="4">
    </td>
   </tr>
   <tr>
    <td align="justify" colspan="4">
     <?
      if (EnableMemoRead()) echo("<input type=\"submit\" value=\"Read selected\" name=\"read\" class=\"buttons2\">");
      if (EnableMemoDelete()) echo("<input type=\"submit\" value=\"Delete selected\" name=\"delete\" class=\"buttons2\">");
     ?>
    </td>
   </tr>
   <?
     }
   ?>
   </table>
  </form>
  <?
   }
   elseif ($read) {
  ?>
  <table width="100%">
   <tr>
    <td align="left" colspan="2">
     <font class="texts">
      <b>Read a memo</b>
     </font>
    </td>
   </tr>
   <?
    $rmemo = CheckMemos($nick);
    for($i=0; $i<sizeof($memolist); $i++) {
   ?>
   <form name="regnick" method="post" action="web.php">
    <input type="hidden" name="p" value="memolist">
    <input type="hidden" name="f" value="memoserv">
    <input type="hidden" name="del" value="<? echo $rmemo[$memolist[$i]][1] ?>">
    <tr>
     <td align="justify" width="17%">
      <font class="texts">
       <b>To:</b>
      </font> 
     </td>
     <td align="justify" width="83%">
      <font class="texts">
       <? echo $nick ?>
      </font>
     </td>
    </tr>
    <tr>
     <td align="justify" width="17%">
      <font class="texts">
       <b>From:</b>
      </font> 
     </td>
     <td align="justify" width="83%">
      <font class="texts">
       <? echo $rmemo[$memolist[$i]][2] ?>
      </font>
     </td>
    </tr>
    <tr>
     <td align="justify" width="17%">
      <font class="texts">
       <b>Sent:</b>
      </font> 
     </td>
     <td align="justify" width="83%">
      <font class="texts">
       <? echo TimeSince($rmemo[$memolist[$i]][1]) ?>
      </font>
     </td>
    </tr>
    <tr>
     <td align="justify" width="17%">
      <font class="texts">
       <b>Memo:</b>
      </font> 
     </td>
     <td align="justify" width="83%">
      <font class="texts">
       <? echo ReadMemos($nick, $rmemo[$memolist[$i]][1]) ?>
      </font>
     </td>
    </tr>
    <tr>
     <td align="justify" colspan="2" height="10">
     </td>
    </tr>
    <tr>
     <td align="justify" colspan="2">
      <input type="hidden" name="nmemoto" value="<? echo $rmemo[$memolist[$i]][2] ?>">
      <input type="submit" value="Send a reply" name="reply" class="buttons">
      <input type="submit" value="Delete memo" name="delete" class="buttons">
     </td>
    </tr>
    <tr>
     <td align="justify" colspan="2" height="20">
     </td>
    </tr>
   </form>
   <?
      ReadMemo($nick,$rmemo[$memolist[$i]][1]);
    }
   ?>
   </table>
   <?
   }
   elseif ($reply) {
     $l = "memosend";
     $p = "memosend";
   }
 }

/*
  Memo Sending
 */
 if ($p == "memosend"  && EnableMemoSend()) {
   if ((!$nmemoto && (!ScanDB("NI",$memoto) || !$memoto)) || !$memotext || strlen($memotext) > 256) {
 ?>
 <form name="regnick" method="post" action="web.php">
  <input type="hidden" name="l" value="msent">
  <input type="hidden" name="f" value="memoserv">
  <input type="hidden" name="p" value="memosend">
  <table width="100%">
   <tr>
    <td align="left" colspan="2">
     <font class="texts">
      <b>Send a memo</b>
     </font>
    </td>
   </tr>
   <tr>
    <td align="justify" colspan="2" width="100%">
     <? if ($l == "msent") { ?>
      <font class="rtexts">
       Errors Found:<br>
       <?
        if (!$memoto && !$nmemoto) echo("Recipient field left blank.<br>");
        elseif (!ScanDB("NI",$memoto) && !$nmemoto) echo("Recipient doesn't exist.<br>");
        if (!$memotext) echo("Memo field left blank.<br>");
        elseif (strlen($memotext) > 256 ) echo("Memo too long.");
       ?>
      </font><br>
     <? } ?>
     <font class="desctext">
      Enter your memo below. You can enter up to 256 characters in your memo.
     </font>
    </td>
   </tr>
   <tr>
    <td height="5">
    </td>
   </tr>
   <tr>
    <td align="justify" width="17%">
     <?
      if ($l == "msent" && !$memoto && !$nmemoto) {
        echo("<font class=\"rtexts\">");
      }
      elseif ($l == "msent" && !ScanDB("NI",$memoto) && !$nmemoto) {
        echo("<font class=\"rtexts\">");
        unset($memoto);
      }
      else {
        echo("<font class=\"texts\">");
      }
    ?>
    <b>To:</b>
   </font> 
  </td>
  <td align="justify" width="83%">
   <font class="texts">
    <?
     if ($nmemoto) {
       $memoto = $nmemoto;
    ?>
      <input type="hidden" name="nmemoto" value="<? echo $nmemoto ?>">
      <input type="hidden" name="memoto" value="<? echo $nmemoto ?>">
    <?
       echo $nmemoto;
     }
       else {
     ?>
         <input type="text" name="memoto" value="<? echo $memoto ?>" size="32" MAXLENGTH="32">
     <?
       }
     ?>
    </font>
   </td>
  </tr>
  <tr>
   <td align="justify" width="17%" valign="top">
    <?
     if ((!$memotext || strlen($memotext) > 256) && $l == "msent") {
       echo("<font class=\"rtexts\"");
     }
     else {
       echo("<font class=\"texts\">");
     }
    ?>
     <b>Memo text:</b>
    </font> 
    </td>
    <td align="justify" width="83%" rowspan="2">
     <font face="verdana" size="2">
      <TEXTAREA name="memotext" cols="45" rows="8" wrap="on"><? echo $memotext ?></TEXTAREA>
     </font>
    </td>
   </tr>
   <tr>
    <td align="justify" width="100%" colspan="2" valign="bottom">
     <input type="submit" value="Send memo" class="buttons"><br><br>
     <input type="reset" value="Reset memo" class="buttons">
    </td>
   </tr>
  </table>
 </form>
 <?
  }
  elseif ($l == "msent") {
    SendMemo($nick,$memoto,$memotext);
 ?>
 <table width="100%">
  <tr>
   <td align="left" colspan="2">
    <font class="texts">
     <b>Send a memo</b>
    </font>
   </td>
  </tr>
  <tr>
   <td align="justify" colspan="2" width="100%">
    <font class="texts">
     Memo sent successfully.
    </font>
   </td>
  </tr>
  <tr>
   <td align="justify" width="17%">
    <font class="texts">
     <b>From:</b>
    </font> 
   </td>
   <td align="justify" width="83%">
    <font class="texts">
     <? echo $nick ?>
    </font>
   </td>
  </tr>
  <tr>
   <td align="justify" width="17%">
    <font class="texts">
     <b>To:</b>
    </font> 
   </td>
   <td align="justify" width="83%">
    <font class="texts">
     <? echo $memoto ?>
    </font>
   </td>
  </tr>
  <tr>
   <td align="justify" width="17%">
    <font class="texts">
     <b>Memo:</b>
    </font> 
   </td>
   <td align="justify" width="83%">
    <font class="texts">
     <? echo $memotext ?>
    </font>
   </td>
  </tr>
 </table>
 <?
  }
 }
}

/*
  ChanServ Pages
 */
 if ($f == "chanserv") {

/*
  Channel Access Listing
 */
   if ($p == "caccess" && EnableChanAccessList()) {
   $access = ScanChan($nick);
   if ($accesslist) {
     for($i=0; $i<sizeof($accesslist); $i++) {
       AccessDelete($nick,$access[$accesslist[$i]][0]);
       unset($l);
     }
   }
   $access = ScanChan($nick);
   if ($l != "chanaccess" || !$accesslist) {
  ?>
  <form name="login" method="post" action="web.php">
   <input type="hidden" name="l" value="chanaccess">
   <input type="hidden" name="f" value="chanserv">
   <input type="hidden" name="p" value="caccess">
   <table width="600">
    <tr>
     <td align="left" colspan="3">
      <font class="texts">
       <b>Check channel access</b>
      </font>
      <? if ($l == "chanaccess") { ?>
      <font class="rtexts">
      <?
       if (!$accesslist) echo("<br><b>To delete, you must select a channel.</b><br>");
       if (!$access) echo("<br><b>You don't have access to any channels.</b><br>");
     }
    ?>
   </td>
  </tr>
  <? if ($access) { ?>
  <tr>
   <td align="justify" colspan="3">
    <font class="desctext"><p align="justify">
     Below is a list of the channels you have access on, and what access you have. If you don't want the access on the channel, click the checkbox beside it. Once you have selected all channels you want to remove access from, click Delete access. You cannot remove AutoKick or Founder access.
    </p></font>
   </td>
  </tr>
  <tr>
   <td height="5">
   </td>
  </tr>
  <tr>
   <td align="justify" width="25">
   </td>
   <td align="justify">
    <font class="texts">
     <b>Channel</b>
    </font> 
   </td>
   <td align="justify" width="100">
    <font class="texts">
     <b>Access</b>
    </font> 
   </td>
  </tr>
  <?
   for ($i=0; $i<sizeof($access); $i++) {
     echo("<tr>\n  <td align=\"justify\" width=\"1\">\n");
     if (($access[$i][1] != "AutoKicked" && $access[$i][1] != "Founder") && EnableChanAccessDelete()) echo("<input type=\"checkbox\" name=\"accesslist[]\" value=\"" . $i . "\">\n");
     echo("  </td>\n");
     echo("  <td align=\"justify\">\n<font class=\"texts\">" . $access[$i][0] . "</font>\n  </td>\n");
     echo("  <td align=\"justify\">\n<font class=\"texts\">" . $access[$i][1] . "</font>\n  </td>\n</tr>");
   }
  ?>
   <tr>
    <td align="justify" height="15" colspan="4">
    </td>
   </tr>
   <tr>
    <td align="justify" width="100%" colspan="3" valign="bottom">
     <?
      if (EnableChanAccessDelete()) echo("<input type=\"submit\" value=\"Delete access\" class=\"buttons2\"><br><br>");
     ?>
    </td>
   </tr>
  <? } ?>
  </table>
 </form>
 <?
  }
 }

/*
  Drop Channel
 */
 elseif ($p == "dropchan" && EnableChanDrop()) {
   if ($dchan  && $passwd) {
     $realpass = ScanDB("CI",$dchan);
     $realpass = explode(" ",$realpass[0]);
     $chana = $realpass[0];
     $realpass = $realpass[1];
     if (CryptPass() && $passwd) {
        $passwd = crypt($passwd,substr($realpass,0,2));
      }
   }
   if (!$passwd || !$dchan || !ScanDB("CI",$dchan) || !CLoginCheck($dchan,$passwd,$nick) || $l != "cdropped") {
 ?>
 <form name="dropnick" method="post" action="web.php">
  <input type="hidden" name="l" value="cdropped">
  <input type="hidden" name="f" value="chanserv">
  <input type="hidden" name="p" value="dropchan">
  <table width="100%">
   <tr>
    <td align="left" colspan="2">
     <font class="texts">
      <b>Drop a channel</b>
     </font>
    </td>
   </tr>
   <tr>
    <td align="justify" colspan="2" width="100%">
    <? if ($l == "cdropped") { ?>
     <font class="rtexts">
    <?
       if (!$dchan) echo("No channel entered.<br>");
       elseif (!ScanDB("CI",$dchan)) {
         echo("$dchan is not registered.");
         $areg = 1;
         unset($dchan);
       }
       if (!$areg) {
         if (!$passwd) echo("No password entered.<br>");
         elseif ($chana != $nick) echo("You're not founder.<br>");
         elseif (!CLoginCheck($cname,$passwd,$nick)) {
           unset($passwd);
           echo("Password incorrect.<br>");
         }
       }
    ?>
     </font><br>
    <? } ?>
     <font class="desctext"><p align="justify">
      Please enter the name of the channel you want to drop and the password for it and click Drop channel. Once this is done, it cannot be undone! All access lists, AutoKicks, and settings for your channel will be lost, and anyone will be able to register your channel for themselves.
     </p></font>
    </td>
   </tr>
   <tr>
    <td height="5">
    </td>
   </tr>
   <tr>
    <td align="justify" width="17%">
     <font class="texts">
      <b>Channel:</b>
     </font> 
    </td>
    <td align="justify" width="83%">
     <input type="text" name="dchan" value="" size="32" MAXLENGTH="32">
    </td>
   </tr>
   <tr>
    <td align="justify" width="17%">
     <font class="texts">
      <b>Password:</b>
     </font> 
    </td>
    <td align="justify" width="83%">
     <input type="password" name="passwd" value="" size="32" MAXLENGTH="32">
    </td>
   </tr>
   <tr>
    <td align="justify" width="100%" colspan="2" valign="bottom">
     <input type="submit" value="Drop channel" class="buttons2"><br><br>
    </td>
   </tr>
   </table>
  </form>
 <?
  }
  else {
    DropChannel($chan);
    $droppedc = 1;
    if ($chan == $channel) {
      LogoutChan();
      $p = "clogin";
      $l = "chanserv";
    }
    else echo("<font class=\"texts\">\n <b>Channel has been successfully dropped.</b>\n</font>");
  }
 }

/*
  Channel Registration
 */
 elseif ($p == "regchan" && EnableChanReg()) {
   if ($passwd) $passwd = ParsePass($passwd);
   if ($l != "cregister" || ScanDB("CI",$name) || !$name || !$passwd || !PassCheck($name,$passwd) || !CheckChan($name)) {
 ?>
  <form name="dropnick" method="post" action="web.php">
   <input type="hidden" name="l" value="cregister">
   <input type="hidden" name="f" value="chanserv">
   <input type="hidden" name="p" value="regchan">
   <table width="100%">
   <tr>
    <td align="left" colspan="2">
     <font class="texts">
      <b>Register a channel</b>
     </font>
    </td>
   </tr>
   <tr>
    <td align="justify" colspan="2" width="100%">
    <? if ($l == "cregister") { ?>
     <font class="rtexts">
      <?
       if (!$name) echo("<b>No channel entered.</b><br>");
       elseif (ScanDB("CI",$name)) {
         echo("<b>Channel is already registered.</b><br>");
         $areg = 1;
         unset($name);
       }
       elseif (!CheckChan($name)) {
         echo("<b>Invalid channel name.</b><br>");
         $areg = 1;
         unset($name);
       }
       if (!$areg) {
         if (!$passwd) echo("<b>No password entered.</b><br>");
         elseif (strlen($passwd)<5) echo("<b>Password is too short.</b><br>");
       }
      ?>
     </font><br>
    <? } ?>
     <font class="desctext"><p align="justify">
      Please fill out the form below. After you press the Register button, your channel registration will be queued for processing. Registration of your channel may take several minutes, so please be patient.
     </p></font>
    </td>
   </tr>
   <tr>
    <td height="5">
    </td>
   </tr>
   <tr>
    <td align="justify" width="27%">
     <font class="texts">
      <b>Desired channel:</b>
     </font> 
    </td>
    <td align="justify" width="73%">
     <input type="text" name="name" value="<? echo $name ?>" size="32" MAXLENGTH="32">
    </td>
   </tr>
   <tr>
    <td align="justify" width="27%">
     <font class="texts">
      <b>Password:</b>
     </font> 
    </td>
    <td align="justify" width="73%">
     <input type="password" name="passwd" value="" size="32" MAXLENGTH="32">
    </td>
   </tr>
   <tr>
    <td align="justify" width="100%" colspan="2" valign="bottom">
     <input type="submit" value="Register!" class="buttons">
    </td>
   </tr>
  </table>
 </form>
 <?
  }
  else {
    RegisterChannel($name,$nick,$passwd);
    $cregd = 1;
    $p = "clogin";
    $l = "chanserv";
  }
 }

/*
  Channel Login
 */
 if ($p == "clogin") {
   if ($s == "clogout" && $channel) {
     $clogout = 1;
     LogoutChan();
   }
   $tmp = ScanDB("CI",$cname);
   $chana = explode(" ",$tmp[0]);
   if ($passwd) $passwd = ParsePass($passwd);
   if ($l != "clogin" || !$cname || !$passwd || !CLoginCheck($cname,$passwd,$nick) || $chana[0] != $nick) {
  ?>
  <form name="login" method="post" action="web.php">
   <input type="hidden" name="l" value="clogin">
   <input type="hidden" name="f" value="chanserv">
   <input type="hidden" name="p" value="clogin">
   <table width="100%">
    <tr>
     <td align="left" colspan="2">
      <font class="texts">
       <b>Channel Login</b>
      </font>
     </td>
    </tr>
    <tr>
     <td align="justify" colspan="2" width="100%">
      <? if ($l == "clogin") { ?>
       <font class="rtexts">
      <?
       if (!$cname) echo("No channel entered.<br>");
       elseif (!ScanDB("CI",$cname)) {
         echo("Channel does not exist.<br>");
         $areg = 1;
         unset ($cname);
       }
       elseif ($chana[0] != $nick) echo("You're not founder.<br>");
       if (!$passwd) echo("No password entered.<br>");
       elseif (!CLoginCheck($cname,$passwd,$nick) && !$areg) {
         $tmp = "$cname $nick";
         WriteALog("CS:LOGIN",$tmp,$host);
         unset($passwd);
         echo("Password incorrect.<br>");
       }
    ?>
    </font><br>
    <? } ?>
     <font class="desctext"><p align="justify">
      <? if ($clogout) echo("<b>Successfully logged out.</b><br>"); ?>
      <? if ($cnotlogged) echo("<b>You must login first.</b><br>"); ?>
      <? if ($cregd) echo("<b>Channel registered successfully.</b><br>"); ?>
      Fill out the form below and click Login to log in for channel access.
     </p></font>
    </td>
   </tr>
   <tr>
    <td height="5">
    </td>
   </tr>
   <tr>
    <td align="justify" width="20%">
     <font class="texts">
      <b>Channel:</b>
     </font> 
    </td>
    <td align="justify" width="80%">
     <input type="text" name="cname" value="<? echo $cname ?>" size="32" MAXLENGTH="32">
    </td>
   </tr>
   <tr>
    <td align="justify" width="20%">
     <font class="texts">
      <b>Password:</b>
     </font> 
    </td>
    <td align="justify" width="80%">
     <input type="password" name="passwd" value="" size="32" MAXLENGTH="32">
    </td>
   </tr>
   <tr>
    <td align="justify" width="100%" colspan="2" valign="bottom">
     <input type="submit" value="Login" class="buttons"><br><br>
    </td>
   </tr>
   </table>
  </form>
 <?
  }
  else {
    $channel = $cname;
    $cpassword = $passwd;
 ?>
  <table width="100%">
   <tr>
    <td align="left" colspan="2">
     <font class="texts">
      <b><? echo $channel ?> logged in</b>
     </font>
    </td>
   </tr>
   <tr>
    <td align="justify" colspan="2" width="100%">
     <font class="texts">   
      You are now logged in as <? echo $channel ?>. Select an option from the menu to continue.
     </font>
    </td>
   </tr>
  </table>
 <?
  }
 }
}

/*
  NickServ Pages
 */
 if ($f == "nickserv") {

/*
  Drop Nickname
 */
   if ($p == "dropnick" && EnableNickDrop()) {
     if ($name && $passwd) {
       $realpass = ScanDB("NI",$nick);
       $realpass = explode(" ",$realpass[0]);
       $realpass = $realpass[0];
       if (CryptPass() && $passwd) {
         $passwd = crypt($passwd,substr($realpass,0,2));
       }
     }
     if (!$passwd || !$name || !ScanDB("NI",$name) || !LoginCheck($name,$passwd) || $l != "mdropped") {
    ?>
     <form name="dropnick" method="post" action="web.php">
      <input type="hidden" name="l" value="mdropped">
      <input type="hidden" name="f" value="nickserv">
      <input type="hidden" name="p" value="dropnick">
      <table width="100%">
       <tr>
        <td align="left" colspan="2">
         <font class="texts">
          <b>Drop a nickname</b>
         </font>
        </td>
       </tr>
       <tr>
        <td align="justify" colspan="2" width="100%">
         <? if ($l == "mdropped") { ?>
         <font class="rtexts">
         <?
          if (!$name) echo("No nickname entered.<br>");
          elseif (!ScanDB("NI",$name)) {
            echo("$name is not registered.");
            $areg = 1;
            unset($name);
          }
          if (!$areg) {
            if (!$passwd) echo("No password entered.<br>");
            elseif (!LoginCheck($name,$passwd)) {
              unset($passwd);
              echo("Password incorrect.<br>");
            }
          }
         ?>
         </font><br>
        <? } ?>
        <font class="desctext"><p align="justify">
         Please enter the nickname you want to drop and the password for it and click Drop nickname. Once that is done, it cannot be undone! You will lose access on all channels, all of your nickname's settings, and any channels you own and nicknames linked to this one will be dropped as well, and anyone will be able to register them.
        </p></font>
       </td>
      </tr>
      <tr>
       <td height="5">
       </td>
      </tr>
      <tr>
       <td align="justify" width="17%">
        <font class="texts">
         <b>Nick:</b>
        </font> 
       </td>
       <td align="justify" width="83%">
        <input type="text" name="name" value="<? echo $name ?>" size="32" MAXLENGTH="32">
       </td>
      </tr>
      <tr>
       <td align="justify" width="17%">
        <font class="texts">
         <b>Password:</b>
        </font> 
       </td>
       <td align="justify" width="83%">
        <input type="password" name="passwd" value="" size="32" MAXLENGTH="32">
       </td>
      </tr>
      <tr>
       <td align="justify" width="100%" colspan="2" valign="bottom">
        <input type="submit" value="Drop nickname" class="buttons2"><br><br>
       </td>
      </tr>
     </table>
    </form>
   <?
    }
    else {
      DropNick($name);
      $dropped = 1;
      if ($name == $nick) {
        Logout();
        $p = "login";
      }
      else echo("<font class=\"texts\">\n <b>Nickname has been successfully dropped.</b>\n</font>");
    }
  }

/*
  Nickname Registration
 */
  elseif ($p == "regnick" && EnableNickReg()) {
    if ($passwd) $passwd = ParsePass($passwd);
    if ($l != "register" || ScanDB("NI",$name) || !$name || !$passwd || !PassCheck($name,$passwd) || !EmailCheck($email)) {
  ?>
   <form name="dropnick" method="post" action="web.php">
    <input type="hidden" name="l" value="register">
    <input type="hidden" name="f" value="nickserv">
    <input type="hidden" name="p" value="regnick">
    <table width="100%">
    <tr>
     <td align="left" colspan="2">
      <font class="texts">
       <b>Register a nickname</b>
      </font>
     </td>
    </tr>
    <tr>
     <td align="justify" colspan="2" width="100%">
     <? if ($l == "register") { ?>
      <font class="rtexts">
      <?
       if (!$name) echo("<b>No nickname entered.</b><br>");
       elseif (ScanDB("NI",$name)) {
         echo("<b>Nickname is already registered.</b><br>");
         unset($name);
       }
       if (!$passwd) echo("<b>No password entered.</b><br>");
       elseif (strlen($passwd)<5) echo("<b>Password is too short.</b><br>");
         if (!$email) echo("<b>No e-mail address entered.</b><br>");
         elseif (!EmailCheck($email)) {
           echo("<b>Invalid e-mail address.</b><br>");
           unset($email);
         }
      ?>
      </font><br>
      <? } ?>
     <font class="desctext"><p align="justify">
      Please fill out the form below. After you press the Register button, your nickname registration will be queued for processing. Registration of your nickname may take several minutes, so be patient.
     </p></font>
    </td>
   </tr>
   <tr>
    <td height="5">
    </td>
   </tr>
   <tr>
    <td align="justify" width="27%">
     <font class="texts">
      <b>Desired nickname:</b>
     </font> 
    </td>
    <td align="justify" width="73%">
     <input type="text" name="name" value="<? echo $name ?>" size="32" MAXLENGTH="32">
    </td>
   </tr>
   <tr>
    <td align="justify" width="27%">
     <font class="texts">
      <b>Password:</b>
     </font> 
    </td>
    <td align="justify" width="73%">
     <input type="password" name="passwd" value="" size="32" MAXLENGTH="32">
    </td>
   </tr>
   <tr>
    <td align="justify" width="27%">
     <font class="texts">
      <b>E-Mail address:</b>
     </font> 
    </td>
    <td align="justify" width="73%">
     <input type="text" name="email" value="<? echo $email ?>" size="32">
    </td>
   </tr>
   <tr>
    <td align="justify" width="100%" colspan="2" valign="bottom">
     <input type="submit" value="Register!" class="buttons">
    </td>
   </tr>
  </table>
 </form>
 <?
  }
  else {
    RegisterNick($name,$host,$passwd,$email);
    $regd = 1;
    $p = "login";
  }
 }

/*
  Nickname Login
 */
 if ($p == "login") {
 if ($s == "logout" && $nick) {
   $logout = 1;
   Logout();
 }
 if ($passwd) $passwd = ParsePass($passwd);
 if (!$lname || !$passwd || !LoginCheck($lname,$passwd)) {
 ?>
 <form name="login" method="post" action="web.php">
  <input type="hidden" name="l" value="login">
  <input type="hidden" name="f" value="nickserv">
  <input type="hidden" name="p" value="login">
  <table width="100%">
   <tr>
    <td align="left" colspan="2">
     <font class="texts">
      <b>Nickname Login</b>
     </font>
    </td>
   </tr>
   <tr>
    <td align="justify" colspan="2" width="100%">
    <? if ($l == "login") { ?>
     <font class="rtexts">
    <?
     if (!$lname) echo("No nickname entered.<br>");
     elseif (!ScanDB("NI",$lname)) {
       echo("Nickname does not exist.<br>");
       $areg = 1;
       unset($lname);
     }
     if (!$passwd) echo("No password entered.<br>");
     elseif ($passwd && $realpass !== $passwd && !$areg) {
       WriteALog("NS:LOGIN",$lname,$host);
       unset($passwd);
       echo("Password incorrect.<br>");
     }
    ?>
    </font><br>
    <? } ?>
     <font class="desctext"><p align="justify">
      <? if ($dropped) echo("<b>Nickname has been successfully dropped.</b><br>"); ?>
      <? if ($logout) echo("<b>Successfully logged out.</b><br>"); ?>
      <? if ($regd) echo("<b>Nick has been successfully registered.</b><br>"); ?>
      <? if ($notlogged) echo("<b>You must login first.</b><br>"); ?>
      Fill out the form below and click Login to log in for nickname access.
     </p></font>
    </td>
   </tr>
   <tr>
    <td height="5">
    </td>
   </tr>
   <tr>
    <td align="justify" width="20%">
     <font class="texts">
      <b>Nickname:</b>
     </font> 
    </td>
    <td align="justify" width="80%">
     <input type="text" name="lname" value="<? echo $lname ?>" size="32" MAXLENGTH="32">
    </td>
   </tr>
   <tr>
    <td align="justify" width="20%">
     <font class="texts">
      <b>Password:</b>
     </font> 
    </td>
    <td align="justify" width="80%">
     <input type="password" name="passwd" value="" size="32" MAXLENGTH="32">
    </td>
   </tr>
   <tr>
    <td align="justify" width="100%" colspan="2" valign="bottom">
     <input type="submit" value="Login" class="buttons"><br><br>
    </td>
   </tr>
  </table>
 </form>
 <?
  }
  else {
    $nick = $lname;
    $password = $passwd;
    $memos = CheckMemos($nick);
    for ($i=0; $i<sizeof($memos); $i++) {
      if ($memos[$i][0] == "UNREAD") $new++;
    }
    $new = ($new) ? $new : "0";
    $nmemo = ($memos) ? sizeof($memos) : "0";
    $access = ScanChan($nick);
    $naccess = ($access) ? sizeof($access) : "0";
    for ($i=0; $i<sizeof($access); $i++) {
      if ($access[$i][1] == "Founder") $ownz++;
      elseif ($access[$i][1] == "AutoKicked") $delz;
    }
    $naccess = $naccess - $delz;
    $ownz = ($ownz) ? $ownz : "0";
  ?>
  <table width="100%">
   <tr>
    <td align="left" colspan="2">
     <font class="texts">
      <b><? echo $nick ?> logged in</b><br><br>
     </font>
    </td>
   </tr>
   <tr>
    <td align="justify" colspan="2" width="100%">
     <font class="texts">   
      You have <? echo $nmemo ?> memo<? echo($nmemo>1 || $nmemo == 0) ? "s." : "."; ?><br>
      You have access on <? echo $naccess ?> channel<? echo($naccess>1 || $naccess == 0) ? "s." : "."; ?><br>
      You own <? echo $ownz ?> channel<? echo($ownz>1 || $ownz == 0) ? "s." : "."; ?><br><br>
      Select an option from the menu to continue.
     </font>
    </td>
   </tr>
  </table>
  <?
  }
 }
}
 ?>
 </td>
  </tr>
  </table>
 </body>
</html>
