<?
/* Cygnus Web Integration - register.php

   Cygnus IRC Services - Copyright (c) 2001-2002 Darcy Grexton
   Contact: skold@habber.net, skold @ HabberNet

   Original Web Integration scripts by Ray Beliveau

   See doc/LICENSE for licensing details.
 */

    /* Set this to the directory where your web.db and web.log are. This is probably your
       services directory. Your httpd needs read and write access to this directory. This
       can be accomplished with chmod 757.

       Make sure the path below ends with a /
     */
    $path = "/home/user/services/";

    /* If $standalone is set as 1, no HTML code will be printed, and this file can be used
       for inclusions into other php files. If $standalone is set as 0, HTML tags will be
       used to give the page a nice layout.
     */
    $standalone = 0;

    /* Title of the page */
    $title = "Services Registeration Confirmation";

    /* Style sheet for inclusion. A default one is provided in the dist/ directory. */
    $stylesheet = "style.css";

    /* You shouldn't need to edit below this point. */
    $dbname = "web.db";
    $logname = "web.log";

    $name = ($n) ? $n : "#" . $c;
    $nici = ($n) ? "NI" : "CI";
    $spec = ($n) ? "nickname" : "channel";
    $badkey = "The key specified did not match your $spec. Please try again.";
    $badnick = "The $spec $name was not found in the database.";
    $notfound = "Sorry, unable to find database file.";
    $nothing = "A channel or nickname was not specified.";
    $nokey = "A key was not specified for the $spec.";
    $oldreg = "The $spec $name has already been registered.";
    $thanks = "<b>$name</b> has been successfully registered.";

    if (!file_exists ($path))
	$msg = $notfound;

    if (!$n && !$c && !$msg)
	$msg = $nothing;

    if (!$k && !$msg)
	$msg = $nokey;

    $dbfile = fopen ($path . $dbname, "r");

    while (!$msg && $scanstr = fscanf ($dbfile, "%s\x20%s\x20%s\x20%s\x20%s\x20%s\x20%s\n"))
    {
	if (trim ($scanstr[1]) == $name && $scanstr[0] == $nici)
	{
	    $keys = ($n) ? trim ($scanstr[5]) : trim ($scanstr[6]);

	    if ($keys == "0")
		$msg = $oldreg;
	    elseif ($k != $keys)
		$msg = $badkey;
	    else
	    {
		$logfile = fopen ($path . $logname, "a");

		$logentry = ($n) ? "NC" : "CC";
		$logentry .= " $name\n";

		fwrite ($logfile, $logentry, strlen ($logentry));
		fclose ($logfile);
		$msg = $thanks;
	    }
	}
    }

    fclose ($dbfile);

    if (!$keys && !$msg)
	$msg = $badnick;

    if ($standalone == 1)
	echo ("$msg\n");
    else
    {
?>
<html>
 <head>
  <title><? echo $title ?></title>
  <link rel="stylesheet" type="text/css" href="<? echo $stylesheet ?>">
 </head>
 <body>
  <? echo $msg; ?>
 </body>
</html>
<?
    }
?>
